; ### Death Rally by Patai Gergely - 2004/08/06 #################################################

; ### This file is best viewed with 8-character tab stops

.NOLIST

#ifdef TI83V

#define TI83

#endif

#ifdef TI83

#define bcall(xxxx) call xxxx

; ### System calls

_puts		.equ	470Dh	; Displays a string
_xlat2		.equ	4036h	; HL=(HL+A*2)
_vputsn		.equ	4785h	; Displays a string with variable with characters (length in B)

; ### System variables

PENCOL		.equ	8252h	; Pen X position
PENROW		.equ	8253h	; Pen Y position

; ### RAM Pointers

PLOTSSCREEN 	.equ	8E29h	; 768 bytes
SAVESSCREEN	.equ	8265h	; 768 bytes
STATVARS	.equ	858Fh	; 531 bytes

MEMSTART	.equ	$930D
MEMEND		.equ	$9311

#ifdef TI83V

 .org $9329
 .byte "9_[V?", 0		; Venus header

#else

 .org $9327
 ret				; ION header

#endif

#endif

#ifdef TI83P

#define bcall(xxxx) rst 28h \ .word xxxx

; ### System calls

_puts		.equ	450Ah	; Displays a string
_vputsn		.equ	4564h	; Displays a string with variable with characters (length in B)
;_xlat2 was copied into the code

; ### System variables

PENCOL		.equ	86D7h	; Pen X position
PENROW		.equ	86D8h	; Pen Y position

; ### RAM Pointers

PLOTSSCREEN 	.equ	9340h	; 768 bytes
SAVESSCREEN	.equ	86ECh	; 768 bytes
STATVARS	.equ	8A4Ah	; 531 bytes

MEMSTART	.equ	$9824
MEMEND		.equ	$9828

 .org $9D93
 .byte $BB,$6D
 ret				; ION header

#endif

; ### Constants

CHECKPOINTSIZE 		.equ	3	; The real size is this number times 2 plus 1
OPPONENTREACTION	.equ	2	; The minimum number of frames the CPU presses a key
OPPONENTPRECISION	.equ	4	; The angle deviation that does not disturb the CPU
COLLISIONDISTANCE	.equ	28	; The distance of collision detection in half pixels
COLLISIONSTRENGTH	.equ	24	; The strength of the collision force
ENGINESETBACK		.equ	0	; The factor by which engine is set back on collision

#define AddHL(n) ld a,(hl) \ add a,n \ ld (hl),a
#define AdcHL(n) ld a,(hl) \ adc a,n \ ld (hl),a
#define Add24(x,y,z) AddHL(z) \ dec hl \ AdcHL(y) \ dec hl \ AdcHL(x)
#define LDI8 ldi \ ldi \ ldi \ ldi \ ldi \ ldi \ ldi \ ldi

; ### Code part #################################################################################

 jr nc,DeathRally
 .byte "Death Rally",0

; --- Memory check ------------------------------------------------------------------------------

DeathRally:
 ld a,(MEMEND+1)			; Checking free memory before doing anything
 ld bc,(MEMSTART)
 sub b
 cp $1b				; (2048+4608)/256=26 (okay if <a-b)
 jr nc,Core
 ld hl,NotEnoughMem
 bcall(_puts)
 ret

NotEnoughMem:
 .byte "Not enough free memory!",0

; --- Core routines -----------------------------------------------------------------------------

Core:
 im 1				; Needed for MirageOS compatibility
 di
 ld (BackupIY+2),iy		; Saving IY for the TIOS to be able to use it in the program
 ld (BackupSP+1),sp		; Saving SP for the universal return procedure
 res 0,(iy+18)			; Shutting down run indicator (needed b/o using ROM routines)
MenuInit:
 ld hl,Menu_Main
 call InitMenu
MenuLoop:
 call ReadKeyboard		; Reading keypresses
 call ValidateKeys		; Preventing repetition
 ld a,(ValidKey+6)		; 2nd
 and 32
 jp z,ExecuteMenuItem
 ld a,(ValidKey)
 and 1
 call z,Menu_Press_Down
 ld a,(ValidKey)
 and 8
 call z,Menu_Press_Up
 call ShowMenuItem
 jr MenuLoop

Exit_With_Wait:
 ld hl,PLOTSSCREEN
 push hl
 call ClearScreen
 pop hl
 call FlipScreen 
Wait_Key:			; Waits until 2nd is released then quits
 call ReadKeyboard
 ld a,(KeyPressed+6)
 and 32
 jr z,Wait_Key

Universal_Return:		; This is the code to be run on returning to the OS
BackupSP:
 ld sp,0			; Recalling SP
BackupIY:
 ld iy,0			; Recalling IY (not POP, because we need IY inside the program)
 ei
 ret

#ifdef TI83P

_xlat2:				; HL=(HL+A*2)
 add a,a
 ld e,a
 ld d,0
 add hl,de
 ld a,(hl)
 inc hl
 ld h,(hl)
 ld l,a
 ret

#endif

; --- The actual game: main loops ---------------------------------------------------------------

Race_P:				; Race in practice mode
 call SetupPracticePointers	; Arranges memory for the practice part
 call ClearVariables		; Clears the variables of the players
 ld a,(CarChosen)
 call PrepareSprites		; Pregenerating the pictures of the cars
 ld a,(TrackChosen)
 call PrepareTrackData		; Drawing the track to TrackData

 ; temporary setup

 ld hl,(TrackPtr)
 inc hl
 inc hl
 inc hl
 ld c,(hl)
 inc hl
 ld b,(hl)
 ld a,(CoordX)
 ld (Player_X),a
 ld (Opponent_X),a
 add a,2
 sub b
 ld b,a
 ld a,(CoordY)
 ld (Player_Y),a
 ld (Opponent_Y),a
 add a,2
 sub c
 ld c,a
 call ArcTan2_BC
 xor 128
 ld (Player_Angle),a
 ld (Opponent_Angle),a
 add a,64
 push af
 ld c,a
 ld b,128
 ld hl,Player_X
 push bc
 push hl
 call CalculateVector
 pop hl
 pop bc
 call CalculateVector
 pop af
 xor 128
 ld c,a
 ld b,128
 ld hl,Opponent_X
 push bc
 push hl
 call CalculateVector
 pop hl
 pop bc
 call CalculateVector

 ld a,(CarChosen)
 add a,a
 ld b,a
 add a,a
 add a,b
 sub 247
 cpl
 ld (Player_Friction),a
 ld (Opponent_Friction),a
 ld a,4				; Three laps
 ld (RaceLength),a

 call FillBackGroundPattern	; Drawing the initial background on PLOTSSCREEN
 call CalculateScreenPosition	; Setting up the screen coordinates as well
 ld a,(CoordX+2)
 ld (CoordXf+2),a
 ld a,(CoordX+1)
 and 15
 ld (CoordXf+1),a
 ld a,(CoordY+2)
 ld (CoordYf+2),a
 ld a,(CoordY+1)
 and 15
 ld (CoordYf+1),a
 ld hl,CoordX+2
 Add24($fa,$00,$00)
 ld b,12			; Screen is filled using the DrawRight routine
RaceDrawBKG:
 push bc
 ld hl,CoordX+2
 Add24($00,$80,$00)
 ld hl,PLOTSSCREEN
 ld bc,1
 call ScrollUniversal
 call DrawRight
 pop bc
 djnz RaceDrawBKG
 ld b,3
 ld hl,CountDown
RaceCountDown:
 push bc
 push hl
 call RenderFrame		; Rendering a starting frame (no movement possible)
 pop hl
 ld de,SAVESSCREEN+305		; The position of the number
 ld bc,$1002
 call AlignMaskedSprite
 push hl
 ld hl,SAVESSCREEN
 call FlipScreen		; Displaying the frame
 ld d,b				; B is zero here
 ld e,d
 ld b,3				; Delay
RCD_delay:
 dec de
 ld a,e
 or d
 jr nz,RCD_delay
 djnz RCD_delay
 pop hl
 pop bc
 djnz RaceCountDown
RaceLoop:
 call RenderFrame		; Rendering the current frame and moving the players
 ld hl,SAVESSCREEN
 call FlipScreen		; Displaying the frame
 call HandleOpponent		; Moving the CPU player (calculating its reactions)
 call ReadKeyboard		; Handling keypresses
 ld a,(KeyPressed+1)		; CLEAR
 and 64
 jp z,Universal_Return		; Completely quit the program
 ld a,(KeyPressed+6)		; MODE
 and 64
 ret z				; Quit the race
 ld a,(Standings)		; Disabling controls if the race is over
 or a
 jr nz,RaceLoop
 xor a				; Clearing arrow key presses
 ld (KeyPresses),a
 ld a,(KeyPressed+0) \ and $01 \ call z,Set_Down	; Down arrow
 ld a,(KeyPressed+0) \ and $08 \ call z,Set_Up		; Up arrow
 ld a,(KeyPressed+0) \ and $02 \ call z,Set_Left	; Left arrow
 ld a,(KeyPressed+0) \ and $04 \ call z,Set_Right	; Right arrow
 ld a,(KeyPressed+5) \ and $80 \ call z,Set_Down	; Alpha
 ld a,(KeyPressed+6) \ and $20 \ call z,Set_Up		; 2nd
 ld a,(KeyPressed+3) \ and $02 \ call z,Set_Down	; 2
 ld a,(KeyPressed+3) \ and $08 \ call z,Set_Up		; 8
 ld a,(KeyPressed+4) \ and $04 \ call z,Set_Left	; 4
 ld a,(KeyPressed+2) \ and $04 \ call z,Set_Right	; 6
 ld ix,PlayerData		; Doing arrow actions
 ld a,(KeyPresses) \ and 1 \ call nz,Press_Down		; Brake/reverse
 ld a,(KeyPresses) \ and 8 \ call nz,Press_Up		; Accelerate
 ld a,(KeyPresses) \ and 2 \ call nz,Press_Left		; Steer left
 ld a,(KeyPresses) \ and 4 \ call nz,Press_Right	; Steer right
 jp RaceLoop

Set_Down:
 ld a,(KeyPresses)
 or 1
 jr KP_writeBack

Set_Up:
 ld a,(KeyPresses)
 or 8
 jr KP_writeBack

Set_Left:
 ld a,(KeyPresses)
 or 2
 jr KP_writeBack

Set_Right:
 ld a,(KeyPresses)
 or 4
 jr KP_writeBack

KP_writeBack:
 ld (KeyPresses),a
 ret

; --- Controls (these routines do not exclude each other in the same frame) ---------------------

Press_Down:			; Routine for deceleration
 ld a,(ix+12)			; Velocity
 add a,16
 cp $7f
 ret nc
 sub 18
 ld (ix+12),a
 ret

Press_Up:			; Routine for acceleration
 ld a,(ix+12)			; Velocity
 sub 96
 cp $60
 ret c
 add a,98
 ld (ix+12),a
 ret

Press_Left:			; Routine for steering left
 ld a,(ix+12)			; Velocity
 ld l,a
 rla
 sbc a,a
 ld h,a
 add hl,hl
 add hl,hl
 add hl,hl
 ex de,hl
 ld h,(ix+15)			; Angle
 ld l,(ix+16)
 sbc hl,de
 ld (ix+15),h
 ld (ix+16),l
 ret

Press_Right:			; Routine for steering right
 ld a,(ix+12)			; Velocity
 ld l,a
 rla
 sbc a,a
 ld h,a
 add hl,hl
 add hl,hl
 add hl,hl
 ex de,hl
 ld h,(ix+15)			; Angle
 ld l,(ix+16)
 add hl,de
 ld (ix+15),h
 ld (ix+16),l
 ret

; --- Calculations ------------------------------------------------------------------------------

HandleOpponent:			; Moves the CPU player automatically (sort of AI...)
 ld ix,OpponentData
 call Press_Up			; Accelerate...
 ld a,(Opponent_Reaction)
 or a
 jr z,HO_CanTurn
 dec a
 ld (Opponent_Reaction),a
 ld a,(Opponent_Dir)
 or a
 jr z,Press_Right
 jr Press_Left

HO_CanTurn:
 ld hl,(TrackPtr)		; Getting the current checkpoint coordinates (H, L)
 inc hl
 ld a,(Opponent_ChkPoint)
 ld b,a
 call _xlat2
 ld a,(Opponent_X)		; Calculating the direction towards this point
 add a,2
 sub h
 ld b,a
 ld a,(Opponent_Y)
 add a,2
 sub l
 ld c,a
 call ArcTan2_BC
 xor 128
 ld b,a
 ld a,(Opponent_Angle)		; Comparing it with the actual direction of the car
 sub b
HO_hackPrecision:
 add a,OPPONENTPRECISION
 cp OPPONENTPRECISION * 2 + 1
 ret c
HO_hackReaction:
 ld a,OPPONENTREACTION
 ld (Opponent_Reaction),a	; Initialising the reaction time counter
 ld a,0
 ld (Opponent_Dir),a		; 0 denotes right turn
 jp m,Press_Right		; Steering towards the next checkpoint
 ld a,1
 ld (Opponent_Dir),a		; 1 (actually any nonzero) denotes left turn
 jp Press_Left

CalculateVector:		; Calculates a vector with angle C and length B
 inc hl				; and adds it to the coordinates pointed at by HL
 inc hl
 ld (CV_Addr1+1),hl
 inc hl
 inc hl
 inc hl 
 ld (CV_Addr2+1),hl
 ld d,0
 push bc			; Calculating X component
 ld e,c
 call Mul_B_sinDE
 ld b,h
 ld c,l
 ld a,b
 rla
 sbc a,a
 ld d,a
CV_Addr1:
 ld hl,0
 Add24(d,b,c)
 pop bc				; Calculating Y component
 ld a,c
 sub 64
 ld e,a
 ld d,0
 call Mul_B_sinDE
 ld b,h
 ld c,l
 ld a,b
 rl a
 sbc a,a
 ld d,a
CV_Addr2:
 ld hl,0
 Add24(d,b,c)
 ret

MovePlayer:			; Moving a player with the variable system at IX
 push ix
 pop hl
 ld de,14
 add hl,de
 ld a,(ix+12)
 or a
 jr z,MP_VelOK
 jp p,MP_VelPos
 Add24($00,$60,$00)
 jr MP_VelOK
MP_VelPos:
 Add24($ff,$80,$00)
MP_VelOK:
 ld hl,0			; Initialising (clearing) temporary variables
 ld (MP_XVect),hl
 ld (MP_XVect+2),hl
 ld (MP_XVect+4),hl
 ld b,(ix+18)
 call MP_MulFriction		; Calculating current velocity times friction
 ld a,(ix+12)			; Player target velocity (integer part)
 ld b,a
 ld a,(ix+15)			; Player target angle (integer part)
 ld c,a
 ld hl,MP_XVect
 call CalculateVector
 ld hl,MP_XProduct
 ld de,MP_FinalProduct
 ld bc,8
 ldir
 push ix
 xor a
 sub (ix+18)
 ld b,a
 ld ix,MP_XVect-6
 call MP_MulFriction		; Calculating target velocity times (256-friction)
 ld hl,MP_XProduct
 ld de,MP_FinalProduct
 pop ix
 ld a,(de) \ add a,(hl) \ inc hl \ inc de			; Calculating final VX
 ld a,(de) \ adc a,(hl) \ ld (ix+8),a \ inc hl \ inc de
 ld a,(de) \ adc a,(hl) \ ld (ix+7),a \ inc hl \ inc de
 ld a,(de) \ adc a,(hl) \ ld (ix+6),a \ inc hl \ inc de
 ld a,(de) \ add a,(hl) \ inc hl \ inc de			; Calculating final VY
 ld a,(de) \ adc a,(hl) \ ld (ix+11),a \ inc hl \ inc de
 ld a,(de) \ adc a,(hl) \ ld (ix+10),a \ inc hl \ inc de
 ld a,(de) \ adc a,(hl) \ ld (ix+9),a \ inc hl \ inc de
 push ix			; Adding the velocity to the position
 pop hl
 ld bc,6
 add hl,bc
 dec hl
 ld d,h
 ld e,l
 add hl,bc
 ld b,2
MP_addVect:
 ld a,(de) \ add a,(hl) \ ld (de),a \ dec de \ dec hl
 ld a,(de) \ adc a,(hl) \ ld (de),a \ dec de \ dec hl
 ld a,(de) \ adc a,(hl) \ ld (de),a \ dec de \ dec hl
 djnz MP_addVect
 ret

MP_MulFriction:			; Calculates B*vector (B contains friction)
 ld hl,0
 ld (MP_XProduct+2),hl
 ld (MP_YProduct+2),hl
 ld a,b				; XProduct=Friction*VX
 ld e,(ix+8)
 ld d,0
 call Mul_A_DE
 ld (MP_XProduct),hl
 ld a,b
 ld e,(ix+7)
 ld d,0
 call Mul_A_DE
 ld de,(MP_XProduct+1)
 add hl,de
 ld (MP_XProduct+1),hl
 ld e,(ix+6)
 ld a,e
 rla
 sbc a,a
 ld d,a
 ld a,b
 call Mul_A_DE
 ld de,(MP_XProduct+2)
 add hl,de
 ld (MP_XProduct+2),hl
 ld a,b				; YProduct=Friction*VY
 ld e,(ix+11)
 ld d,0
 call Mul_A_DE
 ld (MP_YProduct),hl
 ld a,b
 ld e,(ix+10)
 ld d,0
 call Mul_A_DE
 ld de,(MP_YProduct+1)
 add hl,de
 ld (MP_YProduct+1),hl
 ld e,(ix+9)
 ld a,e
 rla
 sbc a,a
 ld d,a
 ld a,b
 call Mul_A_DE
 ld de,(MP_YProduct+2)
 add hl,de
 ld (MP_YProduct+2),hl
 ret

CalculateScreenPosition:	; Calculating the new CoordX and CoordY from the player's data
 ld hl,Player_X
 ld de,CoordX
 ld bc,6
 ldir
 ret

HandleCollision:		; Detecting and handling collision
 ld ix,Player_X			; Checking horizontal distance
 call CoordDifference
 ld ix,Player_Y			; Checking vertical distance
 call CoordDifference

 ; This is where mask overlapping should be checked

 ld hl,(Player_X)		; Determining the relative direction of the two players
 sra l \ rr h \ sra l \ rr h \ sra l \ rr h 
 ld de,(Opponent_X)
 sra e \ rr d \ sra e \ rr d \ sra e \ rr d
 ld a,h
 sub d
 ld b,a
 ld hl,(Player_Y)
 sra l \ rr h \ sra l \ rr h \ sra l \ rr h 
 ld de,(Opponent_Y)
 sra e \ rr d \ sra e \ rr d \ sra e \ rr d
 ld a,h
 sub d
 ld c,a
 call ArcTan2_BC		; The angle goes into A
 push af
 ld c,a
HC_collHack1:
 ld b,COLLISIONSTRENGTH
 ld hl,Player_VX
 call CalculateVector		; Force on the player
 pop af
 xor 128
 ld c,a
HC_collHack2:
 ld b,COLLISIONSTRENGTH
 ld hl,Opponent_VX
 call CalculateVector		; Force on the opponent
 ld a,(Player_Velocity)		; Engine setback
 sub ENGINESETBACK
 jr nc,HC_okPEngine
 xor a
HC_okPEngine:
 ld (Player_Velocity),a
 ld a,(Opponent_Velocity)
HC_collHack3:
 sub ENGINESETBACK
 jr nc,HC_okOEngine
 xor a
HC_okOEngine:
 ld (Opponent_Velocity),a
 ret

CoordDifference:		; If the absolute value is too big, returns above the caller
 ld l,(ix)			; Reading the coordinates of the players
 ld h,(ix+1)
 ld e,(ix+OpponentData-PlayerData)
 ld d,(ix+OpponentData-PlayerData+1)
 ld a,(ix+7)			; Adding velocity to get screen position
 sra a
 sra a
 cpl
 ld b,a
 add a,h
 ld h,a
 jr nc,CD_POK
 inc l
CD_POK:
 sla b
 sbc a,a
 add a,l
 ld l,a
 ld a,(ix+OpponentData-PlayerData+7)
 sra a
 sra a
 cpl
 ld b,a
 add a,d
 ld d,a
 jr nc,CD_OOK
 inc e
CD_OOK:
 sla b
 sbc a,a
 add a,e
 ld e,a
 ld a,l				; Difference is calculated here
 sub e
 cp 3
 jr c,CD_verif
 cp -2
 jr c,CD_retFar			; The coordinates are too far (determined fast)
CD_verif:
 sra l \ rr h \ sra l \ rr h \ sra l \ rr h	; Getting the relevant bits into H and D
 sra e \ rr d \ sra e \ rr d \ sra e \ rr d
 ld a,h				; Calculating a more precise difference
 sub d
 cp COLLISIONDISTANCE
 ret c
 cp 1-COLLISIONDISTANCE
 ret nc
CD_retFar:
 pop hl				; Leaving out the calling routine
 ret

; --- Gameplay: checking the race standings -----------------------------------------------------

CheckPosition:			; Verifying checkpoints and race standings in general
 ld a,(Standings)		; Nothing to do if there is already a winner
 or a
 ret nz
 ld hl,(TrackPtr)		; Getting the current checkpoint coordinates
 inc hl
 ld a,(ix+20)			; Checkpoint identifier
 ld b,a
 call _xlat2
 ld a,(ix+0)			; Comparing them to the player's position
 add a,CHECKPOINTSIZE+2
 cp h
 ret c
 sub CHECKPOINTSIZE*2+1
 cp h
 ret nc
 ld a,(ix+3)
 add a,CHECKPOINTSIZE+2
 cp l
 ret c
 sub CHECKPOINTSIZE*2+1
 cp l
 ret nc
 inc b
 ld hl,(TrackPtr)
 ld a,(hl)
 cp b
 jr nc,CP_FinishOK
 ld b,0				; The next checkpoint is the finish line
CP_FinishOK:
 ld a,b
 ld (ix+20),a			; Checkpoint
 cp 1
 ret nz
 ld a,(ix+19)			; The finish line was just passed
 inc a
 ld (ix+19),a			; Lap increase
 ld de,(RaceLength)
 cp e
 ret c
 ld a,c
 ld (Standings),a		; Modify standings if someone finished
 ret

; --- Rendering the frame (speed critical routines!) --------------------------------------------

RenderFrame:			; Rendering the current frame (no input)
 ld hl,CoordX			; Making a backup of screen coordinates for MoveBackGround
 ld de,BUCoordX
 ld bc,6
 ldir
 ld ix,PlayerData
 call MovePlayer		; Recalculating the state of the player (position and velocity)
 ld c,1				; Value to write into Standings if finished (player id)
 call CheckPosition		; Verifying the position (checkpoints, laps)
 ld ix,OpponentData
 call MovePlayer
 ld c,2
 call CheckPosition
 call HandleCollision		; Handling collision (not while practicing)
 call CalculateScreenPosition	; Converting the player's data into screen coordinates
 call MoveBackGround		; Moving the background and copying it to the virtual screen
 ld hl,PLOTSSCREEN
 ld de,SAVESSCREEN
 call CopyBackGround
 call DrawOpponent		; Drawing the ghost driver (CPU)
 ld ix,PlayerData		; Drawing the player
 ld bc,$2515
 ld hl,(CarSprites)
 call DisplayPlayer
 call DrawHUD
 ld a,(Standings)		; Displaying results if the race is over
 or a
 ret z
 ld hl,FinishYou
 ld de,SAVESSCREEN+314
 ld bc,$0c04
 call AlignMaskedSprite
 ld hl,FinishWin
 ld a,(Standings)
 dec a
 jr z,RF_draw
 ld hl,FinishLose
RF_draw:
 ld de,SAVESSCREEN+318
 ld bc,$0c04
 jp AlignMaskedSprite

DrawOpponent:			; Drawing the opponent with respect to the player
 ld a,(Player_X)
 ld bc,(Opponent_X)
 sub c
 cp 5
 jr c,DO_Xokay
 cp -4
 ret c				; The opponent is too far to be on screen
DO_Xokay:
 ld a,(Player_Y)
 ld bc,(Opponent_Y)
 sub c
 cp 4
 jr c,DO_Yokay
 cp -3
 ret c				; The opponent is too far to be on screen
DO_Yokay:
 ld de,(Player_X)		; Calculating X position
 ld hl,(Opponent_X)
 ld a,e \ sla d \ rla \ sla d \ rla \ sla d \ rla \ sla d \ rla \ ld b,a
 ld a,l \ sla h \ rla \ sla h \ rla \ sla h \ rla \ sla h \ rla \ sub b
 add a,$25
 ld b,a
 ld de,(Player_Y)		; Calculating Y position
 ld hl,(Opponent_Y)
 ld a,e \ sla d \ rla \ sla d \ rla \ sla d \ rla \ sla d \ rla \ ld c,a
 ld a,l \ sla h \ rla \ sla h \ rla \ sla h \ rla \ sla h \ rla \ sub c
 add a,$15
 ld c,a
 ld ix,OpponentData
 ld hl,(CarSprites)
; ld de,4608			; This part should not be ran while practicing
; add hl,de

DisplayPlayer:			; Displays a player's sprite - player data at IX, sprites at HL
 ld a,(ix+7) \ sra a \ sra a \ cpl \ add a,b \ ld b,a	; Player velocity X component
 ld a,(ix+10) \ sra a \ sra a \ cpl \ add a,c \ ld c,a	; Player velocity Y component
 ld a,(ix+15)						; Player angle
 push hl
 pop ix
 jp DrawPlayerSprite

MoveBackGround:			; Moving background from BUCoordX-Y to CoordX-Y
 ld hl,BUCoordY+2		; Calculating the difference between new and old coordinates
 ld ix,CoordY+2
 ld iy,BUCoordYf+2
 ld b,2
MBG_CalcDiff:
 ld a,(ix) \ dec ix \ sub (hl) \ dec hl \ ld (iy),a \ dec iy
 ld a,(ix) \ dec ix \ sbc a,(hl) \ dec hl \ ld (iy),a \ dec iy
 ld a,(ix) \ dec ix \ sbc a,(hl) \ dec hl \ ld (iy),a \ dec iy
 djnz MBG_CalcDiff
 ld bc,(BUCoordXf)		; Calculating the fractions used for the scrolling
 ld d,(iy+3)
 ld hl,CoordXf+2
 Add24(c,b,d)
 ld bc,(BUCoordYf)
 ld d,(iy+6)
 ld hl,CoordYf+2
 Add24(c,b,d)
 ld a,(CoordYf+1)		; Vertical scrolling
 srl a \ srl a \ srl a \ srl a
 jp z,MBG_Yf0			; Nothing to do for Y
 cp 1
 jr nz,MBG_not01
 ld bc,12			; Scrolling up by 1 pixel
 ld hl,PLOTSSCREEN
 call ScrollUniversal
 ld hl,BackGroundPattern+4
 ld (DTB_hackBGP+1),hl
 ld hl,PLOTSSCREEN+756
 ld (DTB_hackDest+1),hl
 ld hl,CoordY+2
 Add24($ff,$f0,$00)
 call DrawTopBottom
 ld hl,CoordY+2
 Add24($00,$10,$00)
 jp MBG_Moved
MBG_not01:
 cp 15
 jr nz,MBG_notM1
 ld bc,-12			; Scrolling down by 1 pixel
 ld hl,PLOTSSCREEN
 call ScrollUniversal
 ld hl,BackGroundPattern
 ld (DTB_hackBGP+1),hl
 ld hl,PLOTSSCREEN
 ld (DTB_hackDest+1),hl
 call DrawTopBottom
 jp MBG_Moved
MBG_notM1:
 cp 2
 jr nz,MBG_not02
 ld bc,24			; Scrolling up by 2 pixels
 ld hl,PLOTSSCREEN
 call ScrollUniversal
 ld hl,BackGroundPattern+4
 ld (DTB_hackBGP+1),hl
 ld hl,PLOTSSCREEN+756
 ld (DTB_hackDest+1),hl
 ld hl,CoordY+2
 Add24($ff,$f0,$00)
 call DrawTopBottom
 ld hl,PLOTSSCREEN+744
 ld (DTB_hackDest+1),hl
 ld hl,CoordY+2
 Add24($ff,$f0,$00)
 call DrawTopBottom
 ld hl,CoordY+2
 Add24($00,$20,$00)
 jp MBG_Moved
MBG_not02:
 cp 14
 jr nz,MBG_notM2
 ld bc,-24			; Scrolling down by 2 pixels
 ld hl,PLOTSSCREEN
 call ScrollUniversal
 ld hl,BackGroundPattern
 ld (DTB_hackBGP+1),hl
 ld hl,PLOTSSCREEN
 ld (DTB_hackDest+1),hl
 call DrawTopBottom
 ld hl,PLOTSSCREEN+12
 ld (DTB_hackDest+1),hl
 ld hl,CoordY+2
 Add24($00,$10,$00)
 call DrawTopBottom
 ld hl,CoordY+2
 Add24($ff,$f0,$00)
 jp MBG_Moved
MBG_notM2:
 cp 3
 jr nz,MBG_not03
 ld bc,36			; Scrolling up by 3 pixels
 ld hl,PLOTSSCREEN
 call ScrollUniversal
 ld hl,BackGroundPattern+4
 ld (DTB_hackBGP+1),hl
 ld hl,PLOTSSCREEN+756
 ld (DTB_hackDest+1),hl
 ld hl,CoordY+2
 Add24($ff,$f0,$00)
 call DrawTopBottom
 ld hl,PLOTSSCREEN+744
 ld (DTB_hackDest+1),hl
 ld hl,CoordY+2
 Add24($ff,$f0,$00)
 call DrawTopBottom
 ld hl,PLOTSSCREEN+732
 ld (DTB_hackDest+1),hl
 ld hl,CoordY+2
 Add24($ff,$f0,$00)
 call DrawTopBottom
 ld hl,CoordY+2
 Add24($00,$30,$00)
 jp MBG_Moved
MBG_not03:
 cp 13
 jr nz,MBG_notM3
 ld bc,-36			; Scrolling down by 3 pixels
 ld hl,PLOTSSCREEN
 call ScrollUniversal
 ld hl,BackGroundPattern
 ld (DTB_hackBGP+1),hl
 ld hl,PLOTSSCREEN
 ld (DTB_hackDest+1),hl
 call DrawTopBottom
 ld hl,PLOTSSCREEN+12
 ld (DTB_hackDest+1),hl
 ld hl,CoordY+2
 Add24($00,$10,$00)
 call DrawTopBottom
 ld hl,PLOTSSCREEN+24
 ld (DTB_hackDest+1),hl
 ld hl,CoordY+2
 Add24($00,$10,$00)
 call DrawTopBottom
 ld hl,CoordY+2
 Add24($ff,$e0,$00)
MBG_notM3:
MBG_Moved:
 ld a,(CoordYf+1)		; Clearing delta Y
 and 15
 ld (CoordYf+1),a
MBG_Yf0:
 ld bc,ScrollLeft		; Horizontal scrolling
 ld de,DrawRight 
 ld a,(CoordXf+1)
 cp $80
 jp c,MBG_okLR
 ld bc,ScrollRight
 ld de,DrawLeft
 cpl
 add a,17
MBG_okLR:
 ld (MBG_LR+1),bc
 ld (MBG_LR+4),de
 srl a \ srl a \ srl a \ srl a
 ret z
 ld hl,PLOTSSCREEN
MBG_LR:
 call 0				; Actual SMC calls: Scroll+Draw
 call 0
 ld a,(CoordXf+1)		; Clearing delta X
 and 15
 ld (CoordXf+1),a
 ret

#include "render.inc"		; Routines used to draw the frames

; --- Preparing for the race (not time critical) ------------------------------------------------

#include "prepare.inc"		; All the relevant routines

; --- Included code libraries -------------------------------------------------------------------

#include "graph.inc"		; Graphics routines
#include "math.inc"		; Fast math routines
#include "input.inc"		; Direct input

; --- Game menu ---------------------------------------------------------------------------------

#include "menu.inc"		; Game menu routines (with data at the end)

; ### Data ######################################################################################

;FrameCounter:
; .byte 0,0,0

; --- Static game data source -------------------------------------------------------------------

#include "tiles.inc"		; Tile maps of the track
#include "title.inc"		; The picture shown above the menu
#include "miscpic.inc"		; Miscellaneous pictures for the arcade part
#include "cardata.inc"		; All the car related data
#include "trkdata.inc"		; Tracks
#include "miscdata.inc"		; Miscellaneous data (look at the file for further information)

Credits1:
 .byte 21,30,13,"Programmed by"
Credits2:
 .byte 25,38,13,"Patai Gergely"
Credits3:
 .byte 22,48,14,"Budapest, 2002"
Credits4:
 .byte 71,57,6,"-MODE-"

; --- Heap description - temporary data ---------------------------------------------------------

Heap		.equ	STATVARS	; 531 bytes of free memory

; --- Data needed for polygon drawer ------------------------------------------------------------

PolyData	.equ	Heap	; The polygon drawer looks for this label (might be EQU address!)
				; +0: Temporary drawing screen
				; +2: Destination screen
				; +4: Shade (0->8: white->black)
				; +5: Number of vertices-1
BackGroundPattern	.equ    Heap+6	; 12 bytes, polygon vertices and track data

; --- Temporary local variables -----------------------------------------------------------------

; Abbrev.	Subroutine using it	Bytes used
; DTB		DrawTopBottom		1
; MP		MovePlayer		22

; Heap set 1

PolyBackup	.equ	Heap+18	; 12 bytes, rotated vertices are backed up here to draw the
				; outlines; must immediately follow BackGroundPattern!

; Heap set 2

TrackID		.equ	Heap+18	; 10 bytes, would conflict with DTB variables
DTB_stepFlag	.equ	Heap+29	; 1 byte

; Heap set 3

MP_XProduct	.equ	Heap+18 ; 4 bytes
MP_YProduct	.equ	Heap+22 ; 4 bytes
MP_XVect	.equ	Heap+26 ; 3 bytes
MP_YVect	.equ	Heap+29 ; 3 bytes
MP_FinalProduct	.equ	Heap+32 ; 8 bytes

; --- Globals description - temporary global variables ------------------------------------------

Globals		.equ	Heap+100

; --- Data pointers -----------------------------------------------------------------------------

TrackData	.equ	Globals	; Place for the bitmap image of the track map (2048 bytes)
CarSprites	.equ	Globals+2	; Sprites for the player (2*32*72=4608 bytes)
OppCarSprites	.equ	Globals+4	; Sprites for the opponent (2*32*72=4608 bytes)

; --- Static game data --------------------------------------------------------------------------

StaticData	.equ	Globals+6	; Static data start here

TrackChosen	.equ	StaticData	; 1 byte, ID of the current track
TrackPtr	.equ	StaticData+1	; 2 bytes, Pointer to track data
CarChosen	.equ	StaticData+3	; 1 byte, ID of the current car
CarData		.equ	StaticData+4	; 2 bytes, Pointer to car data
OppCarChosen	.equ	StaticData+6	; 1 byte, ID of the current car of the opponent
OppCarData	.equ	StaticData+7	; 2 bytes, Pointer to car data of the opponent
RaceLength	.equ	StaticData+9	; 1 byte, the number of laps in the race

; --- Dynamic game data -------------------------------------------------------------------------

DynamicData	.equ	StaticData+10	; Dynamic data start here

Standings	.equ	DynamicData	; 0: racing, 1: player won, 2: opponent won
KeyPresses	.equ	DynamicData+1	; Direction bits (set if direction key pressed)
ScreenCoords	.equ	DynamicData+2	; Position and velocity of the screen

CoordX		.equ	ScreenCoords	; 3 bytes
CoordY		.equ	ScreenCoords+3	; 3 bytes
CoordXf		.equ	ScreenCoords+6	; 3 bytes
CoordYf		.equ	ScreenCoords+9	; 3 bytes

BUCoordX	.equ	ScreenCoords+12	; 3 bytes
BUCoordY	.equ	ScreenCoords+15	; 3 bytes
BUCoordXf	.equ	ScreenCoords+18	; 3 bytes
BUCoordYf	.equ	ScreenCoords+21	; 3 bytes

PlayerData	.equ	ScreenCoords+24	; Variables of the player's car

Player_X	.equ	PlayerData	; 3 bytes, player X position
Player_Y	.equ	PlayerData+3	; 3 bytes, player Y position
Player_VX	.equ	PlayerData+6	; 3 bytes, player velocity X component
Player_VY	.equ	PlayerData+9	; 3 bytes, player velocity Y component
Player_Velocity	.equ	PlayerData+12	; 3 bytes, player target velocity absolute value
Player_Angle	.equ	PlayerData+15	; 3 bytes, player target velocity direction
Player_Friction	.equ	PlayerData+18	; 1 byte, a factor affecting the driving properties
Player_Lap	.equ	PlayerData+19	; 1 byte, the current lap of the player
Player_ChkPoint	.equ	PlayerData+20	; 1 byte, the current checkpoint position of the player

OpponentData	.equ	PlayerData+21	; Variables of the opponent's car (CPU driver)

Opponent_X		.equ	OpponentData
Opponent_Y		.equ	OpponentData+3
Opponent_VX		.equ	OpponentData+6
Opponent_Velocity	.equ	OpponentData+12
Opponent_Angle		.equ	OpponentData+15
Opponent_Friction	.equ	OpponentData+18
Opponent_Lap		.equ	OpponentData+19
Opponent_ChkPoint	.equ	OpponentData+20
Opponent_Reaction	.equ	OpponentData+21 ; 1 byte, the reaction time counter of the CPU
Opponent_Dir		.equ	OpponentData+22 ; 1 byte, the direction the CPU turns towards

EndLabel	.equ	OpponentData+23	; The first unused byte

.end
END