;----------------------------------------------------------------------------
;[ PutSprClp ] [ABCDEFIX]                         [ 177 bytes ] [ CrASH_Man ]
;----------------------------------------------------------------------------
; Draws a sprite with an AND/XOR mask with clipping
;
; parameters: HL -> sprite, (B,C) = coordinates
; returns:    Puts sprite in GRAPH_MEM
;
PutSprClp:      XOR  A
__Change_1:     LD   DE, DefaultSpriteHeight      ; D = 0, E = Height

                OR   C                            ; If C < 0
                JP   M, _PSC_NoBotClp             ; No bottom clip.

                LD   A, $3F                       ; Is C is offscreen?
                SUB  C
                RET  C

__Change_2:     CP   DefaultSpriteHeight-1        ; If C + 7 < 64
                JR   NC, _PSC_NoVertClp           ; No vertical clip.
                INC  A
                LD   E, A
                JR   _PSC_NoVertClp               ; Height = 64 - C

_PSC_NoBotClp:
__Change_3:     CP   -(DefaultSpriteHeight-1)     ; Is C is offscreen?
                RET  C

                ADD  A, E                         ; Find how many lines
                LD   C, A                         ; to actually draw
                SUB  E

                NEG
                LD   E, A
                ADD  HL, DE                       ; Move HL down
                LD   E, C                         ; by -C lines
                LD   C, D

_PSC_NoVertClp: PUSH HL                           ; IX -> Sprite
                POP  IX

                LD   A, $77                       ; OP code for
                LD   (_PSC_OPchg_1), A            ;   LD   (HL), A
                LD   (_PSC_OPchg_2), A

                XOR  A                            ; Is B > 0?
                OR   B
                JP   M, _PSC_NoRightClp

                CP   89                           ; Is B < 89?
                JR   C, _PSC_ClpDone
                CP   96
                RET  NC

                LD   HL, _PSC_OPchg_1             ; Modify LD to NOP
                JR   _PSC_ClpModify

_PSC_NoRightClp:CP   -7                           ; Is B is offscreen?
                RET  C

                LD   HL, _PSC_OPchg_2             ; Modify LD to NOP
_PSC_ClpModify: LD   (HL), D

_PSC_ClpDone:   LD   B, D
                LD   H, B
                LD   L, C
                ADD  HL, BC                       ; HL = Y * 12
                ADD  HL, BC
                ADD  HL, HL
                ADD  HL, HL

                LD   C, A                         ; HL = Y*12 + X/8
                SRA  C
                SRA  C
                SRA  C
                INC  C

                ADD  HL, BC
                LD   BC, GRAPH_MEM
                ADD  HL, BC

                LD   B, E                         ; B = number of rows

                AND  %00000111                    ; find number of
                LD   E, A                         ; instructions to jump
                ADD  A, E
                ADD  A, E
                LD   (_PSC_OPchg_4 + 1), A        ; 3 * number
                SUB  22
                CPL
                LD   (_PSC_OPchg_3 + 1), A        ; 3 * (7 - number)

_PSC_LineLoop:  LD   C, (IX)
                SCF
                SBC  A, A
_PSC_OPchg_3:   JR   _PSC_OPchg_3                 ; modify

                RR   C
                RRA
                RR   C
                RRA
                RR   C
                RRA
                RR   C
                RRA
                RR   C
                RRA
                RR   C
                RRA
                RR   C
                RRA

                AND  (HL)                         ; AND with background
                LD   E, A
__Change_4:     LD   A, (IX+DefaultSpriteHeight)
_PSC_OPchg_4:   JR   _PSC_OPchg_4                 ; modify

                RLA
                RL   D
                RLA
                RL   D
                RLA
                RL   D
                RLA
                RL   D
                RLA
                RL   D
                RLA
                RL   D
                RLA
                RL   D
                RLA
                RL   D

                XOR  E                            ; XOR with background
_PSC_OPchg_1:   LD   (HL), A                      ; Write
                DEC  HL                           ; HL -> next 8 pixels

                LD   A, C
                AND  (HL)                         ; AND with background
                XOR  D                            ; XOR with background
_PSC_OPchg_2:   LD   (HL), A                      ; Write
                INC  IX                           ; Increment to next data

                LD   DE, 13                       ; HL -> next row
                ADD  HL, DE
                DJNZ _PSC_LineLoop
                RET

#IFNDEF NO_MOD_AX
;----------------------------------------------------------------------------
;[ SetSpriteHeight ] [A]                           [ 16 bytes ] [ CrASH_Man ]
;----------------------------------------------------------------------------
; Changes the default sprite size
;
; parameters: A = New Sprite Height
; returns:    Self modified routine.
;
SetSpriteHeight:LD   (__Change_1+1), A
                LD   (__Change_4+2), A
                DEC  A
                LD   (__Change_2+1), A
                NEG
                LD   (__Change_3+1), A
                RET
#ENDIF
