;----------------------------------------------------------------------------
; SpriteTest v1.3 for SpriteClip v3.0 AND/XOR version by CrASH_Man  04/25/99
;----------------------------------------------------------------------------
;   Will not run if an interrupt is loaded.
;
;   The arrow keys will move the sprite.
;   2nd slows down the sprite.
;   Mode quits.
;
;   This is program is example source for CrASH to test the sprite clipping
; routines inside SPR30AX.INC.
;
;   If you use this routine or any other routines in your programs, please
; remember to give me credit for my work.
;
;   Please read SPR30.TXT inside the archive if you need more help.
;
;                                            [ CrASH_Man ]
;                                               crashman@crashware.lfx.org

.INCLUDE CrASH82.INC

DefaultSpriteHeight = 8    ; This is the default for the sprite height
#DEFINE NO_MOD_AX          ; Define this if you don't need to modify the
                           ;    sprite height during program execution

Sprite_Coord = TEXT_MEM

.DB             "Sprite Test v1.3", 0

                LD   A, (INT_STATE)
                OR   A
                RET  NZ

                LD   HL, APD_BUF                  ; Fill APD_BUF with 0
                LD   DE, APD_BUF + 1
                LD   BC, 768
                LD   (HL), A
                LDIR

                DEC  A
                LD   HL, APD_BUF + 11
                LD   (HL), A
                DEC  HL
                LD   (HL), A
                DEC  HL
                LD   (HL), A

                LD   HL, APD_BUF + 2              ; Make the screen
                LD   (HL), A
                DEC  HL
                LD   (HL), A
                DEC  HL
                LD   (HL), A

                LD   DE, APD_BUF+12
                LD   BC, 12*19                    ; 19 rows
                LDIR

                LD   HL, APD_BUF
                LD   DE, APD_BUF+528
                LD   BC, 12*20                    ; 20 rows
                LDIR

                LD   HL, $2C1C                    ; Center Sprite (44, 28)
                LD   (Sprite_Coord), HL

KeyLoop:        LD   HL, APD_BUF
                LD   DE, GRAPH_MEM
                LD   BC, 768
                LDIR

                LD   BC, (Sprite_Coord)           ; Load Sprite Coordinates
                LD   HL, Spr                      ; Point to sprite
                CALL PutSprClp
                CALL CR_GRBCopy

                LD   A, $FF                       ; Reset Port
                OUT  ($01), A
                LD   A, $BF
                OUT  ($01), A                     ; Mask out MODE and 2nd
                IN   A, ($01)
                BIT  6, A
                RET  Z                            ; If MODE pressed, done
                BIT  5, A
                CALL Z, Delay                     ; If 2nd pressed, delay

                LD   HL, Sprite_Coord

                LD   A, $FE
                OUT  ($01), A                     ; Mask out Arrows
                IN   A, ($01)
                BIT  0, A
                CALL Z, DownOrRight
                BIT  3, A
                CALL Z, UpOrLeft
                INC  HL
                BIT  1, A
                CALL Z, UpOrLeft
                BIT  2, A
                CALL Z, DownOrRight

                JR  KeyLoop

Delay:          LD   B, 10
_DelayLoop:     HALT
                DJNZ _DelayLoop
                RET
UpOrLeft:       DEC  (HL)
                RET
DownOrRight:    INC  (HL)
                RET

.INCLUDE SPR30AX.INC

Spr:
.DB  %11100111 ; AND mask
.DB  %11000011
.DB  %10000001
.DB  %00011000
.DB  %00011000
.DB  %10000001
.DB  %11000011
.DB  %11100111

.DB  %00011000 ; XOR mask
.DB  %00100100
.DB  %01000010
.DB  %10011001
.DB  %10011001
.DB  %01000010
.DB  %00100100
.DB  %00011000
