;----------------------------------------------------------------------------
;                    SpriteClip v1.3 by CrASH_Man                   03/25/99
;----------------------------------------------------------------------------
;
;   This is an extremely optimized clipping sprite routine (8 by X) for
; TI-82 programmers.  This routine incorporates AND/XOR masking, which is
; described below.
;
;   For an example on how to use this routine, please take a look at
; SPRTEST.ASM.
;
;   You may use this routine in your programs, but please give me credit
; for my work by including my name in the documentation and source.
;
;                                            [ CrASH_Man ]
;                                               crashman@crashware.lfx.org
;
;----------------------------------------------------------------------------
; Usage:
;----------------------------------------------------------------------------
;  CALL PutSprClp         Puts a sprite pointed by HL at (B, C) in GRAPH_MEM
;  CALL SetSpriteHeight   Sets the height of sprites used by PutSprClp to A
;
; DefaultSpriteHeight needed for compiling, as an integer definition.
;
;----------------------------------------------------------------------------
; The AND/XOR mask
;----------------------------------------------------------------------------
;   The AND mask is first put on the screen, then the XOR is put on the
; screen.  The result turns out so that:
;
;   00 = White           01 = Black
;   10 = Unchanged       11 = Inverted
;
; For example:
; ------------
;  AND mask     +  XOR mask        Result
;
; .DB %11100111   .DB 00011000  =  UUUBBUUU      W is white
; .DB %11000011   .DB 00100100  =  UUBWWBUU      B is black
; .DB %10000001   .DB 01000010  =  UBWWWWBU      U is unchanged
; .DB %00011000   .DB 10011001  =  BWWIIWWB      I is inverted
; .DB %00011000   .DB 10011001  =  BWWIIWWB
; .DB %10000001   .DB 01000010  =  UBWWWWBU
; .DB %11000011   .DB 00100100  =  UUBWWBUU
; .DB %11100111   .DB 00011000  =  UUUBBUUU
;
;----------------------------------------------------------------------------
; Revision History:
;----------------------------------------------------------------------------
;  0.9 10/04/97 - Complete clipping except for minor bug in top-left corner.
;  1.0 10/05/97 - Complete clipping anywhere...  Kewl!!
;  1.1 10/09/97 - Clipping w/OR XOR Masks, variable sprite height
;  1.2 02/14/98 - Clipping w/AND XOR Masks, no more EX or EXX used
;  1.3 03/25/99 - Optimized code (faster, smaller, self-modifying code)
;                 Removed the saving of all registers.

;----------------------------------------------------------------------------
;[ PutSprClp ] [ABCDEFIX]                         [ 156 bytes ] [ CrASH_Man ]
;----------------------------------------------------------------------------
; Places a sprite with an AND/XOR mask with clipping
;
; parameters: HL -> sprite, (B,C) = coordinates
; returns:    puts sprite
;
PutSprClp:      LD   A, $77                       ; OP code for
                LD   (_PSC_OPchg_1), A            ;   LD   (HL), A
                LD   (_PSC_OPchg_2), A

__Change_1:     LD   DE, DefaultSpriteHeight      ; D = 0, E = Height
                BIT  7, C                         ; If C < 0
                JR   NZ, _PSC_NoBotClp            ; No bottom clip.

                LD   A, 63                        ; Is C is offscreen?
                SUB  C
                RET  C

__Change_2:     CP   DefaultSpriteHeight-1        ; If C + 7 < 64
                JR   NC, _PSC_NoVertClp           ; No vertical clip.
                INC  A
                JR   _PSC_ClpTop                  ; Height = 64 - C

_PSC_NoBotClp:  LD   A, C
__Change_3:     CP   -(DefaultSpriteHeight-1)     ; Is C is offscreen?
                RET  C

                LD   C, A                         ; Draw -C lines
                NEG
                LD   E, A
                LD   A, C
__Change_4:     ADD  A, DefaultSpriteHeight       ; Move HL down
                ADD  HL, DE                       ; by -C lines
                LD   C, D

_PSC_ClpTop:    LD   E, A

_PSC_NoVertClp: PUSH HL                           ; IX -> Sprite
                POP  IX

                XOR  A                            ; Is B > 0?
                OR   B
                JP   P, _PSC_NoLeftClp

                CP   -7                           ; Is B is offscreen?
                RET  C

                XOR  A                            ; Modify LD to NOP
                LD   (_PSC_OPchg_1), A
                JR   _PSC_ClpDone

_PSC_NoLeftClp: SUB  89                           ; Is B < 89?
                JR   C, _PSC_ClpDone
                CP   7
                RET  NC

                XOR  A                            ; Modify LD to NOP
                LD   (_PSC_OPchg_2), A

_PSC_ClpDone:   LD   A, B
                LD   B, D
                LD   H, B
                LD   L, C
                ADD  HL, BC                       ; HL = Y * 12
                ADD  HL, BC
                ADD  HL, HL
                ADD  HL, HL

                LD   C, A                         ; HL = Y*12 + X/8
                SRA  C
                SRA  C
                SRA  C
                JP   P, _PSC_NoSX
                DEC  B

_PSC_NoSX:      ADD  HL, BC
                LD   BC, GRAPH_MEM
                ADD  HL, BC

                LD   B, E                         ; B = number of rows
                AND  %00000111
                JR   Z, _PSC_Aligned

                LD   (_PSC_OPchg_3 + 1), A        ; Modify number of shifts
                LD   C, %11111111                 ; AND mask extension

_PSC_LineLoop:  PUSH BC
__Change_5:     LD   D, (IX+DefaultSpriteHeight)
                LD   E, %00000000                 ; OR mask extension
                LD   A, (IX)
_PSC_OPchg_3:   LD   B, 0                         ; Number of shifts
_PSC_ShiftNum:  SCF                               ; Shift AND mask
                RRA
                RR   C
                SRL  D                            ; Shift OR mask
                RR   E
                DJNZ _PSC_ShiftNum
                AND  (HL)                         ; AND with background
                XOR  D                            ; XOR with background
_PSC_OPchg_1:   LD   (HL), A                      ; Write
                INC  HL
                LD   A, C
                AND  (HL)                         ; AND with background
                XOR  E                            ; XOR with background
_PSC_OPchg_2:   LD   (HL), A                      ; Write
                INC  IX                           ; Increment to next data
                LD   C, 11                        ; Move to next row
                ADD  HL, BC
                POP  BC
                DJNZ _PSC_LineLoop

                RET

_PSC_Aligned:   LD   E, 12                        ; Add 12 each row
_PSC_AlignLoop: LD   A, (HL)
                AND  (IX)                         ; AND with background
__Change_6:     XOR  (IX+DefaultSpriteHeight)     ; XOR with background
                LD   (HL), A                      ; Write
                ADD  HL, DE
                INC  IX
                DJNZ _PSC_AlignLoop

                RET

;----------------------------------------------------------------------------
;[ SetSpriteHeight ] [A]                           [ 22 bytes ] [ CrASH_Man ]
;----------------------------------------------------------------------------
; Changes the default sprite size
;
; parameters: A = New Sprite Height
; returns:    Self modified routine.
;
SetSpriteHeight:LD   (__Change_1+1), A
                LD   (__Change_2+1), A
                LD   (__Change_4+1), A
                LD   (__Change_5+2), A
                LD   (__Change_6+2), A
                DEC A
                NEG
                LD   (__Change_3+1), A
                RET
