;
; SpriteClip - Fast Sprite Clipping Routine with Masks for ASH3 v1.1 10/09/97
;               by Hideaki Omuro
;
; Revision History:
;  0.9 10/04/97 - Complete clipping except for minor bug in top-left corner.
;  1.0 10/05/97 - Complete clipping anywhere...  Kewl!!            163 bytes
;  1.1 10/09/97 - Clipping w/OR XOR Masks, variable sprite height  183 bytes
;
; Notes:
; ------
;   DefaultSpriteHeight needed for compiling
;
; This is how an OR / XOR mask works:
;
;  OR mask      +  XOR mask        Result
;
; .DB %00011000   .DB 00000000  =     11
; .DB %00111100   .DB 00011000  =    1001
; .DB %01111110   .DB 00111100  =   100001
; .DB %11111111   .DB 01100110  =  10011001
; .DB %11111111   .DB 01100110  =  10011001
; .DB %01111110   .DB 00111100  =   100001
; .DB %00111100   .DB 00011000  =    1001
; .DB %00011000   .DB 00000000  =     11
;
; The OR mask is put on the screen, then the XOR is put on the screen.
; The result turns out so that:
;
;   00 = Normal    01 = Invert
;   10 = Black     11 = White
;
;
; PutSprClp - Puts a sprite with clipping and or/xor mask (quite fast)
; Inputs: (B, C) coordinates, HL -> sprite
; OutPut: Puts clipped sprite
;

PutSprClp:
  PUSH BC \ PUSH DE \ PUSH HL \ PUSH IX ; Save Registers
  PUSH HL \ POP IX              ; LD  IX, HL

__Change_1:
  LD  D, DefaultSpriteHeight
  BIT 7, C \ JR  NZ, _PSC_NoBotClip ; If Y is negative, clip top
_PSC_BotClip:
  LD  A, 63
  SUB C \ JP  C, _PSC_Done
__Change_2:
  CP  DefaultSpriteHeight-1
  JR  NC, _PSC_NoVertClip ; If the sprite fits, done clipping

  INC A
  JR  _PSC_ClipTop
_PSC_NoBotClip:
  LD  A, C
__Change_3:
  CP  -(DefaultSpriteHeight-1)
  JR  C, _PSC_Done     ; If Y < -(DefaultSpriteHeight-1) then done
_PSC_TopClip:
  LD  L, A
  NEG \ LD  E, A       ; Find number to shift
  LD  A, L
__Change_4:
  ADD A, DefaultSpriteHeight
  LD  D, 0 \ ADD IX, DE
  LD  C, D             ; C = 0 or -1 if at top-left (quickfix)
_PSC_ClipTop:
  LD  D, A
_PSC_NoVertClip:
  LD  E, $FF \ LD  A, B
  BIT 7, A \ JR  Z, _PSC_NoLeftClip ; If X is non-negative, check right side
_PSC_LeftClip:
  CP  -7 \ JR  C, _PSC_Done     ; If X is less than -7, done
  NEG \ LD  H, B \ LD  B, A     ; Find number to shift right
_PSC_LeftLoop:
  SRL E                         ; Shift mask to right
  DJNZ _PSC_LeftLoop
  LD  A, H \ ADD A, 96 \ LD  B, A ; Shift sprite up a row.
  JR  _PSC_ClipDone2
_PSC_NoLeftClip:
  SUB 89 \ JR C, _PSC_ClipDone  ; If X < 89 then no need to clip on right
_PSC_RightClip:
  CP  7 \ JR NC, _PSC_Done      ; If Shift # > 7 then done
  LD  H, B \ LD  B, A \ INC B
_PSC_RightLoop:
  SLA E                         ; Shift mask to left
  DJNZ _PSC_RightLoop
  LD  B, H
_PSC_ClipDone:
  INC C
_PSC_ClipDone2:
  LD  A, B \ LD  B, 0           ; [11] Save B, Clear B so we can add BC
  LD  H, B \ LD  L, C           ; [ 8] HL = BC
  ADD HL, BC \ ADD HL, BC       ; [22] HL = HL + 12
  ADD HL, HL \ ADD HL, HL       ; [22]
  LD  C, A                      ; [ 4]
  SRL C \ SRL C \ SRL C         ; [24] C = B \ 8
  ADD HL, BC                    ; [11]
  LD  BC, GRAPH_MEM-12          ; [10]
  ADD HL, BC                    ; [11]
  LD  B, D                      ; Number of Rows

  AND %00000111                 ; [ 7]
  JR  Z, _PSC_NoShift

  LD  C, A                      ; Number to Shift
;  LD  A, E
_PSC_LineLoop:
  PUSH BC
  PUSH DE
;  LD  E, A
;  EX  AF, AF'
  LD  A, E
__Change_5:
  AND (IX+DefaultSpriteHeight)
  LD  D, A
  LD  A, E
  AND (IX+0)
  LD  B, C
  LD  C, 0
  LD  E, C

_PSC_ShiftNum:
  RRA \ RR  C
  RR  D \ RR  E                 ; Shift
  DJNZ _PSC_ShiftNum

  OR  (HL) \ XOR D \ LD (HL), A \ INC HL    ; Or data with background
  LD  A, C \ OR  (HL) \ XOR E \ LD  (HL), A ; Xor Mask, etc.
;  EX  AF, AF'

  INC IX \ LD  C, 11 \ ADD HL, BC ; Next row
  POP DE
  POP BC
  DJNZ _PSC_LineLoop

_PSC_Done:
  POP IX \ POP HL \ POP DE \ POP BC ; Restore registers
  RET

_PSC_NoShift:
  LD  DE, 12                    ; Add 12 each row
_PSC_NoShiftLoop:
  LD  A, (HL)
  OR  (IX+0)
__Change_6:
  XOR (IX+DefaultSpriteHeight)
  LD  (HL), A                   ; Or data with background
  ADD HL, DE \ INC IX           ; Next row
  DJNZ _PSC_NoShiftLoop

  JR _PSC_Done

; Input:  A = Sprite Height
; Output: Self modifies routine to sprites that are A pixels in height.
SetSpriteHeight:
  LD  (__Change_1+1), A
  LD  (__Change_2+1), A
  LD  (__Change_4+1), A
  LD  (__Change_5+2), A
  LD  (__Change_6+2), A
  DEC A
  NEG
  LD  (__Change_3+1), A
  RET

.END
