;
; SpriteClip - Fast Sprite Clipping Routine for ASH3           v1.0 10/05/97
;               by Hideaki Omuro
; Revision History:
;  0.9 - Clipped correctly except for a minor bug in the top-left corner.
;  1.0 - Complete clipping anywhere...  Kewl!!  163 bytes
;
; PutSprClp - Puts a sprite with clipping
; Inputs: (B, C) coordinates, HL -> sprite
; OutPut: Puts clipped sprite
;
PutSprClp:
  PUSH BC \ PUSH DE \ PUSH HL \ PUSH IX ; Save Registers
  PUSH HL \ POP IX              ; LD  IX, HL

  LD  DE, $08FF
  BIT 7, C \ JR  NZ, _PSC_NoBotClip ; If Y is negative, clip top
_PSC_BotClip:
  LD  A, 63
  SUB C \ JR  C, _PSC_Done
  INC A \ CP  8 \ JR  NC, _PSC_NoVertClip ; If the sprite fits, done clipping

  JR  _PSC_ClipTop
_PSC_NoBotClip:
  LD  A, C
  CP  -7 \ JR  C, _PSC_Done     ; If Y < -7 then done
_PSC_TopClip:
  NEG \ LD  H, B \ LD  C, A     ; Find number to shift
  SUB 8 \ NEG \ LD  B, 0 \ ADD IX, BC
  LD  C, B \ LD B, H            ; C = 0 or -1 if at top-left (quickfix)
_PSC_ClipTop:
  LD  D, A
_PSC_NoVertClip:
  LD  A, B
  BIT 7, A \ JR  Z, _PSC_NoLeftClip ; If X is non-negative, check right side
_PSC_LeftClip:
  CP  -7 \ JR  C, _PSC_Done     ; If X is less than -7, done
  NEG \ LD  H, B \ LD  B, A     ; Find number to shift right
_PSC_LeftLoop:
  SRL E                         ; Shift mask to right
  DJNZ _PSC_LeftLoop
  LD  A, H \ SUB 160 \ LD  B, A
  DEC C                         ; Shift sprite up a row.
  JR  _PSC_ClipDone
_PSC_NoLeftClip:
  SUB 89 \ JR C, _PSC_ClipDone  ; If X < 89 then no need to clip on right
_PSC_RightClip:
  CP  7 \ JR NC, _PSC_Done      ; If Shift # > 7 then done
  LD  H, B \ LD  B, A \ INC B
_PSC_RightLoop:
  SLA E                         ; Shift mask to left
  DJNZ _PSC_RightLoop
  LD  B, H
_PSC_ClipDone:
  INC C
  LD  A, B \ LD  B, 0           ; [11] Save B, Clear B so we can add BC
  LD  H, B \ LD  L, C           ; [ 8] HL = BC
  ADD HL, BC \ ADD HL, BC       ; [22] HL = HL + 12
  ADD HL, HL \ ADD HL, HL       ; [22]
  LD  C, A                      ; [ 4]
  SRL C \ SRL C \ SRL C         ; [24] C = B \ 8
  ADD HL, BC                    ; [11]
  LD  BC, GRAPH_MEM-12          ; [10]
  ADD HL, BC                    ; [11]
  LD  B, D                      ; Number of Rows

  AND %00000111                 ; [ 7]
  JR  Z, _PSC_NoShift

  LD  C, A                      ; Number to Shift
_PSC_LineLoop:
  PUSH BC
  LD  A, E                      ; Mask
  AND (IX+0)
  LD  B, C \ LD  C, 0
_PSC_ShiftNum:
  RRA \ RR  C                   ; Shift
  DJNZ _PSC_ShiftNum

  OR  (HL) \ LD (HL), A \ INC HL ; Or data with background
  LD  A, C \ OR  (HL) \ LD  (HL), A

  INC IX \ LD  C, 11 \ ADD HL, BC ; Next row
  POP BC
  DJNZ _PSC_LineLoop

_PSC_Done:
  POP IX \ POP HL \ POP DE \ POP BC ; Restore registers
  RET

_PSC_NoShift:
  LD  DE, 12                    ; Add 12 each row
_PSC_NoShiftLoop:
  LD  A, (HL) \ OR  (IX+0) \ LD  (HL), A ; Or data with background
  ADD HL, DE \ INC IX           ; Next row
  DJNZ _PSC_NoShiftLoop

  JR _PSC_Done

.END
