;             *** TI82 Graphics rutines ***
; This file holds four rutines used to do graphics on the
; TI82. These rutines operates on one pixel at a time, and
; are therefore rather slow. If alot of graphis is used in
; a program write commands directly to the controller.
;
; GetPixel  : This function will get the pixel at b,c into a
; Point_on  : Turn on point in b,c
; Point_off : Turn off point in b,c
; Point_chg : Change point in b,c
;
; To use these rutines the rom page MUST be set to page 4,
; because the graphics rutines are placed here. The busy
; counter has to be turn of too, otherwise "random" pixels
; might be shown on the display.
;
; The define GRAPH_START from graph.h sets the rom page to 
; 4 amd clears the display.
;
; This files needs ti82.h to assemble correctly.
;
; If you want you can use these rutines in you own program
; as long as you give me the credit for my work. Just include
; a line in the documentation which includes my name and where
; you got the rutines from. Again, unless you only need to
; update a few pixels, use the display controller directly.
;
; (C) Dines Justesen 1997
;

; All functions uses TI's layout of the display. The layout is shown
; below.
;
; (0,63) ------------ (96,63)
;   |                    |
;   |                    |
;   |                    |
;   |                    |
; (0,0) ------------- (96,0)

;____________________________________________________________________________
;
; GetPixel : Get the value at b,c
;____________________________________________________________________________
GetPixel:
	PUSH BC
        CALL FIND_PIXEL ; HL=byte offset in video buffer, A=2^(bit to change)
        LD B,A
        LD A,($8011)        ; Goto line
        CALL $07F3
        OUT ($10),A
        LD A,($800F)        ; Goto byte
        CALL $07F3
        OUT ($10),A
        CALL $07F3          ; Get byte
        IN A,($11)
        CALL $07F3
	IN A,($11)
        AND B               ; Mask, so only one pixel left
        POP BC
        RET
;____________________________________________________________________________
;
; Point_on : Turn on point at b,c
;____________________________________________________________________________
Point_on:
	PUSH BC
        CALL FIND_PIXEL
        LD B,A
        LD A,($8011)        ; Goto line
        CALL $7F3
        OUT ($10),A
        LD A,($800F)        ; Goto byte
        CALL 7F3h
        OUT ($10),A
        CALL $7F3
        IN A,($11)          ; Get byte
        CALL $7F3
	IN A,($11)
        OR B                ; Set pixel
        LD B,A
        LD A,($8011)        ; Goto line
        CALL $7F3
        OUT ($10),A
        LD A,($800F)        ; Goto byte
        CALL $7F3
        OUT ($10),A
        LD A,B
        CALL $7F3
        OUT ($11),A
        POP BC
	RET

;____________________________________________________________________________
;
; Point_off : Turn on point at b,c
;____________________________________________________________________________

Point_off:
	PUSH BC
        CALL FIND_PIXEL
        XOR $0FF            ; Invert mask
        LD B,A
        LD A,($8011)        ; Goto line
        CALL $7F3
        OUT ($10),A
        LD A,($800F)        ; Goto byte
        CALL $7F3
        OUT ($10),A
        CALL $7F3
	IN A,($11)          ; Get byte
        CALL $7F3
	IN A,($11)
        AND B
        LD B,A
        LD A,($8011)        ; Goto line
        CALL $7F3
        OUT ($10),A
        LD A,($800F)        ; Goto byte
        CALL $7F3
        OUT ($10),A
        LD A,B
        CALL $7F3
        OUT ($11),A
        POP BC
	RET

;____________________________________________________________________________
;
; Point_chg : Turn on point at b,c
;____________________________________________________________________________
Point_chg:
	PUSH BC
        CALL FIND_PIXEL
        LD B,A
        LD A,($8011)
        CALL $7F3
        OUT ($10),A
        LD A,($800F)
        CALL $7F3
        OUT ($10),A
        CALL $7F3
        IN A,($11)          ; Get byte
        CALL $7F3
	IN A,($11)
        XOR B               ; Invert pixel
        LD B,A
        LD A,($8011)
        CALL $7F3
        OUT ($10),A
        LD A,($800F)
        CALL $7F3
        OUT ($10),A
        LD A,B
        CALL $7F3
        OUT ($11),A
        POP BC
	RET
