.INCLUDE "TI82.H"
.INCLUDE "KEYS.INC"
.DEFINE TX_STRING(addr)       LD HL,addr \ ROM_CALL(D_ZT_STR)
.DEFINE M_STRING(addr)        LD HL,addr \ ROM_CALL(D_ZM_STR)
;
; ARK! v1.1
; by Randy Gluvna
; gluvna@home.com
; http://members.home.com/gluvna/
;
; Variables:
;
VAR_SECRET      = TEXT_MEM    ; byte (boolean)
PADDLE_X        = TEXT_MEM+1  ; byte
BALL_X          = TEXT_MEM+2  ; byte
BALL_Y          = TEXT_MEM+3  ; byte
BALL_ACTIVE     = TEXT_MEM+4  ; byte (boolean)
BALL_UP         = TEXT_MEM+5  ; byte (boolean)
BALL_DELAY      = TEXT_MEM+6  ; byte
BALL_SLOPE_X    = TEXT_MEM+7  ; byte
BALL_SLOPE_Y    = TEXT_MEM+8  ; byte
BALL_SPEED      = TEXT_MEM+9  ; byte
LEVEL           = TEXT_MEM+10 ; byte
LIVES           = TEXT_MEM+11 ; byte
SCORE           = TEXT_MEM+12 ; word
BOARD           = TEXT_MEM+14 ; 64-bytes
;
.ORG START_ADDR

.DB "ARK! v1.1",0

        XOR A
        LD (VAR_SECRET),A     
INIT:
        LD A,$8C
        OUT (2),A
        LD A,6
        OUT (4),A                        
MENU:
        CALL FADE_OUT
        ROM_CALL(CLEARLCD)
        LD HL,PIC_ARKTITLE
        CALL DISP_PIC
        LD HL,$2310
        LD (CURSOR_X),HL
        M_STRING(STRING_HIGH2)
        LD A,(CURSOR_X)
        ADD A,17
        LD (CURSOR_X),A
        LD HL,(SAVE_HIGH+7)
        CALL D_HL_MENU
        CALL FADE_IN
MENU_1:
        LD D,55
        LD E,24
        CALL DEL_8X8_BLOCK
        LD D,45
        LD E,24
        LD HL,SPRITE_BALL
        CALL PUT_8X8_SPRITE
        CALL GET_KEY
        CP G_UP
        JR Z,MENU_2
        CP G_DOWN
        JR Z,MENU_2
        CP G_ENTER
        JR Z,NEW_GAME
        CP G_MODE
        RET Z
        CP G_CLEAR
        RET Z
        CALL CHECK_SECRET
        JR MENU_1
MENU_2:
        LD D,45
        LD E,24
        CALL DEL_8X8_BLOCK
        LD D,55
        LD E,24
        LD HL,SPRITE_BALL
        CALL PUT_8X8_SPRITE
        CALL GET_KEY
        CP G_UP
        JR Z,MENU_1
        CP G_DOWN
        JR Z,MENU_1
        CP G_ENTER
        JP Z,CONTINUE
        CP G_MODE
        RET Z
        CP G_CLEAR
        RET Z
        CALL CHECK_SECRET
        JR MENU_2
CHECK_SECRET:
        LD A,%11010101
        OUT (1),A
        IN A,(1)
        CP %10100111
        JP Z,SECRET
        RET
NEW_GAME:
        LD A,1
        LD (LEVEL),A
        LD A,5
        LD (LIVES),A
        LD HL,$0000
        LD (SCORE),HL
NEW_LEVEL:
        CALL COPY_LEVEL
START_GAME:      
        LD A,59
        LD (BALL_X),A
        LD A,7
        LD (BALL_Y),A
        XOR A
        LD (BALL_ACTIVE),A
        LD (BALL_DELAY),A
        LD A,1
        LD (BALL_SLOPE_X),A
        LD A,2
        LD (BALL_SLOPE_Y),A
        LD A,55
        LD (PADDLE_X),A
        LD A,2                
        LD (BALL_SPEED),A          
        CALL DISP_LEVEL
        LD HL,PIC_ARKBOARD
        CALL DISP_PIC
        CALL PADDLE
        CALL BALL_ON
        CALL DISP_LIVES
        CALL DISP_SCORE                   
        CALL READY
        CALL PUT_LEVEL
        CALL FADE_IN
        LD A,(CONTRAST)
        CP $1D
        JR NC,GAME_WAIT
        ADD A,$E2
        CALL DISP_DELAY
        OUT ($10),A
GAME_WAIT:
        CALL PADDLE
        LD HL,BALL_DELAY
        LD A,(HL)
        INC (HL)
        LD HL,BALL_SPEED
        LD B,(HL)
        CP B       
        JR NZ,GAME_WAIT_2      
        XOR A
        LD (BALL_DELAY),A                 
        LD A,(BALL_ACTIVE)
        OR A
        CALL NZ,BALL_MOVE
GAME_WAIT_2:
        LD HL,$0000
GAME_WAIT_3:
        INC HL      
        LD DE,$0260
        CALL CP_HL_DE
        JR NZ,GAME_WAIT_3           
        LD A,$DF
        OUT (1),A
        IN A,(1)
        BIT 1,A
        JR Z,SAVE_GAME
        LD A,$BE
        OUT (1),A
        IN A,(1)             
        BIT 6,A
        JP Z,MENU       
        BIT 7,A
        JP Z,PAUSE          
        BIT 3,A
        JP Z,BALL_LAUNCH
        CP %11111101
        JP Z,PADDLE_LEFT
        CP %11111011
        JP Z,PADDLE_RIGHT                             
        LD A,(VAR_SECRET)
        OR A
        JR Z,GAME_WAIT_5
        LD A,%11101011
        OUT (1),A
        IN A,(1)
        CP %11001111
        JP Z,SECRET_1
GAME_WAIT_5:
        LD HL,$0000
GAME_WAIT_4:
        INC HL     
        LD DE,$0046
        CALL CP_HL_DE
        JR NZ,GAME_WAIT_4
        JR GAME_WAIT                        
SAVE_GAME:
        LD A,(LEVEL)
        LD (SAVE_LEVEL),A
        LD A,(LIVES)
        LD (SAVE_LIVES),A
        LD HL,(SCORE)
        LD (SAVE_SCORE),HL
        LD HL,BOARD
        LD DE,SAVE_BOARD
        LD BC,64
        LDIR
        LD A,(CONTRAST)
        ADD A,$DE
        CALL DISP_DELAY
        OUT ($10),A
        RET
CONTINUE:
        LD A,(SAVE_LEVEL)
        LD (LEVEL),A
        OR A
        JP Z,MENU_2
        LD A,(SAVE_LIVES)
        LD (LIVES),A
        LD HL,(SAVE_SCORE)
        LD (SCORE),HL
        LD HL,SAVE_BOARD
        LD DE,BOARD
        LD BC,64
        LDIR
        JP START_GAME
SECRET:
        LD A,1
        LD (VAR_SECRET),A
        RET
SECRET_1:                
        CALL FADE_OUT                
        ROM_CALL(CLEARLCD)
        LD HL,$0000
        LD (CURSOR_ROW),HL
        SET 3,(IY+05)
        LD B,16
SECRET_2:
        LD A,$E1
        ROM_CALL(TX_CHARPUT)
        DJNZ SECRET_2
        RES 3,(IY+05)
        CALL FADE_IN
SECRET_3:
        LD HL,$0002
        LD (CURSOR_ROW),HL       
        TX_STRING(STRING_LEVEL)
        LD A,(SAVE_LEVEL)
        LD L,A
        LD H,0
        ROM_CALL(D_HL_DECI)
        LD HL,$0003
        LD (CURSOR_ROW),HL      
        TX_STRING(STRING_LIVES)
        LD A,(SAVE_LIVES)
        LD L,A
        LD H,0
        ROM_CALL(D_HL_DECI)                  
SECRET_4:
        CALL GET_KEY            
        CP G_UP
        JR Z,S_LEVEL
        CP G_RIGTH
        JR Z,S_LIVES           
        CP G_DOWN
        JR Z,SD_LEVEL
        CP G_LEFT
        JR Z,SD_LIVES
        CP G_ENTER
        JR Z,S_QUIT
        CP G_MODE
        JR Z,S_QUIT
        CP G_CLEAR
        JR Z,S_QUIT
        JR SECRET_3
S_LEVEL:        
        LD HL,SAVE_LEVEL
        LD A,(HL)
        CP 10
        JR NC,SECRET_3
        INC (HL)
        JR SECRET_3
S_LIVES:
        LD HL,SAVE_LIVES
        LD A,(HL)
        CP 9
        JR NC,SECRET_3
        INC (HL)
        JR SECRET_3
SD_LEVEL:
        LD HL,SAVE_LEVEL
        LD A,(HL)
        CP 2
        JR C,SECRET_3
        DEC (HL)
        JR SECRET_3
SD_LIVES:
        LD HL,SAVE_LIVES
        LD A,(HL)
        CP 2
        JR C,SECRET_3
        DEC (HL)
        JR SECRET_3
S_QUIT:
        LD A,(SAVE_LEVEL)
        LD (LEVEL),A
        CALL COPY_LEVEL
        LD HL,BOARD
        LD DE,SAVE_BOARD
        LD BC,64
        LDIR
        JP MENU
PAUSE:
        LD HL,$2D30
        LD (CURSOR_X),HL
        M_STRING(STRING_PAUSED)
        CALL INVERT
        CALL GET_KEY
        CALL GET_KEY
PA_1:
        CALL GET_KEY
        OR A                          
        JR Z,PA_1
        CALL INVERT
        LD A,(BALL_ACTIVE)
        OR A              
        CALL Z,READY
        CALL NZ,UNREADY      
        LD B,$08
PA_2:
        HALT
        DJNZ PA_2
        JP GAME_WAIT     
BALL_ON:
        LD HL,BALL_X
        LD B,(HL)
        INC HL
        LD C,(HL)
        CALL POINT_ON
        INC C
        CALL POINT_ON
        INC B
        CALL POINT_ON
        DEC C
        CALL POINT_ON
        DEC B
        RET
BALL_OFF:
        LD HL,BALL_X
        LD B,(HL)
        INC HL
        LD C,(HL)        
        CALL POINT_OFF
        INC C
        CALL POINT_OFF
        INC B
        CALL POINT_OFF
        DEC C
        CALL POINT_OFF
        DEC B
        RET
BALL_LAUNCH:
        LD A,(BALL_ACTIVE)
        OR A
        JP NZ,GAME_WAIT_5
        LD A,1
        LD (BALL_ACTIVE),A
        LD (BALL_UP),A
        CALL UNREADY
        JP GAME_WAIT
BALL_MOVE:             
        CALL BALL_OFF
        LD A,B
        CP 92
        JP Z,BALL_CHANGE_LEFT
        CP 26
        JP Z,BALL_CHANGE_RIGHT
        LD HL,BALL_Y
        LD A,C
        CP 60
        JP Z,BALL_CHANGE_DOWN
        CP 2
        JP Z,DIE
        CP 7
        JP Z,BALL_CHECK_PADDLE
        CALL CHECK_BLOCKS       
        LD A,(BALL_UP)
        OR A
        JR Z,BALL_MOVE_DOWN
BALL_MOVE_UP:               
        LD A,(BALL_Y)
        LD HL,BALL_SLOPE_Y
        LD B,(HL)
        ADD A,B
        LD (BALL_Y),A
        CP 61
        JR NC,LOAD_UP
        CP 2
        JR C,LOAD_DOWN
        LD A,(BALL_X)
        LD HL,BALL_SLOPE_X
        LD B,(HL)
        ADD A,B
        LD (BALL_X),A
        CP 93
        JR NC,LOAD_RIGHT
        CP 26
        JR C,LOAD_LEFT
        JP BALL_ON
LOAD_UP:
        LD A,60
        LD (BALL_Y),A
        JP BALL_ON
LOAD_DOWN:
        LD A,2
        LD (BALL_Y),A
        JP BALL_ON
LOAD_PAD:
        LD A,7
        LD (BALL_Y),A
        JP BALL_ON
LOAD_RIGHT:
        LD A,92
        LD (BALL_X),A
        JP BALL_ON
LOAD_LEFT:
        LD A,26
        LD (BALL_X),A
        JP BALL_ON
BALL_MOVE_DOWN:     
        LD A,(BALL_Y)
        LD HL,BALL_SLOPE_Y
        LD B,(HL)
        SUB B
        LD (BALL_Y),A
        CP 61
        JR NC,LOAD_UP
        CP 2
        JR C,LOAD_DOWN
        CP 7
        JR NC,SKIP
        CP 5
        JR C,SKIP
        LD A,(BALL_X)
        LD HL,PADDLE_X
        LD B,(HL)
        SUB B
        INC A
        LD HL,BALL_Y
        CP 11
        JR NC,SKIP
        OR A
        JP M,SKIP       
        JR LOAD_PAD
SKIP:            
        LD A,(BALL_X)
        LD HL,BALL_SLOPE_X
        LD B,(HL)
        ADD A,B
        LD (BALL_X),A
        CP 93
        JR NC,LOAD_RIGHT
        CP 26
        JR C,LOAD_LEFT
        JP BALL_ON
BALL_CHANGE_DOWN:
        XOR A
        LD (BALL_UP),A
        LD HL,BALL_Y
        DEC (HL)
        RET
BALL_CHANGE_RIGHT:
        LD A,(BALL_SLOPE_X)
        NEG
        LD (BALL_SLOPE_X),A
        LD HL,BALL_X
        INC (HL)
        RET
BALL_CHANGE_LEFT:
        LD A,(BALL_SLOPE_X)
        NEG
        LD (BALL_SLOPE_X),A
        LD HL,BALL_X
        DEC (HL)
        RET
BALL_CHECK_PADDLE:
        LD A,(BALL_UP)
        OR A
        JP NZ,BALL_MOVE_UP        
        LD A,(BALL_X)
        LD HL,PADDLE_X
        LD B,(HL)
        SUB B
        INC A
        LD HL,BALL_Y
        CP 11
        JP NC,BALL_MOVE_DOWN
        OR A
        JP M,BALL_MOVE_DOWN      
        PUSH AF
        CALL PUT_LEVEL
        LD A,1
        LD (BALL_UP),A
        LD HL,BALL_Y
        INC (HL)
        POP AF
        LD HL,BALL_SLOPE_X
        OR A
        JR Z,SLOPE_NEG_3
        CP 3
        JR C,SLOPE_NEG_2
        CP 5
        JR C,SLOPE_NEG_1
        CP 8
        JR C,SLOPE_1
        CP 10
        JR C,SLOPE_2
        LD (HL),2
        INC HL
        LD (HL),1
        LD A,2
        LD (BALL_SPEED),A
        RET
SLOPE_NEG_3:
        LD (HL),-2
        INC HL
        LD (HL),1
        LD A,2
        LD (BALL_SPEED),A
        RET
SLOPE_NEG_2:
        LD (HL),-1
        INC HL
        LD (HL),1
        LD A,1
        LD (BALL_SPEED),A
        RET
SLOPE_NEG_1:
        LD (HL),-1
        INC HL
        LD (HL),2
        LD A,2
        LD (BALL_SPEED),A
        RET
SLOPE_1:
        LD (HL),1
        INC HL
        LD (HL),2
        LD A,2
        LD (BALL_SPEED),A
        RET
SLOPE_2:
        LD (HL),1
        INC HL
        LD (HL),1
        LD A,1
        LD (BALL_SPEED),A
        RET
DIE:
        LD HL,LIVES
        DEC (HL)
        LD A,(HL)
        OR A
        JR Z,GAMEOVER
        LD A,(PADDLE_X)
        ADD A,4
        LD (BALL_X),A
        LD A,7
        LD (BALL_Y),A
        CALL BALL_ON
        XOR A
        LD (BALL_ACTIVE),A
        LD A,1
        LD (BALL_SLOPE_X),A
        LD A,2
        LD (BALL_SLOPE_Y),A
        LD (BALL_SPEED),A
        CALL DISP_LIVES
        CALL PUT_LEVEL
        CALL READY
PADDLE:
        LD HL,PADDLE_X
        LD B,(HL)
        LD C,6
        LD A,B
        ADD A,10
        LD D,A
        PUSH BC
        PUSH DE
        CALL HORIZONTAL
        POP DE
        POP BC
        LD C,5
        JP HORIZONTAL
GAMEOVER:
        CALL FADE_OUT
        ROM_CALL(CLEARLCD)
        LD HL,$0002
        LD (CURSOR_ROW),HL
        TX_STRING(STRING_GAMEOVER)
        LD HL,$0205
        LD (CURSOR_ROW),HL
        TX_STRING(STRING_SCORE)
        LD HL,$0D05
        LD (CURSOR_ROW),HL
        LD HL,(SCORE)
        CALL D_HL_DEC
        CALL FADE_IN
        CALL GET_KEY
        CALL GET_KEY
GO_1:
        CALL GET_KEY
        OR A
        JR Z,GO_1
        POP AF                                       
        LD HL,(SAVE_HIGH+7)            
        LD DE,(SCORE)     
        CALL CP_HL_DE
        JR C,HIGH_SCORE
        JP MENU
HIGH_SCORE:
        CALL FADE_OUT
        ROM_CALL(CLEARLCD)
        LD HL,$0000
        LD (CURSOR_ROW),HL
        LD HL,STRING_HIGH
        ROM_CALL(D_ZT_STR)
        LD HL,(SCORE)
        LD (SAVE_HIGH+7),HL
        LD IX,SAVE_HIGH
        LD (IX+00),'A'      
        LD (IX+01),'A'     
        LD (IX+02),'A'
        CALL HS_UPDATE
        CALL FADE_IN
HS_1:                       
        SET 3,(IY+05)
        LD HL,$0606
        LD (CURSOR_ROW),HL
        LD A,(IX+00)
        ROM_CALL(TX_CHARPUT)
        RES 3,(IY+05)
        CALL GET_KEY
        OR A
        CALL NZ,HS_UPDATE
        CP G_ENTER
        JP Z,MENU
        CP G_UP
        CALL Z,HS_INC_1
        CP G_DOWN
        CALL Z,HS_DEC_1
        CP G_RIGTH
        JR Z,HS_2
        JR HS_1
HS_INC_1:
        LD A,(IX+00)
        CP 'Z'
        RET Z
        INC (IX+00)
        RET
HS_DEC_1:
        LD A,(IX+00)
        CP 'A'
        RET Z
        DEC (IX+00)
        RET
HS_2:                      
        SET 3,(IY+05)
        LD HL,$0706
        LD (CURSOR_ROW),HL
        LD A,(IX+01)
        ROM_CALL(TX_CHARPUT)
        RES 3,(IY+05)
        CALL GET_KEY
        OR A
        CALL NZ,HS_UPDATE
        CP G_ENTER
        JP Z,MENU
        CP G_UP
        CALL Z,HS_INC_2
        CP G_DOWN
        CALL Z,HS_DEC_2
        CP G_LEFT
        JR Z,HS_1
        CP G_RIGTH
        JR Z,HS_3
        JR HS_2
HS_INC_2:
        LD A,(IX+01)
        CP 'Z'
        RET Z
        INC (IX+01)
        RET
HS_DEC_2:
        LD A,(IX+01)
        CP 'A'
        RET Z
        DEC (IX+01)
        RET
HS_3:                     
        SET 3,(IY+05)
        LD HL,$0806
        LD (CURSOR_ROW),HL
        LD A,(IX+02)
        ROM_CALL(TX_CHARPUT)
        RES 3,(IY+05)
        CALL GET_KEY
        OR A
        CALL NZ,HS_UPDATE
        CP G_ENTER
        JP Z,MENU
        CP G_UP
        CALL Z,HS_INC_3
        CP G_DOWN
        CALL Z,HS_DEC_3
        CP G_LEFT
        JR Z,HS_2
        JR HS_3
HS_INC_3:
        LD A,(IX+02)
        CP 'Z'
        RET Z
        INC (IX+02)
        RET
HS_DEC_3:
        LD A,(IX+02)
        CP 'A'
        RET Z
        DEC (IX+02)
        RET
HS_UPDATE:               
        PUSH AF
        LD HL,$0506
        LD (CURSOR_ROW),HL
        LD A,32
        ROM_CALL(TX_CHARPUT)
        LD A,(IX+00)      
        ROM_CALL(TX_CHARPUT)
        LD A,(IX+01)
        ROM_CALL(TX_CHARPUT)
        LD A,(IX+02)
        ROM_CALL(TX_CHARPUT)
        POP AF
        RET
D_HL_DEC:
        LD B,5
DHD_1:
        CALL UNPACK_HL
        ADD A,48
        PUSH BC
        PUSH HL
        ROM_CALL(TX_CHARPUT)
        POP HL
        POP BC
        LD A,(CURSOR_COL)
        SUB 2
        LD (CURSOR_COL),A
        DJNZ DHD_1
        RET
PADDLE_LEFT:
        LD HL,PADDLE_X
        LD A,(HL)
        CP 27
        JP C,GAME_WAIT_5
        DEC (HL)
        LD B,(HL)
        LD C,6             
        CALL POINT_ON    
        DEC C
        CALL POINT_ON
        LD A,B
        ADD A,10
        LD B,A     
        CALL POINT_OFF
        INC C
        CALL POINT_OFF
        LD A,(BALL_ACTIVE)
        OR A
        JP NZ,GAME_WAIT
        LD HL,BALL_Y
        LD C,(HL)
        DEC HL
        DEC (HL)
        LD B,(HL)
        CALL POINT_ON
        INC C
        CALL POINT_ON
        INC B
        INC B
        CALL POINT_OFF
        DEC C
        CALL POINT_OFF
        JP GAME_WAIT
PADDLE_RIGHT:
        LD HL,PADDLE_X
        LD A,(HL)
        CP 84
        JP NC,GAME_WAIT_5
        LD B,(HL)
        INC (HL)
        LD C,6
        CALL POINT_OFF
        DEC C
        CALL POINT_OFF
        LD A,B
        ADD A,10
        LD B,A
        CALL POINT_ON
        INC C
        CALL POINT_ON
        LD A,(BALL_ACTIVE)
        OR A
        JP NZ,GAME_WAIT
        LD HL,BALL_Y
        LD C,(HL)
        DEC HL
        INC (HL)
        LD B,(HL)
        DEC B
        CALL POINT_OFF
        INC C
        CALL POINT_OFF
        INC B
        INC B
        CALL POINT_ON
        DEC C
        CALL POINT_ON
        JP GAME_WAIT
DISP_LIVES:
        LD A,(LIVES)
        ADD A,48
        LD HL,$250C
        LD (CURSOR_X),HL
        ROM_CALL(M_CHARPUT)
        RET
DISP_SCORE:      
        LD HL,$3614
        LD (CURSOR_X),HL
        LD HL,(SCORE)
D_HL_MENU:
        LD B,5
DHLM_1:
        CALL UNPACK_HL
        ADD A,48
        PUSH BC
        PUSH HL
        ROM_CALL(M_CHARPUT)
        POP HL
        POP BC
        LD A,(CURSOR_X)
        SUB 8
        LD (CURSOR_X),A
        DJNZ DHLM_1
        RET           
HORIZONTAL:
        CALL POINT_ON
        INC B
        LD A,B
        CP D
        JP NZ,HORIZONTAL
        RET
PUT_LEVEL:            
        LD B,8
        PUSH BC
        LD D,4
        LD E,24
        LD HL,BOARD      
PL_1:                         
        LD A,(HL)      
        CALL PUT_BLOCK      
        INC HL
        DJNZ PL_1
        POP BC
        DEC B      
        LD A,B
        OR A
        RET Z
        PUSH BC
        LD B,8
        LD A,D
        ADD A,4
        LD D,A
        LD E,24
        JR PL_1
        RET
ADD_8:
        LD A,E
        ADD A,8
        LD E,A     
        RET                              
PUT_BLOCK:
        PUSH HL
        PUSH BC
        PUSH DE      
        OR A
        JR Z,PUT_BLOCK0
        CP 1
        CALL Z,PUT_BLOCK1
        CP 2
        CALL Z,PUT_BLOCK2
        CP 3
        CALL Z,PUT_BLOCK3
        CP 4
        CALL Z,PUT_BLOCK4
        CALL PUT_8X4_SPRITE
        POP DE
        PUSH DE
        CALL ADD_8              
        CALL PUT_8X4_SPRITE
        POP DE
        CALL ADD_8
        POP BC
        POP HL
        RET
PUT_BLOCK0:
        LD HL,SPRITE_BLOCK0
        CALL DEL_8X4_SPRITE
        POP DE
        PUSH DE
        CALL ADD_8
        CALL DEL_8X4_SPRITE
        POP DE
        CALL ADD_8
        POP BC
        POP HL
        RET
PUT_BLOCK1:
        LD HL,SPRITE_BLOCK1
        RET
PUT_BLOCK2:
        LD HL,SPRITE_BLOCK2
        RET
PUT_BLOCK3:
        LD HL,SPRITE_BLOCK3
        RET
PUT_BLOCK4:
        LD HL,SPRITE_BLOCK4
        RET
CHECK_BLOCKS:                        
        LD A,C
        CP 25
        RET C
        PUSH BC
        LD A,C
        SUB 11
        LD E,A
        SRL A
        SRL A
        LD B,A
        LD A,11
        SUB B
        SLA A
        SLA A
        SLA A
        LD B,0
        LD C,A
        LD HL,BOARD
        ADD HL,BC           
        POP BC                  
        LD A,B
        ADD A,3
        LD D,A
        SRL A
        SRL A
        SRL A
        SUB 4                                              
        LD B,0
        LD C,A
        ADD HL,BC       
        LD A,(HL)           
        OR A       
        JR NZ,DEST_BLOCK       
        RET
BB_DIR:                                       
        LD A,(BALL_SLOPE_X)
        NEG
        LD (BALL_SLOPE_X),A
        JR BB_VERT
DEST_BLOCK:
        LD (HL),0
        PUSH DE             
        LD A,E
        SRL A
        SRL A
        SUB 3
        LD B,10
        CALL MULT
        LD C,A
        LD B,0
        LD HL,(SCORE)     
        ADD HL,BC
        LD (SCORE),HL                          
        CALL DISP_SCORE                 
        CALL PUT_LEVEL      
        CALL CHECK_LEVEL
        POP DE
        LD A,D
        AND 7
        CP 2
        JR C,BB_DIR     
        CP 6     
        JR NC,BB_DIR      
BB_VERT:
        LD HL,BALL_UP
        LD A,(HL)
        OR A        
        JR NZ,DOWN_BALL
UP_BALL:     
        LD (HL),1      
        RET
DOWN_BALL:      
        LD (HL),0    
        RET        
COPY_LEVEL:
        LD A,(LEVEL)
        CP 1
        CALL Z,LV_1
        CP 2
        CALL Z,LV_2
        CP 3
        CALL Z,LV_3
        CP 4
        CALL Z,LV_4
        CP 5
        CALL Z,LV_5
        CP 6
        CALL Z,LV_6
        CP 7
        CALL Z,LV_7
        CP 8
        CALL Z,LV_8
        CP 9
        CALL Z,LV_9
        CP 10
        CALL Z,LV_10
        LD DE,BOARD
        LD BC,64
        LDIR
        RET
DISP_LEVEL:
        CALL FADE_OUT
        ROM_CALL(CLEARLCD)
        LD HL,$0403
        LD (CURSOR_ROW),HL
        TX_STRING(STRING_LEVEL)
        LD HL,$0B03
        LD (CURSOR_ROW),HL
        LD A,(LEVEL)
        LD H,0
        LD L,A
        CALL UNPACK_HL
        ADD A,48
        PUSH HL
        ROM_CALL(TX_CHARPUT)
        LD HL,$0A03
        LD (CURSOR_ROW),HL
        POP HL
        CALL UNPACK_HL
        ADD A,48
        ROM_CALL(TX_CHARPUT)
        LD HL,$0404
        LD (CURSOR_ROW),HL
        TX_STRING(STRING_DASHES)             
        CALL FADE_IN
        LD B,$80
DP_1:
        HALT
        DJNZ DP_1
        CALL FADE_OUT
        RET
CHECK_LEVEL:
        LD HL,BOARD
        LD B,64
        XOR A
CL_1:
        CPI
        RET NZ
        DJNZ CL_1     
BEAT_LEVEL:
        LD HL,(SCORE)
        LD BC,1000
        ADD HL,BC
        LD (SCORE),HL
        LD A,(LEVEL)
        CP 10
        JR NC,BEAT_GAME
        CALL FADE_OUT
        ROM_CALL(CLEARLCD)
        LD HL,$0402
        LD (CURSOR_ROW),HL
        TX_STRING(STRING_LEVEL)
        LD HL,$0B02
        LD (CURSOR_ROW),HL
        LD HL,LEVEL
        LD A,(HL)          
        INC (HL)
        LD H,0
        LD L,A
        CALL UNPACK_HL
        ADD A,48     
        ROM_CALL(TX_CHARPUT)
        LD A,$0A
        LD (CURSOR_COL),A            
        CALL UNPACK_HL
        ADD A,48
        ROM_CALL(TX_CHARPUT)
        LD HL,$0305
        LD (CURSOR_ROW),HL
        TX_STRING(STRING_COMPLETED)
        CALL FADE_IN
        CALL GET_KEY
        CALL GET_KEY
BL_1:      
        CALL GET_KEY
        OR A
        JR Z,BL_1
        POP AF
        POP AF
        POP AF
        POP AF
        JP NEW_LEVEL
BEAT_GAME:
        POP AF
        POP AF
        POP AF
        LD HL,(SCORE)
        LD BC,10000
        ADD HL,BC
        LD (SCORE),HL
        JP GAMEOVER
READY:
        LD HL,$2D30
        LD (CURSOR_X),HL
        M_STRING(STRING_READY)
        RET
UNREADY:
        LD HL,$2D30
        LD (CURSOR_X),HL
        LD B,24
UR_1:
        LD A,32
        PUSH BC
        ROM_CALL(M_CHARPUT)
        POP BC
        DJNZ UR_1
        RET
        
LV_1:
        LD HL,LEVEL_1
        RET
LV_2:
        LD HL,LEVEL_2
        RET
LV_3:
        LD HL,LEVEL_3
        RET
LV_4:
        LD HL,LEVEL_4
        RET
LV_5:
        LD HL,LEVEL_5
        RET
LV_6:
        LD HL,LEVEL_6
        RET
LV_7:
        LD HL,LEVEL_7
        RET
LV_8:
        LD HL,LEVEL_8
        RET
LV_9:
        LD HL,LEVEL_9
        RET
LV_10:
        LD HL,LEVEL_10
        RET
  
.INCLUDE "TI82DISP.LIB"   ; lib
.INCLUDE "LCDSFX.LIB"     ; lib
.INCLUDE "MATH.LIB"       ; lib
.INCLUDE "GRAPH.INC"      ; lib
.INCLUDE "ARKDATA.H"      ; data
.INCLUDE "ARKLEVEL.H"     ; levels
.INCLUDE "ARKTITLE.PIC"   ; bitmap
.INCLUDE "ARKBOARD.PIC"   ; bitmap

.END
