;
;                           Crash to CrASH v1.1
;
; This program simplifies your way into CrASH.
;  (It makes it seem like you're using a TI-85 too...)
;
; This program will crash to CrASH using interrupts and detecting keys.
;
; To load the interrupt, run CRCRASH from CrASH.  You can stop the routine
; by entering the program again.
;
; by Hideaki Omuro                December '97
;

.INCLUDE CRASH82.INC
.DB      "Crash to CrASH v1.1", 0

  LD  HL, $0101 \ LD  (CURSOR_POS), HL
  LD  HL, text             ; Display text
  ROM_CALL(D_ZT_STR)
  LD  BC, $0004 \ LD  (CURSOR_POS), BC

  LD  A, (INT_STATE)       ; See what to do
  CP  $80 \ JR  Z, Remove  ; $80 is CrCrASH's ID
  OR  A   \ JR  NZ, Another

  ROM_CALL(D_ZT_STR)       ; Display text (HL -> installed)

  LD  HL, $8400            ; Setup interrupt vector table in later half of
  LD  DE, $8401            ; APD buffer (used only for APD with TIROM).  The
  LD  (HL), $83            ; Int routine is placed from APD+347 to make
  LD  BC, $100             ; conflicts with games as small as possible.
  LDIR

  LD  HL, IntProcStart     ; Get pointer to interrupt routine
  LD  DE, $8383            ; Start of int rutine, and length of it
  LD  BC, IntProcEnd-IntProcStart+1
  LDIR

  LD  HL, 347
  LD  (APD_FREE), HL

  LD  A, $84               ; Point to the new table
  LD  I, A
  IM  2

WaitKey:                   ; After this, it will return to CrASH
  JP  CR_KHAND

Remove:
  LD  HL, deinstalled      ; Display text
  ROM_CALL(D_ZT_STR)

  IM  1                    ; Normal interrupt mode

  LD  HL, $300
  LD  (APD_FREE), HL

  XOR A                    ; Int state is 0 off
  LD  I, A

  LD  (INT_STATE), A       ; Interrupts are off

  JR  WaitKey

Another:
  LD  HL, another
  ROM_CALL(D_ZT_STR)

  JR  WaitKey

IntProcStart:
  DI
  EX  AF, AF'
  EXX

  LD  A, $80               ; Int state is 80 - on (CrCrash's ID)
  LD  (INT_STATE), A

  LD  A, $74               ; Never APD
  LD  ($800A), A

  LD  A, ($8121)
  CP  $40 \ JR  NZ, ExitInt ; If not safe to jump to CrASH, get out
  BIT 0, (IY+$12)
  JR  NZ, ExitInt          ; If busy indicator on, get out of interrupt
  BIT 4, (IY+$0C)
  JR  NZ, ExitInt          ; If in menu, get out of interrupt

  LD  A, %10111111         ; Check Y=.
  OUT ($01), A
  IN  A, ($01)
  BIT 4, A \ JR  NZ, ExitInt

  IN  A, ($03)             ; Check On.
  BIT 3, A \ JR  NZ, ExitInt

  LD  HL, $8D51            ; Change the return address to CrASH's start
  EX  (SP), HL

ExitInt:
  EXX
  EX  AF, AF'
  JP  $0038                ; Call Std interrupt handler, go back.

IntProcEnd:

text:
.DB  "Crash to CrASH "
.DB "      v1.1", 0
installed:
.DB "Press  ON]+Y=]"
.DB "  to return to  "
.DB "     CrASH!", 0
deinstalled:
.DB "   Disabled.", 0
another:
.DB "Another  handler"
.DB "  is  running.  "
.DB "Turn off to use "
.DB " this  program.", 0
.END
