;|-------------------------------------------| Dec. 28, 1999
;|      Linkcontrol v1.0 by JSS              |
;|-------------------------------------------|
;|     A TI82 assembler-program for Ash 3.0  |
;|-------------------------------------------|
; Author: Jakob Selbing
; e-mail: jakob_selbing@hotmail.com
; URL: hem2.passagen.se/jaksel
;
; This is a small program with which you can
; manipulate the logic state of the TI82-linkport, 
; i.e. red wire and white wire using the Y= and WINDOW buttons.
; The program will also display a small dot in front of
; the two wires if the port is driven low externally
; (when the states of the wires are set to high).
;
; The linkport is a bi-directional open-collector
; type, which means that either it should be driven low,
; or it should not be driven at all.
; DO NOT DRIVE THE LINKPORT HIGH! 


#include "ti82.h"
#include "keys.inc"

 .org START_ADDR
 .DB "Linkcontrol by JSS",0

link_state      =GRAPH_MEM
last_linkread   =GRAPH_MEM+1
red_wire        =%00000100
white_wire      =%00001000
red_wire_bit    =2
white_wire_bit  =3


link_cs         =%11000000      ;white=high red=high


        ROM_CALL(CLEARLCD)

        ld bc,$0000
        ld (CURSOR_POS),bc
        ld hl,string_title
        ROM_CALL(D_ZT_STR)
        ld bc,$0302             ;Display text
        ld (CURSOR_POS),bc
        ROM_CALL(D_ZT_STR)
        ld bc,$0103
        ld (CURSOR_POS),bc
        ROM_CALL(D_ZT_STR)

        ld bc,$2703
        ld (CURSOR_X),bc
        ROM_CALL(D_ZM_STR)
        ld bc,$3200
        ld (CURSOR_X),bc
        ROM_CALL(D_ZM_STR)
        ld bc,$3800
        ld (CURSOR_X),bc
        ROM_CALL(D_ZM_STR)

        ld a,link_cs
        call update_linkstat

keyloop:
        call GET_KEY
        cp G_MODE
        ret z
        cp G_YEDIT
        jr z,change_redwire
        cp G_WINDOW
        jr z,change_whitewire

        in a,(P_LINK)
        ld b,a
        ld a,(last_linkread)
        cp b                    ;Check if the state of the port has changed
        jr z,keyloop            
        ld a,b
        ld (last_linkread),a

        ld bc,$0002
        ld (CURSOR_POS),bc
        ld a,' '
        ROM_CALL(TR_CHARPUT)    ;Remove dots
        ld a,$03
        ld (CURSOR_ROW),a
        ld a,' '
        ROM_CALL(TR_CHARPUT)

        ld a,(link_state)
        bit red_wire_bit,a
        jr nz,red_wire_int_low_or_ext_high
        ld a,(last_linkread)
        bit 0,a
        jr nz,red_wire_int_low_or_ext_high
        ld a,$02
        call put_dot_at_a       ;Write dots

red_wire_int_low_or_ext_high:

        ld a,(link_state)
        bit white_wire_bit,a
        jr nz,keyloop
        ld a,(last_linkread)
        bit 1,a
        jr nz,keyloop
        ld a,$03
        call put_dot_at_a       ;Write dots
        jr keyloop

put_dot_at_a:
        ld (CURSOR_ROW),a
        ld a,0
        ROM_CALL(TR_CHARPUT)
        ret

change_whitewire:
        ld a,(link_state)
        xor white_wire
        jr update_linkstat

change_redwire:
        ld a,(link_state)
        xor red_wire

update_linkstat:
        ld (link_state),a
        out (P_LINK),a
        ld hl,$0C02
        ld (CURSOR_POS),hl
        ld hl,string_low
        bit red_wire_bit,a
        jr nz,red_wire_active
        ld hl,string_high
red_wire_active:
        ROM_CALL(D_ZT_STR)

        ld hl,$0C03
        ld (CURSOR_POS),hl
        ld hl,string_low
        bit white_wire_bit,a
        jr nz,white_wire_active
        ld hl,string_high
white_wire_active:
        ROM_CALL(D_ZT_STR)
        jp keyloop

string_high:
        .db "High",0
string_low:
        .db "Low ",0

string_title:
        .db "Linkcontrol 1.0",0
        .db "Red wire:",0
        .db "White wire:",0
        .db "Toggle with Y= and WINDOW.",0
        .db "Jakob Selbing 1999, URL:",0
        .db "hem2.passagen.se/jaksel",0

.end
