#INCLUDE "TI82.H"
#INCLUDE "KEYS.INC"
;
App      =  APD_BUF
Cmde	=	App+1
Code	=	App+2
;

.ORG START_ADDR
	.db "Test  all  RC5  codes !",0
;
Depart:
   ROM_CALL(BUSY_OFF)
   ROM_CALL(CLEARLCD)
   ld hl,Text
	ld de,$0001
	ld (CURSOR_ROW),de
   ROM_CALL(D_ZT_STR)            
	ld de,$0005
	ld (CURSOR_ROW),de
   ROM_CALL(D_ZT_STR)            
Loop:
   ld de,$0A05
	ld (CURSOR_ROW),de
	ld hl,(App)
	ld h,0
   ROM_CALL(D_HL_DECI)
   ld de,$0A06
	ld (CURSOR_ROW),de
	ld hl,(Cmde)
	ld h,0
   ROM_CALL(D_HL_DECI)
GetK:
	call GET_KEY
   cp G_MODE
	ret z
   cp G_DOWN
	jr z,dec_App
   cp G_UP
	jr z,inc_App
   cp G_LEFT
	jr z,dec_Code
   cp G_RIGHT
	jr z,inc_Code
   cp G_DEL
	jr z,Send_code
	jr GetK
;
dec_App:
	ld a,(App)
   or a
	jr z,Loop
	dec a
	ld (App),a
	jr Loop
inc_App:
	ld a,(App)
	cp 31
	jr z,Loop
	inc a
	ld (App),a
	jr Loop
dec_Code:
	ld a,(Cmde)
	cp 0
	jr z,Loop
	dec a
	ld (Cmde),a
	jr Loop
inc_Code:
	ld a,(Cmde)
	cp 127
	jr z,Loop
	inc a
	ld (Cmde),a
	jr Loop

;*******************************************************************************************
;************ Routine pour convertir l'appareil et la commande en code RC5 *****************
;*******************************************************************************************
Send_code:
	ld a,4
	ld (Code),a
	ld a,32
	ld (Code+1),a
	ld a,$0E
	ld (Code+2),a
	ld a,$12
	ld (Code+3),a
;
	ld a,(App)
	xor %11100000
	ld c,a
   call Change_4_bits
	ld (Code+4),a
   call Change_4_bits
	ld (Code+5),a
	ld a,(Cmde)
	cp 63
   call nz,Etendu
	ld c,a
	sla c
	sla c
   call Change_4_bits
	ld (Code+6),a
   call Change_4_bits
	xor %00001010
	ld (Code+7),a
;*******************************************************************************************
;****************** Routine pour envoyer le code par Sami Khawam ***************************
;*******************************************************************************************
SendData:
	ld a,$C0
   out (0),a               ; sorties hautes
;
	ld a,(Code)					; Number of bytes
	ld b,a						; We load it into b for djnz
   call PutByte           ; Send the Byte
	ld a,(Code+1)				; The Duration of a Bit
   call PutByte           ; Send the Byte
	ld a,(Code+2)				; The First delay
   call PutByte           ; Send the Byte
	ld a,(Code+3)				; The Second delay
   call PutByte           ; Send the Byte
	ld hl,Code+4
NextByte:
	ld a,(hl)
   call PutByte           ; Now we send all bytes.
	inc hl
	djnz NextByte
   jp Loop
PutByte:
	push bc
	ld c,a
	ld b,8						; 8 Bits
PB_Next_Bit:
	ld a,$C0					; Set W1 and R1
   out (0),a
	rr c
	jr NC,PB_SendZero
	ld a,$E8
	jr PB_output_val
PB_SendZero:
	ld a,$D4
PB_output_val:
   out (0),a
	ld de,$FFFF					; For time-out
PB_Wait_for_W0_and_R0:
   in a,(0)
	and 3
	jr z,PB_Continue
   in a,(0)
	and 3
	jr z,PB_Continue
	dec de
	ld a,d
	or e
	jr NZ,PB_Wait_for_W0_and_R0
	jr PB_End					; If error return.
PB_Continue:
	ld a,$C0					; Set W1 and R1
   out (0),a
	ld de,$FFFF					; Reload time-out
PB_Wait_for_W1_and_R1:
	dec de
	ld a,d
	or e
	jr z,PB_End
   in a,(0)
	and 3
	cp 3
	jr NZ,PB_Wait_for_W1_and_R1
	djnz PB_Next_Bit
PB_End:
	pop bc
	ret
;*******************************************************************************************
Change_4_bits:
	xor a
	ld b,4
CtRC5:
	sla a
	sla a
	bit 7,c	
	jr nz,Un
	xor %00000010
	jr Suite
Un:
	xor %00000001
Suite:
	rlc c
	djnz CtRC5
	ret
;*******************************************************************************************
Etendu:
	ret c						; s'il est infreur  63, c'est fini
	sub 64						; sinon on lui retranche 64
	push af						; on sauve la nouvelle commande
	ld a,(Code+4)				; modification au niveau de l'adresse
	xor %00110000				; on change un 1 logique en 0
	ld (Code+4),a				; sauve cette modification
	pop af
	ret
;*******************************************************************************************
Text:
   .db   "App : Up/Down   "
   .db   "Cmd : Left/Right"
   .db   "Send: Del",0
   .db   "Appareil :      "
   .db   "Commande :",0
.end
