; --------------------------------------------------  May 14, 2004
;|               "AGM LCD v1.3"                     |
;|  TI82 assembler LCD line drawing routines (Ash)  |
;|      Avg. pixel rate: 7300 pixels / sec          |
;|          File name: "agmlcd13.asm"               |
; --------------------------------------------------
;    -----------------------------------------
;   |Author: Jakob Selbing                    |
;   |  Comments, bugs, tips, anything on      |
;   |  your mind:                             |
;   | Email: jakse638@student.liu.se          |
;   | URL: hem.passagen.se/jaksel             |
;   |                                         |
;    -----------------------------------------
;
;
;This source is a simple TI82 program that demonstrates one routine:
;
; agm_line_bc_de    - draws a line from (b,c) to (d,e) on the LCD
;
;
;
; My algorithm uses some kind of iterative approach.
; It uses a few additions and subtractions on each pixel,
; instead of multiplication and division. The rate is 
; about 7300 pixels / second!
;
;Note: If you want a routine that writes to the GRAPH_MEM instead, 
;      you can use the "AGM" routine, available at the same place 
;      as this file hopefully.
; 
;                     Version history
;                   -------------------
;
;       AGM LCD v1.1 - first version, about 5900 pixels / sec
;
;       AGM LCD v1.3 - optimized for speed, 7300 pixels / sec,
;                       achieved by eliminating DISP_DELAYs.
;
; YOU CAN USE THESE ROUTINES FREELY, BUT PLEASE GIVE ME CREDIT. :)

#include "ti82.h"
#include "keys.inc"

agm_line_mem_index  = TEXT_MEM      ; Memory base for variables
agm_line_k1         = 0
agm_line_k2         = 1
agm_line_A          = 2
agm_line_status     = 3
agm_lcd_col         = 4
agm_lcd_row         = 5
agm_lcd_data        = 6

agm_line_code_XY_switch = 1         ; This is just an arbitrary value (cannot be 0)


.org START_ADDR
.db "AGM LCD v1.3 test",0


program_start:
    ROM_CALL(CLEARLCD)
    ld b, 0
    ld c, 63
    ld d, 95
    ld e, 63
testloop1:
    push bc
    push de
    call agm_line_bc_de
    pop de
    pop bc
    dec e
    ld a, e
    cp 255
    jr nz, testloop1

    ROM_CALL(CLEARLCD)
    ld b, 0
    ld c, 63
    ld d, 95
    ld e, 0
testloop2:
    push bc
    push de
    call agm_line_bc_de
    pop de
    pop bc
    inc b
    ld a, b
    cp 96
    jr nz, testloop2

    
    ROM_CALL(CLEARLCD)
    ld b, 95
    ld c, 63
    ld d, 95
    ld e, 0
testloop3:
    push bc
    push de
    call agm_line_bc_de
    pop de
    pop bc
    dec d
    ld a, d
    cp 255
    jr nz, testloop3

    ROM_CALL(CLEARLCD)
    ld b, 95
    ld c, 63
    ld d, 0
    ld e, 0
testloop4:
    push bc
    push de
    call agm_line_bc_de
    pop de
    pop bc
    dec c
    ld a, c
    cp 255
    jr nz, testloop4
Key_loop:
    call GET_KEY
    or a
    jr z, Key_loop
    ret





agm_line_bc_de:
; Draws a line from (b, c) to (d, e) DIRECTLY to the LCD.
; Affects registers: A, B, C, D, E, H, L
;
; b = x1, c = y1
; d = x2, e = y2
;
;        x (0..95)
;    -------->
;   |
;   |
;   |  TI82 screen
;   |
;   \/
;y (0..63)

    ld a, d
    sub b                   ; a = delta X
    jr nc, agm_line_longer_axis_skip_neg1
    neg    
agm_line_longer_axis_skip_neg1:
    ld h, a                 ; h = abs(delta X)
    ld a, e
    sub c                   ; a = delta Y
    jr nc, agm_line_longer_axis_skip_neg2
    neg
agm_line_longer_axis_skip_neg2:
    sub h                   ; a= abs(delta Y) - abs(delta X)
    ld a, 0                 ; Reset "switch XY" flag
    jr c, agm_line_longer_axis_x
    ld a, b                 ; switch X and Y
    ld b, c
    ld c, a
    ld a, d                 ; switch X and Y
    ld d, e
    ld e, a
    ld a, agm_line_code_XY_switch                 ; Set "switch XY" flag
agm_line_longer_axis_x:
    ld (agm_line_mem_index + agm_line_status), a       ; Save status
    
    ld a, b
    cp d
    jr c, agm_line_skip_exchange
    ld a, b                 ; Exchange bc and de
    ld b, d                 ; since algorith assumes b < d
    ld d, a
    ld a, c
    ld c, e
    ld e, a
agm_line_skip_exchange:

    ld a, d
    sub b
    ld (agm_line_mem_index + agm_line_k1), a        ; Save constant K1 = x2 - x1 (>= 0 always)
    ld a, e
    sub c
    ld (agm_line_mem_index + agm_line_k2), a        ; Save constant K2 = y2 - y1
    sub a                                           ; A = 0
    ld (agm_line_mem_index + agm_line_A), a         ; Save variable A
    ld (agm_line_mem_index + agm_lcd_data), a       ; Save LCD data (first output, should be 0) 

agm_line_bc_de_loop:
    push bc
    
    ld a, (agm_line_mem_index + agm_line_status)
    cp agm_line_code_XY_switch
    jr nz, agm_line_no_XY_switch
    ld a, b                 ; Switch X and Y if this was done earlier
    ld b, c
    ld c, a
agm_line_no_XY_switch:

;-------------
    ld a, b                                         ; Calculate column  4
    srl a                                           ; -                 8
    srl a                                           ; -                 8
    srl a                                           ; -                 8
    or $20                                          ; -                 8
    ld (agm_line_mem_index + agm_lcd_col), a        ; Save LCD column   13
; BCET = 49 cycles
;------------
    out (P_LCD_CON),a                               ; Write column      11

    
;------------
    ld a, b                                         ; Calculate data byte with pixel    4
    and %00000111                                   ; -                                 7
    ld b, a                                         ; -                                 4
    inc b                                           ; -                                 4
    sub a                                           ; -                                 4
    scf                                             ; -                                 4
shift_pixel_right:                                  ; -
    rra                                             ; -                                 4
    djnz shift_pixel_right                          ; -                                 8..13
    ld (agm_line_mem_index + agm_lcd_data), a       ; Save LCD data                     13
    ld a, c                                         ;                                   4
    and %00111111                                   ;                                   7
    or $80                                          ;                                   7
; BCET = 70 cycles
;----------------------
    out (P_LCD_CON),a                               ; Write row         11
    
;--------------------    
    ld (agm_line_mem_index + agm_lcd_row), a        ; Save LCD row      13
    pop bc                                          ;                   10
    ld a, b                                         ;                   4
    dec a                   ; Decrease this one pixel(pipelined)        4
    cp d                    ; Check if whole line done                  4
    ret z                   ; Yes, quit                                 5..11
    inc b                   ; No, step forward along longer axis        4
    push de                                         ;                   11
    push bc                                         ;                   11
; BCET = 66 cycles
;--------------------
    
    
;*************
    in a,(P_LCD_DATA)                               ; Pipelined pixel, step 1: Read 1st byte (invalid)  11
;*************

;----------------
    ld a, (agm_line_mem_index + agm_line_A)     ; Load iterative value "A", which       13
    ld l, a                             ; should be kept as close to zero as possible   4
    ld h, 0                                         ;                                   7
    bit 7, a                                        ;                                   8
    jr z, agm_line_A_not_negative                   ;                                   7..12
    ld h, 255                           ; Extend to 16-bit 2s complement                7
agm_line_A_not_negative:
    ld a, (agm_line_mem_index + agm_line_k2)    ; Load constant K2                      13
    ld e, a                                     ;                                       4
    ld d, 0                             ; Extend to 16-bit 2s complement                7
    bit 7, a                                    ;                                       8
    jr z, agm_line_K2_pos1                      ;                                       7..12
    ld d, 255                                   ;                                       7
agm_line_K2_pos1:
; BCET = 88 cycles
;----------------


    ld a, (agm_line_mem_index + agm_lcd_data)       ; Pipelined pixel, step 2: read LCD data    13
    ld b, a                                         ;                                           4
    in a,(P_LCD_DATA)                               ; Read current LCD pixels                   11
;--------------------    
    or b                                            ; OR with new pixel                 4
    ld (agm_line_mem_index + agm_lcd_data), a       ; Save new LCD pixels               13
    or a                                    ; Clear Carry flag                          4
    sbc hl, de                              ; hl = Aold - K2 = A                        15
    push hl                                 ;                                           11
    ld a, (agm_line_mem_index + agm_line_k1)    ;                                       13
    ld d, 0                                     ;                                       7
    ld e, a                                     ;                                       4
    ld a, (agm_line_mem_index + agm_lcd_row)        ; Pipelined pixel, step 3: write row    13
; BCET = 84 cycles
;------------------------    
    out (P_LCD_CON),a                               ; Write row                             11
      
    
;-------------------
    ld a, (agm_line_mem_index + agm_line_k2)    ; If delta Y negative then              13
    bit 7, a                                    ; we will test A - K1, not A + K1       8
    jr z, agm_line_K2_pos2                      ;                                       7..12
    or a                                        ;                                       4
    sbc hl, de                                  ; hl = A - K1                           15
    jr agm_line_ex_de_hl                        ;                                       12
agm_line_K2_pos2:
    add hl, de                                  ; hl = A + K1                           11
agm_line_ex_de_hl:
    ex de, hl                                   ; de = A +/- K1 = B                     4
    pop hl                                  ; hl = A                            10
    push hl                                 ;                                   11
    push de                                 ;                                   11
    ld a, (agm_line_mem_index + agm_lcd_col)        ; Pipelined pixel, step 4: write column     13
; BCET = 93 cycles
;--------------------

    out (P_LCD_CON),a                               ; Write column                              11
    
    
    bit 7, h
    jr z, agm_line_A_abs_done
    ld a, l
    neg
    ld l, a
    ld h, 0
agm_line_A_abs_done:
    bit 7, d
    jr z, agm_line_B_abs_done
    ld a, e
    neg
    ld e, a
    ld d, 0
agm_line_B_abs_done:
    or a                                    ; Clear Carry flag
    sbc hl, de                              ; hl = abs(A) - abs(B)

    pop de                                  ; pop B = A +/- K1
    pop hl                                  ; pop A
    pop bc                                  ; pop position 1
    jr c, agm_line_keep_y                       ; If abs(A) < abs(A +/- K1) then Y should not increase/decrease
    ld a, (agm_line_mem_index + agm_line_k2)
    bit 7, a
    jr nz, agm_line_dec_y
    inc c                                   ; Increase Y position
    inc c
agm_line_dec_y:
    dec c
    ld l, e                                 ; Make code below save (A +/- K1) instead of A
agm_line_keep_y:
    ld a, l                                 ; Keep Y position
    ld (agm_line_mem_index + agm_line_A), a         ; A' = A
    pop de                                  ; Pop position 2

    ld a, (agm_line_mem_index + agm_lcd_data)       ; Pipelined pixel, step 5: write data
;*************
    out (P_LCD_DATA),a                              ; Write new pixels (first time it is all 0's)
;*************
    jp agm_line_bc_de_loop    


        
 



.end



