include "crash82.asm"

; Long name for CrASH
db "Game of Life by SopaXorzTaker", 0

cells: equ TEXT_MEM
cells_copy: equ TEXT_MEM2

jp main

arrayIndex:
    ; Convert a coordinate pair to an index
    ; index = y*16 + x

    ; Arguments:
    ; a, b - x, y

    ; Returns:
    ; hl - array index
    ; a, b corrected

    push de

    and 15
    ld d, a
    ld a, b
    and 7
    ld b, a
    ld a, d

    ld e, b

    sla b
    sla b
    sla b
    sla b

    add b
    ld h, 0
    ld l, a

    ld a, d
    ld b, e

    pop de
    ret

copy_cells:
    ; Copies the cell data to the copy buffer.
    ld hl, cells
    ld de, cells_copy
    ld bc, 128
    ldir
    ret

restore_cells:
    ; Restores the copy buffer to the cell data.
    ld hl, cells_copy
    ld de, cells
    ld bc, 128
    ldir
    ret

neighbors:
    ; Count the neighbors of the cell at the coordinates specified.
    ; Input:
    ; a, b - x, y coordinates of the cell

    ; Returns:
    ; c - count of the neighbors

    push de
    ld d, a
    ld e, b
    push de

    ld c, 0
    dec a
    dec b
    call _neighbors_check ; x-1, y-1
    inc a
    call _neighbors_check ; x,   y-1
    inc a
    call _neighbors_check ; x+1, y-1
    dec a
    dec a
    inc b
    call _neighbors_check ; x-1, y
    inc a ; SKIP x, y
    inc a
    call _neighbors_check ; x+1, y
    dec a
    dec a
    inc b
    call _neighbors_check ; x-1, y+1
    inc a
    call _neighbors_check ; x,   y+1
    inc a
    call _neighbors_check ; x+1, y+1

    pop de
    ld a, d
    ld b, e
    pop de
    ret

_neighbors_check:
    push af
    call arrayIndex
    ld de, cells
    add hl, de
    ld a, (hl)
    cp 208
    pop de
    ld a, d
    jr nz, _neighbors_skip_increment
    inc c
_neighbors_skip_increment:
    ret

advance:
    call copy_cells
    ld a, 0
    ld b, 0

_advance_loop:
    ld c, a
    call arrayIndex
    ld de, cells
    add hl, de
    ld a, (hl)
    cp 208
    ld a, c
    jr z, _advance_alive
    jr _advance_dead

_advance_alive:
    ld d, a
    call neighbors
    ld a, c
    cp 2
    jr z, _advance_continue_restore
    cp 3
    jr z, _advance_continue_restore
    ld c, d
    ld a, c
    call arrayIndex
    ld de, cells_copy
    add hl, de
    ld a, 32
    ld (hl), a
    ld a, c
    jr _advance_continue

_advance_dead:
    ld d, a
    call neighbors
    ld a, c
    cp 3
    ld a, d
    jr nz, _advance_continue
    call arrayIndex
    ld de, cells_copy
    add hl, de
    ld d, a
    ld a, 208
    ld (hl), a
    ld a, d
    jr _advance_continue

_advance_continue_restore:
    ld a, d

_advance_continue:
    inc a
    cp 16
    jp nz, _advance_loop
    ld a, 0
    inc b
    ld c, a
    ld a, b
    cp 8
    ld a, c
    jr z, _advance_loop_end
    jp _advance_loop

_advance_loop_end:
    call restore_cells
    ret

cursor_up:
    ld a, (temp_cursor_row)
    sub 1
    and 7
    ld (temp_cursor_row), a
    jr _main_loop

cursor_down:
    ld a, (temp_cursor_row)
    add 1
    and 7
    ld (temp_cursor_row), a
    jr _main_loop

cursor_left:
    ld a, (temp_cursor_col)
    sub 1
    and 15
    ld (temp_cursor_col), a
    jr _main_loop

cursor_right:
    ld a, (temp_cursor_col)
    add 1
    and 15
    ld (temp_cursor_col), a
    jr _main_loop

toggle_cell:
    ld a, (temp_cursor_row)
    ld b, a
    ld a, (temp_cursor_col)
    call arrayIndex
    ld bc, cells
    add hl, bc
    ld a, (hl)
    xor 240
    ld (hl), a
    jr _main_loop

toggle_pause:
    ld a, (pause)
    xor 1
    ld (pause), a
    jr _main_loop

clear_cells:
    ld hl, cells
    ld de, cells+1
    ld bc, 127
    ld (hl), 32
    ldir
    jr _main_loop

single_step:
    call advance
    jp _main_loop

main:
    call CLEAR_DISP

    ld hl, initial_state
    ld de, cells
    ld bc, 128
    ldir

_main_loop:
    ld a, 0
    ROM_CALL STORE_KEY

    ld a, (pause)
    or a

    jr nz, _skip_advance
    call advance

_skip_advance:
    ROM_CALL UP_TEXT

    ld hl, (temp_cursor)
    ld (CURSOR_POS), hl

    ld a, 'X'
    ROM_CALL TR_CHARPUT

    ld a, (KEY_1)
    cp 0
    jr z, _main_loop

    ld b, 20
_debounce:
    halt
    djnz _debounce

    cp G_UP
    jp z, cursor_up
    cp G_DOWN
    jp z, cursor_down
    cp G_LEFT
    jp z, cursor_left
    cp G_RIGHT
    jp z, cursor_right
    cp G_ENTER
    jp z, toggle_cell
    cp G_DEL
    jp z, clear_cells
    cp G_MODE
    jp z, toggle_pause
    cp G_XTO
    jp z, single_step
    cp G_CLEAR
    jr nz, _main_loop

exit:
    ret

initial_state:
    db 32, 32, 32, 208, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32
    db 32, 32, 32, 32, 208, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32
    db 32, 32, 208, 208, 208, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32
    db 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 208, 32
    db 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 208, 32
    db 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 208, 32
    db 32, 32, 32, 32, 32, 32, 32, 32, 32, 208, 208, 32, 32, 32, 32, 32
    db 32, 'L', 'I', 'F', 'E', 32, 32, 32, 32, 208, 208, 32, 32, 32, 32, 32

temp_cursor:
    temp_cursor_row: db 0
    temp_cursor_col: db 0

pause:
    db 0
