;============================================================================
; CRASH82.INC for CrASH v1.1
;  made by Hideaki Omuro and Jeff Mears
;============================================================================

;============================================================================
; RAM Locations
;============================================================================
;Name             Address Len  Meaning
;===========      ======= ==== ==============================================
KEY_0:        equ 0x8000 ;Byte Scancode of last key, 0 if gotten
KEY_1:        equ 0x8001 ;Byte Scancode of key down now
KEY_2:        equ 0x8002 ;Byte Same as $8001, $FF if more than one key is down
KEY_STAT:     equ 0x8004 ;Byte Bit 2 set = key down now
LAST_KEY:     equ 0x8006 ;Byte Last key pressed
CONTRAST:     equ 0x8008 ;Byte Contrast ($00 to $1F)
CURSOR_POS:   equ 0x800C ;Word Text position for word operations
CURSOR_ROW:   equ 0x800C ;Byte Text cursor row
CURSOR_COL:   equ 0x800D ;Byte Text cursor column
BUSY_COUNTER: equ 0x8026 ;Byte Counter for busy indicator
BUSY_BITMAP:  equ 0x8027 ;Byte Bitmap for busy indicator
OP1:          equ 0x8028 ;  11 OP1
OP2:          equ 0x8033 ;  11 OP2
OP3:          equ 0x803E ;  11 OP3
OP4:          equ 0x8049 ;  11 OP4
OP5:          equ 0x8054 ;  11 OP5
OP6:          equ 0x805F ;  11 OP6
TEXT_MEM:     equ 0x808F ; 128 text memory
GRAF_CURS:    equ 0x8215 ;Word Cursor position for graphics
CURSOR_X:     equ 0x8215 ;Byte X value of graphics cursor
CURSOR_Y:     equ 0x8216 ;Byte Y value of graphics cursor
APD_BUF:      equ 0x8228 ; 768 APD screen buffer
_IY_TABLE:    equ 0x8528 ; N/A Where IY usually points
GRAPH_MEM:    equ 0x88B8 ; 768 Graphics Buffer
TEXT_MEM2:    equ 0x8BDF ; 128 Secondary text memory
WIN_START:    equ 0x8C8F ;Byte Number of first row in window
WIN_END:      equ 0x8C90 ;Byte Number of last row in window
CRASH_VER:    equ 0x8D73 ;Byte Version number of CrASH
VAT_START:    equ 0xFE6E ; N/A Start of VAT

; The following will be used in programs using the APD buffer.  If something
; important (ie. interrupt) is going on inside APD_BUF, INT_STATE will not
; be 00. (Look in CrASHprg.TXT for details)
APD_FREE:     equ 0x8D70 ;Word Public Free Mem of APD_BUF ($000=none, other=using)
INT_STATE:    equ 0x8D72 ;Byte Public Stat of Interrupts (00=none, other=using)

;============================================================================
; Variable Regions
;============================================================================
; You can allocate memory freely in FREE_A regions.
; You must be careful to not use FREE_B if your program calls CR_KHAND

;Free Memory Regions    Len Comments
;===================    === =================================================
FREE_A1: equ GRAPH_MEM ;768 Cleared when starting a program
FREE_A2: equ TEXT_MEM  ;128 Cleared when starting a program
FREE_A3: equ OP1       ; 66 Can be used if only using normal ROM_CALLs
FREE_B:  equ TEXT_MEM2 ;128 Cleared after calling CR_KHAND
FREE_C:  equ APD_BUF   ;768 If INT_STATE is not 0, check for available APD_FREE

;============================================================================
; CrASH call Addresses (use CALL)
;============================================================================
; This is a list of useful functions created by the authors of CrASH.  They
; are embedded into CrASH, and are very useful tools.

; Use CALL to call these functions.

EXIT_2_TIOS:  equ 0x8D88 ; Exits to TI-OS with a clear screen. (can use JP)
RAND:         equ 0x8D8B ; Returns a random number 0-127 in A.
CP_HL_BC:     equ 0x8D8E ; Compares HL and BC, like CP_HL_DE
CR_KHAND:     equ 0x8D91 ; Key_Hand; does not crash if turned off
CR_GRBCopy:   equ 0x8D94 ; Fast copy to LCD - Read below

; CR_GRBCopy is limited:
;  May not work correctly if LCD_Port is set to go auto right
;  May not work correctly if calc is turboed
;  Only copies from GRAPH_MEM
;  Still testing - please report bugs while using it.

;============================================================================
; ROM Addresses (use CALL)
;============================================================================
; This is a list of useful functions inside the TI-82's ROM.

; Use CALL to call these functions.

;AddressName  Address Registers Description
;============ ======= ========= =============================================
LD_HL_MHL:    equ 0x0033 ;HLA       HL=(HL), A=L
CP_HL_DE:     equ 0x0095 ;F         CP  HL, DE
UNPACK_HL:    equ 0x00A1 ;HLA       HL=int(HL/10), A=HL MOD 10
DIV_HL_A:     equ 0x00A3 ;HLA       HL=int(HL/A), A=HL MOD A
KEY_READ:     equ 0x01B8 ;AB        Does raw keyboard read with mask A; returns A
STORE_KEY:    equ 0x01C7 ;?         Store keystroke from A
GET_KEY:      equ 0x01D4 ;HL?       Get immediate keystroke into A
DISP_DELAY:   equ 0x07F3 ;          Delay for display controller      (60 clocks)
FIND_PIXEL:   equ 0x4166 ;?         Find pixel (rom page must be 4)

;============================================================================
; ROM Offset Addresses (use ROM_CALL)
;============================================================================
; To use functions not included here just make a definition like the ones
; below in your program (not recommended).  If you are using the addresses
; in rom found by another source for rom version 19, remember to subtract $1A
; from that address.  (The ones listed are roms version 16-18)

; Use ROM_CALL to call these functions.

ROM_CALL: macro addr
    call 0x8d74
    dw addr
endm

TR_CHARPUT:   equ 0x3738 ; Raw display of A on screen, normal text style
TX_CHARPUT:   equ 0x39D2 ; Xlated display of A on screen, normal text style
D_ZT_STR:     equ 0x38FA ; Display zero-terminated normal text string
D_LT_STR:     equ 0x373E ; Display length-byte normal text string
D_HL_DECI:    equ 0x387C ; Disp HL as 5-char, right just., blank-pad. integer
LAST_LINE:    equ 0x3774 ; Is it the last line?
NEXT_LINE:    equ 0x377A ; Goto next line (might scroll)
SCROLL_UP:    equ 0x3786 ; Scroll text screen up
UP_TEXT:      equ 0x37F2 ; Update text mem from command shadow

M_CHARPUT:    equ 0x37CE ; Display %A on screen, menu style
D_ZM_STR:     equ 0x37D4 ; Display zero-terminated string, menu style
D_LM_STR:     equ 0x37DA ; Display length indexed string, menu style

CLEARLCD:     equ 0x389A ; Clear LCD, but not text or graphics memory
CLEARTEXT_W:  equ 0x37B0 ; Clear LCD and text memory, but only current window (affected by 1,(IY+13))
CLEARTEXT_F:  equ 0x37A4 ; Clear LCD and text memory (affected by 1,(IY+13))
CLEAR_DISP:   equ 0x38CA ; Clear display
BACKUP_DISP:  equ 0x39C6 ; Copy display to APD_BUF
RESTOR_DISP:  equ 0x38DC ; Copy APD_BUF to display

; In OShell-82, two of these ROM functions are called by the TI-83 name which
; TI gave them.  To make easier for TI-83 programmers, the following two
; definitions are included, although NOT recommended for usage AT ALL.
;                                    ===                       ======
; Also, there are alternate CrASH calls that will do the same thing, but
; enhanced.  (Look above)

DISP_GRAPH:   equ 0x38AC ; Display contents of GRAPH_MEM on LCD
KEY_HAND:     equ 0x3924 ; Get key using key handler (2nd, alpha, contrast)

_GRBUFCPY_V:  equ DISP_GRAPH ; Way too slow
_GETKEY:      equ KEY_HAND   ; Crashes when you turn off calc. (not a joke)

;============================================================================
; Ports
;============================================================================
P_LINK:       equ 0x00   ; Link port                                  (TI-85)
P_KEYBOARD:   equ 0x01   ; Port used to access keys                   (TI-85)
P_ROM:        equ 0x02   ; Rom page switching and other things
P_STATUS:     equ 0x03   ; Used to get/set status of varius hardware
P_INT:        equ 0x04   ; Interrupt speed (don't change!!! the display needs it)
P_LCD_CON:    equ 0x10   ; Control port for display controller        (TI-83)
P_LCD_DATA:   equ 0x11   ; Data port for display controller           (TI-83)

;============================================================================
; Misc
;============================================================================
TEXT_START: macro
    res 1, (iy+0x0d)
    res 2, (iy+0x0d)
    ROM_CALL CLEAR_DISP
    ld hl, 0x0000
    ld (CURSOR_POS), hl
endm

TEXT_END: macro
    set 2, (iy+0x0d)
    set 1, (iy+0x0d)
endm

G_NONE:   equ 0x00
G_DOWN:   equ 0x01
G_LEFT:   equ 0x02
G_RIGHT:  equ 0x03
G_RIGTH:  equ 0x03 ; Included because author of ASH couldn't spell :)
G_UP:     equ 0x04
G_ENTER:  equ 0x09
G_PLUS:   equ 0x0A
G_MINUS:  equ 0x0B
G_TIMES:  equ 0x0C
G_DIV:    equ 0x0D
G_CARROT: equ 0x0E
G_CLEAR:  equ 0x0F
G_NEG:    equ 0x11
G_3:      equ 0x12
G_6:      equ 0x13
G_9:      equ 0x14
G_PARENR: equ 0x15
G_TAN:    equ 0x16
G_VARS:   equ 0x17
G_PERIOD: equ 0x19
G_2:      equ 0x1A
G_5:      equ 0x1B
G_8:      equ 0x1C
G_PARENL: equ 0x1D
G_COS:    equ 0x1E
G_PRGM:   equ 0x1F
G_STAT:   equ 0x20
G_0:      equ 0x21
G_1:      equ 0x22
G_4:      equ 0x23
G_7:      equ 0x24
G_COMMA:  equ 0x25
G_SIN:    equ 0x26
G_MATRIX: equ 0x27
G_XTO:    equ 0x28
G_ON:     equ 0x29
G_STO:    equ 0x2A
G_LN:     equ 0x2B
G_LOG:    equ 0x2C
G_SQR:    equ 0x2D
G_INVE:   equ 0x2E
G_MATH:   equ 0x2F
G_ALPHA:  equ 0x30
G_GRAPH:  equ 0x31
G_TRACE:  equ 0x32
G_ZOOM:   equ 0x33
G_WINDOW: equ 0x34
G_YEDIT:  equ 0x35
G_2ND:    equ 0x36
G_MODE:   equ 0x37
G_DEL:    equ 0x38

K_RIGTH:   equ 1 ; RIGHT     RIGHT
K_RIGHT:   equ 1 ; RIGHT     RIGHT
K_LEFT:    equ 2 ; LEFT      LEFT
K_UP:      equ 3 ; UP        UP
K_DOWN:    equ 4 ; DOWN      DOWN
K_ENTER:   equ 5 ; ENTER     ENTER
K_CLEAR:   equ 6 ; CLEAR     CLEAR
K_DEL:     equ 7 ; DEL       DEL
K_INS:     equ 8 ; DEL       INS
K_RCL:     equ 9 ; STO>      RCL
K_ENTRY:   equ 10 ; ENTER     ENTRY
K_BOL:     equ 11 ; LEFT      BOL
K_EOL:     equ 12 ; RIGHT     EOL
K_PRGM:    equ 45 ; PRGM      PRGM
K_ZOOM:    equ 46 ; ZOOM      ZOOM
K_DRAW:    equ 47 ; PRGM      DRAW
K_PLOT:    equ 48 ; Y=        STAT PLOT
K_MATH:    equ 49 ; MATH      MATH
K_TEST:    equ 50 ; MATH      TEST
K_VARS:    equ 52 ; VARS      VARS
K_MEM:     equ 53 ; +         MEM
K_MATRIX:  equ 54 ; MATRIX    MATRIX
K_STAT:    equ 55 ; STAT      STAT
K_Y-VARS:  equ 56 ; VARS      Y-VARS
K_ANGLE:   equ 57 ; MATRIX    ANGLE
K_LIST:    equ 58 ; STAT      LIST
K_CALC:    equ 59 ; TRACE     CALC
K_QUIT:    equ 64 ; MODE      QUIT
K_LINK:    equ 65 ; X,T,theta LINK
K_GRAPH:   equ 69 ; GRAPH     GRAPH
K_MODE:    equ 70 ; MODE      MODE
K_WINDOW:  equ 73 ; WINDOW    WINDOW
K_YEDIT:   equ 74 ; Y=        Y=
K_TABLE:   equ 75 ; GRAPH     TABLE
K_TBLSET:  equ 76 ; WINDOW    TblSet
K_TRACE:   equ 93 ; TRACE     TRACE
K_PLUS:    equ 129 ; +         +
K_MINUS:   equ 130 ; -         -
K_TIMES:   equ 131 ; *         *
K_DIV:     equ 132 ; /         /
K_POWER:   equ 133 ; ^         ^
K_LPAREN:  equ 134 ; (         (
K_RPAREN:  equ 135 ; )         )
K_LBRACK:  equ 136 ; *         [
K_RBRACK:  equ 137 ; -         ]
K_STO:     equ 139 ; STO>      STO>
K_COMMA:   equ 140 ; ,         ,
K_NEG:     equ 141 ; (-)       (-)
K_PERIOD:  equ 142 ; .         .
K_0:       equ 143 ; 0         0
K_1:       equ 144 ; 1         1
K_2:       equ 145 ; 2         2
K_3:       equ 146 ; 3         3
K_4:       equ 147 ; 4         4
K_5:       equ 148 ; 5         5
K_6:       equ 149 ; 6         6
K_7:       equ 150 ; 7         7
K_8:       equ 151 ; 8         8
K_9:       equ 152 ; 9         9
K_EE:      equ 153 ; ,         EE
K_SEMI:    equ 154 ; 0         ;
K_A:       equ 155 ; MATH      A
K_B:       equ 156 ; MATRIX    B
K_C:       equ 157 ; PRGM      C
K_D:       equ 158 ; X^-1      D
K_E:       equ 159 ; SIN       E
K_F:       equ 160 ; COS       F
K_G:       equ 161 ; TAN       G
K_H:       equ 162 ; ^         H
K_I:       equ 163 ; X^2       I
K_J:       equ 164 ; ,         J
K_K:       equ 165 ; (         K
K_L:       equ 166 ; )         L
K_M:       equ 167 ; /         M
K_N:       equ 168 ; LOG       N
K_O:       equ 169 ; 7         O
K_P:       equ 170 ; 8         P
K_Q:       equ 171 ; 9         Q
K_R:       equ 172 ; *         R
K_S:       equ 173 ; LN        S
K_T:       equ 174 ; 4         T
K_U:       equ 175 ; 5         U
K_V:       equ 176 ; 6         V
K_W:       equ 177 ; -         W
K_X:       equ 178 ; STO>      X
K_Y:       equ 179 ; 1         Y
K_Z:       equ 180 ; 2         Z
K_XTO:     equ 181 ; X,T,theta X,T,theta
K_PI:      equ 182 ; ^         Pi
K_INVERSE: equ 183 ; X^-1      X^-1
K_SIN:     equ 184 ; SIN       SIN
K_ASIN:    equ 185 ; SIN       SIN^-1
K_COS:     equ 186 ; COS       COS
K_ACOS:    equ 187 ; COS       COS^-1
K_TAN:     equ 188 ; TAN       TAN
K_ATAN:    equ 189 ; TAN       TAN^-1
K_SQR:     equ 190 ; X^2       X^2
K_SQRT:    equ 191 ; X^2       SQRT
K_LN:      equ 192 ; LN        LN
K_EX:      equ 193 ; LN        e^X
K_LOG:     equ 194 ; LOG       LOG
K_TENP:    equ 195 ; LOG       10^X
K_ANS:     equ 198 ; (-)       ANS
K_COLON:   equ 199 ; .         :
K_QUEST:   equ 203 ; (-)       ?
K_QUOTE:   equ 204 ; +         "
K_THETA:   equ 205 ; 3         THETA
K_LBRACE:  equ 237 ; (         {
K_RBRACE:  equ 238 ; )         }
K_ABS:     equ 244 ; X^-1      ABS
K_L1:      equ 245 ; 1         L1
K_L2:      equ 246 ; 2         L2
K_L3:      equ 247 ; 3         L3
K_L4:      equ 248 ; 4         L4
K_L5:      equ 249 ; 5         L5
K_L6:      equ 250 ; 6         L6
K_n:       equ 251 ; 9         n
K_Vn1:     equ 252 ; 8         Vn-1
K_Un1:     equ 253 ; 7         Un-1

START_ADDR: equ 0x9104
org START_ADDR       ; All CrASH Programs will start at address 0x9104.
