; Progname:BALLRAC
;*********************************************Initialisation du programme*********************************************

#include "crash82.inc"
#include "Multikey.h"

.db "Ball Race v1.2",0

temp_a		=	TEXT_MEM
lateral_initial	=	TEXT_MEM+1
largeur		=	TEXT_MEM+2
negatif		=	TEXT_MEM+3
changelargeur	=	TEXT_MEM+4
mode		=	TEXT_MEM+5


;******************************Prsentation et validation de la prsentation avec ENTER******************************
debut:
	ld a,0
	ld (mode),a

	ld hl,bandeau_ballrace
	ld de,GRAPH_MEM
	ld bc,288
	ldir

	ld hl,GRAPH_MEM+288
	ld (hl),0
	ld de,GRAPH_MEM+289
	ld bc,479
	ldir
	ROM_CALL(DISP_GRAPH)

	ld hl,$1B09
	ld (GRAF_CURS),hl
	ld hl,textauteurdebu
	ROM_CALL(D_ZM_STR)

	ld hl,$2817
	ld (GRAF_CURS),hl
	ld hl,textpetitdebu
	ROM_CALL(D_ZM_STR)

	ld hl,$3007
	ld (GRAF_CURS),hl
	ld hl,textpetitdebu2
	ROM_CALL(D_ZM_STR)

	ld hl,$3816
	ld (GRAF_CURS),hl
	ld hl,textpetitdebu3
	ROM_CALL(D_ZM_STR)


	ld bc,0
valider_debut:
	inc bc
	ld a,b
	cp 8
	jp z,inc_d
	call GET_KEY
	cp G_MODE
	ret z
	cp G_ALPHA
	jp z,edit_circuit
	cp G_ENTER
	jr nz,valider_debut

	ROM_CALL(CLEARLCD)
	ld hl,$0201
	ld (CURSOR_POS),hl
	ld hl,camera
	ROM_CALL(D_ZT_STR)




valide_camera:
	call GET_KEY
	cp G_2
	jr z,mode_1
	cp G_1
	jr z,place_image
	jr valide_camera

mode_1:
	ld a,1
	ld (mode),a


;**************************************************BOUCLE PRINCIPALE**************************************************
place_image:


;********************Ici, on affiche l'image  rptition tant que l'on n'appuie pas sur une touche********************

;**********Tous les GRAPH_MEM  0 avant d'afficher une nouvelle image**********

	ld hl,GRAPH_MEM
	ld (hl),0
	ld de,GRAPH_MEM+1
	ld bc,767
	ldir

;**************************************************Placement du circuit 3D**************************************************

	ld hl,GRAPH_MEM-12

	push hl

	ld a,9
	ld (largeur),a
	
boucle_40:

	inc a
	ld (largeur),a
	ld a,(changelargeur)
	xor 1
	ld (changelargeur),a
	or a
	jr z,largeurnormal
	ld a,(largeur)	
	dec a
	ld (largeur),a

largeurnormal:

;*****Mise en place du lateral d'origine*****

	ld a,(largeur)
	ld b,a
	ld a,48
	sub b
	sub b
	sub b
	sub b
	ld (lateral),a


;*****Calcul du dcalage d au dplacement lateral*****

	ld a,0
	ld (negatif),a

	ld a,(lateral_initial)
	cp 128
	jr c,positif
	ld a,1
	ld (negatif),a
	ld a,(lateral_initial)
	neg
positif:

	ld d,0
	ld e,a		;lateral_initial dans de
	ld a,(largeur)	;largeur dans a

	ld hl,0
boucle_a:
	add hl,de
	dec a
	or a
	jr nz,boucle_a
			;On obtient ici dans hl le lateral_initial multipli par la largeur

	ld a,5
boucle_5:
	srl h
	rr l
	dec a
	or a
	jr nz,boucle_5
			;On obtient ici hl divis par 32 pour mettre  l'chelle. La valeur est restrictible dans l.


	ld a,(negatif)
	ld b,a
	sra b
	jr nc,positif2
	ld a,l
	neg
	ld l,a
positif2:
	ld a,(lateral)
	add a,l
	ld (lateral),a


	pop hl
	ld de,12		;Dcalage de l'adresse d'une ligne vers le bas (hl+12)
	add hl,de
	push hl


;*****On gre dans une boucle les 8 cases d'une ligne de chemin*****

	ld c,%01000000

boucle_8:

	ld a,(largeur)
	ld b,a
	ld a,(lateral)
	add a,b			;On ajoute au dcalage la largeur obtenue en changeant de case
	ld (lateral),a



	call trouver_adresse_circuit

	ld a,(de)
	and c			;Masque
	jr z,rien_a_afficher

	pop hl
	push hl

	ld e,0

	ld a,(lateral)
	cp 128
	jp c,convert_plus
	jp convert_moins
fin_convert:

	ld a,(largeur)
	ld d,a
	ld a,0
boucle_b:
	sla a
	inc a
	dec d
	djnz boucle_b

	ld (temp_a),a
	ld a,e
	cp 12
	ld a,(temp_a)
	jr nc,boucle_octet

	or (hl)
	ld (hl),a

boucle_octet:
	inc e
	inc hl
	ld a,d
	cp 8
	jr nc,trace8
	ld a,0
	jr suite2

trace8:
	jr z,suite2
	sub 8
	ld d,a

	ld a,e
	cp 12
	jr nc,boucle_octet	

	ld (hl),$FF
	jr boucle_octet
suite2:
	srl a
	add a,128
	dec d
	jr nz,suite2

	ld (temp_a),a
	ld a,e
	cp 12
	ld a,(temp_a)
	jr nc,rien_a_afficher

	or (hl)
	ld (hl),a


rien_a_afficher:

	sra c
	ld a,c
	cp 1
	jr nz,boucle_8

	ld a,(largeur)
	cp 41
	jp nz,boucle_40


	pop hl


;***************Placement de la balle (superposition par rapport au circuit en xor (inverse))**************

	ld de,GRAPH_MEM+545

	ld a,(mode)
	or a
	jr z,no_mode_4
	ld de,GRAPH_MEM+41
no_mode_4:

	ld a,(ballesaute)
	cp 14
	jp z,initballe
	or a
	jr z,suite
	
sautdeballe:

	ld hl,donnees_hauteur

	ld a,(mode)
	or a
	jr z,no_mode_5
	ld hl,donnees_hauteur_2
no_mode_5:
	
	ld a,(ballesaute)

	ld b,0
	ld c,a
	add hl,bc

	ld l,(hl)
	ld h,0

	ex de,hl
	or a
	sbc hl,de
	ex de,hl

	inc a
	ld (ballesaute),a


suite:

;**********Routine d'affichage de la balle**********

	ld a,(small_avancee)
	sra a
	or a
	call z,balle_1
	cp 1
	call z,balle_2
	cp 2
	call z,balle_3
	cp 3
	call z,balle_4

	ld a,(mode)
	or a
	jr z,no_mode_3
	ld a,(small_avancee)
	sra a
	or a
	call z,balle_1_2
	cp 1
	call z,balle_2_2
	cp 2
	call z,balle_3_2
	cp 3
	call z,balle_4_2
no_mode_3:

	ld b,(hl)
	inc hl
	ld c,(hl)
	inc hl

change_ligne:
	push bc
	push de
change_colonne:

	ld a,(hl)
	inc hl

	push bc

	ld b,a
	ld a,(de)
	xor b

	pop bc

	ld (de),a

	inc de
	djnz change_colonne
	pop de
	ld bc,12
	ex de,hl
	add hl,bc
	ex de,hl
	pop bc
	dec c
	jr nz,change_ligne

;**********Est-ce qu'on a perdu ?**********
	ld a,(ballesaute)
	or a
	jr nz,en_lair
	ld hl,GRAPH_MEM+545+(15*12)

	ld a,(mode)
	or a
	jr z,no_mode_6
	ld hl,GRAPH_MEM+41+(8*12)
no_mode_6:
	ld a,(hl)
	and %00000001
	jr z,test_droite
	jr en_lair
test_droite:
	ld hl,GRAPH_MEM+545+(15*12)+1

	ld a,(mode)
	or a
	jr z,no_mode_7
	ld hl,GRAPH_MEM+41+(8*12)+1
no_mode_7:
	ld a,(hl)
	and %10000000
	jp z,perdu
en_lair:

;**********Procdure qui inverse tous les pixels de l'cran lorsque avancee est  0 ou 128**********

	ld a,(avancee)
	and %01111111	;(si a=0 ou a=128  l'origine, alors a=0 aprs le masque)
	jr nz,pas_inversion
	ld a,(vitesse)
	or a
	jr z,pas_inversion

	ld bc,768+255
	ld hl,GRAPH_MEM-1
boucle_768:	
	inc hl
	ld a,(hl)
	xor %11111111
	ld (hl),a
	dec bc
	ld a,b
	or a
	jr nz,boucle_768

pas_inversion:

;**********ET VOILA !! TOUT CE QU'ON A PLACE DANS LES GRAPH_MEM, ON L'AFFICHE !!! **********

	CALL CR_GRBCopy

;**********Si une touche est presse, ici, on gre la touche presse**********

	Multi_Key(KEY_26)	;Flche droite
	call nz,deplace_droite
	Multi_Key(KEY_24)	;Flche gauche
	call nz,deplace_gauche
	Multi_Key(KEY_21)	;Touche 2ND
	call nz,sauteballe
	Multi_Key(KEY_22)	;Touche MODE
	jp nz,debut
	Multi_Key(KEY_25)	;Flche haute
	call nz,vitesse_plus
	Multi_Key(KEY_34)	;Flche basse	(cette routine Multi_Key est Tera-pratique !!!)
	call nz,vitesse_moins			;(KEY_xx: xx correspond aux numros de touches en langage BASIC)

gestion_vitesses:

;**********Gestion de l'avancee en fonction de la vitesse**********
	ld a,(vitesse)
	add a,32
	sra a
	sra a
	sub 8
	ld b,a
	ld a,(small_avancee)
	add a,b
	ld (small_avancee),a
	cp 128
	jr nc,moins

	cp 8
	jr c,no_prblm
	sub 8
	ld (small_avancee),a
	ld a,(avancee)
	inc a
	ld (avancee),a
	or a
	call z,inc_bigavancee
	jr no_prblm
moins:
	add a,8
	ld (small_avancee),a
	ld a,(avancee)
	dec a
	ld (avancee),a
	cp -1
	call z,dec_bigavancee
no_prblm:

;**********Gestion du lateral_initial en fonction de la vitesse_lateral**********

;Reduction de la vitesse_lateral

	ld a,(vitesse_lateral)
	or a
	jr z,fin_reduc
	cp 128
	jr nc,moin
	dec a
	jr fin_reduc
moin:
	inc a
fin_reduc:
	ld (vitesse_lateral),a

	ld b,a
	ld a,(lateral_initial)
	add a,b
	ld (lateral_initial),a
	cp 128
	jr nc,moins2

	cp 107
	jr c,no_prblm2
	ld a,107
	ld (lateral_initial),a
	jr no_prblm2
moins2:
	cp -107
	jr nc,no_prblm2
	ld a,-107
	ld (lateral_initial),a
no_prblm2:



;*****Retour au debut de la boucle principale*****
	jp place_image	




;+++++++++++++++++++ENSEMBLE DES DONNEES ET SOUS-PROGRAMMES+++++++++++++++++++++



;**********L, on gre le debut du saut de la balle**********

sauteballe:
	ld a,(ballesaute)
	or a
	ret nz
	ld a,1
	ld (ballesaute),a
	ret

initballe:
	ld a,0
	ld (ballesaute),a
	jp place_image

deplace_droite:
	ld a,(vitesse_lateral)
	sub 2
	cp -10
	jr nz,suite_droite
	add a,2
suite_droite:
	ld (vitesse_lateral),a
	ret
deplace_gauche:
	ld a,(vitesse_lateral)
	add a,2
	cp 10
	jr nz,suite_gauche
	sub 2
suite_gauche:
	ld (vitesse_lateral),a
	ret

convert_plus:
	inc e
	inc hl
	sub 8
	jr nc,convert_plus
	neg
	dec e
	dec hl
	ld b,a
	jp fin_convert

convert_moins:
	dec e
	dec hl
	add a,8
	jr nc,convert_moins
	sub 8
	neg
	ld b,a
	jp fin_convert

trouver_adresse_circuit:

	ld hl,circuit+3

	ld a,(bigavancee)
	add a,h
	ld h,a

	ld a,(avancee)
	ld d,0
	ld e,a
	add hl,de
	ex de,hl

	push de

	ld a,(small_avancee)
	sra a
	or a
	call z,avancee_1
	cp 1
	call z,avancee_2
	cp 2
	call z,avancee_3
	cp 3
	call z,avancee_4

	ld a,(mode)
	or a
	jr z,no_mode_1
	ld a,(small_avancee)
	sra a
	or a
	call z,avancee_4
	cp 1
	call z,avancee_3
	cp 2
	call z,avancee_2
	cp 3
	call z,avancee_1
no_mode_1:
	
	ld a,(largeur)
	sub 7
	ld d,0
	ld e,a
	add hl,de

	ld a,(mode)
	or a
	jr z,no_mode_2
	ld a,(hl)
	ld b,a
	ld a,12
	sub b
	jr suite_mode_1
no_mode_2:
	ld a,(hl)
suite_mode_1:
	pop de
	ex de,hl
	ld d,0
	ld e,a
	add hl,de
	ex de,hl

	ret

avancee_1:
	ld hl,donnees_distance_1
	ret
avancee_2:
	ld hl,donnees_distance_2
	ret
avancee_3:
	ld hl,donnees_distance_3
	ret
avancee_4:
	ld hl,donnees_distance_4
	ret

balle_1:
	ld hl,balle1
	ret
balle_2:
	ld hl,balle2
	ret
balle_3:
	ld hl,balle3
	ret
balle_4:
	ld hl,balle4
	ret

balle_1_2:
	ld hl,balle1_2
	ret
balle_2_2:
	ld hl,balle2_2
	ret
balle_3_2:
	ld hl,balle3_2
	ret
balle_4_2:
	ld hl,balle4_2
	ret

vitesse_plus:
	ld a,(vitesse)
	inc a
	ld (vitesse),a
	cp 33
	ret nz
	ld a,32
	ld (vitesse),a
	ret

vitesse_moins:
	ld a,(vitesse)
	dec a
	ld (vitesse),a
	cp -33
	ret nz
	ld a,32
	ld (vitesse),a
	ret


inc_d:
	ld bc,0
	inc d
	jp nz,valider_debut

inc_bigavancee:
	ld a,(bigavancee)
	inc a
	ld (bigavancee),a
	cp 5
	ret nz
	ld a,0
	ld (bigavancee),a
	ld (avancee),a
	ld (vitesse),a
	ld (vitesse_lateral),a
	ld (lateral_initial),a
	ret

dec_bigavancee:
	ld a,(bigavancee)
	dec a
	ld (bigavancee),a
	cp -1
	ret nz
	ld a,0
	ld (bigavancee),a
	ld (avancee),a
	ld (small_avancee),a
	ld (vitesse),a
	ret

perdu:
	
	ld a,0
	ld (small_avancee),a
	ld (lateral_initial),a
	ld (vitesse),a
	ld (vitesse_lateral),a
	ld a,7
	ld (ballesaute),a

	ld a,(avancee)
	cp 128
	jr nc, cent_vingt_huit
	ld a,1
	ld (avancee),a
	jp place_image
cent_vingt_huit:
	ld a,129	
	ld (avancee),a
	jp place_image


;@@@@@@@@@@Attention ! Toute cette partie correspond  l'diteur de circuit !@@@@@@@@@@@@@@@@@@@@@

edit_circuit:

;**********Tous les GRAPH_MEM  0**********

	ld hl,GRAPH_MEM
	ld (hl),0
	ld de,GRAPH_MEM+1
	ld bc,767
	ldir

;**********Bande  gauche**********
	ld hl,GRAPH_MEM-10
	ld b,32
	ld de,24
boucle_bande_gauche:
	add hl,de
	ld (hl),$FF
	djnz boucle_bande_gauche

;**********Bande  droite**********
	ld hl,GRAPH_MEM-3
	ld b,32
	ld de,24
boucle_bande_droite:
	add hl,de
	ld (hl),$FF
	djnz boucle_bande_droite



;**********Affichage du terrain en 2D**********

	ld hl,circuit-1
	ld a,(bigavancee)
	add a,h
	ld h,a				;Adresse circuit dans de
	ld a,(avancee)
	ld d,0
	ld e,a
	add hl,de
	ex de,hl

	ld hl,GRAPH_MEM+9+(8*8*12)	;Adresse GRAPH_MEM dans hl
	
	ld a,(KEY_1)
	cp G_2ND
	jr nz,no_changement
	push de
	push hl
	ex de,hl
	ld de,4
	add hl,de

	ld a,(pos_selecteur)
	ld b,a
	ld a,(hl)
	xor b
	ld (hl),a
	pop hl
	pop de

;**********Procdure de temporisation pour viter que la case slectionne ne clignote (le processeur est trop rapide !!!)**********
	ld a,255
	ld b,255
tempo:
	dec a
tempo_2:
	djnz tempo_2
	or a
	jr nz,tempo
;**********Fin de la temporisation**********


no_changement:

	ld b,8
boucle_hauteur:
	inc de		;Incrmentation de l'adresse circuit

	push de
	ld de,6
	or a			;Retour  gauche de hl
	sbc hl,de
	ld de,12*8	
	or a			;Remonte de hl d'une case vers le haut
	sbc hl,de
	pop de
	
	ld c,%01000000
boucle_largeur:	
	ld a,(de)
	and c
	jr z,rien_afficher

	push de
	push hl
	ld de,12
	ld (hl),$FF
	add hl,de
	ld (hl),$FF
	add hl,de
	ld (hl),$FF
	add hl,de
	ld (hl),$FF
	add hl,de
	ld (hl),$FF
	add hl,de
	ld (hl),$FF
	add hl,de
	ld (hl),$FF
	add hl,de
	ld (hl),$FF

	pop hl
	pop de

rien_afficher:
	inc hl	;Dcalage de hl d'une case vers la droite
	sra c
	ld a,c
	cp 1
	jr nz,boucle_largeur

	djnz boucle_hauteur


;********************Affichage du slecteur********************

	ld hl,GRAPH_MEM+3+(4*8*12)
	ld a,(pos_selecteur)	
decalage_lateral:		;On trouve l'adresse d'affichage du slecteur
	inc hl
	sla a
	cp 128
	jr nz,decalage_lateral
	dec hl

	ld b,8
	ld de,selection

boucle_selecteur:

	ld a,(de)
	ld c,a
	ld a,(hl)
	xor c
	ld (hl),a

	inc de
	push de
	ld de,12
	add hl,de
	pop de
	djnz boucle_selecteur

	ROM_CALL(DISP_GRAPH)

	call GET_KEY

	cp G_UP
	jr z,inc_avancee
	cp G_DOWN
	jr z,dec_avancee

	cp G_LEFT
	jr z,dec_lateral
	cp G_RIGHT
	jr z,inc_lateral

	cp G_MODE
	jp nz,edit_circuit

	ld hl,ballesaute

	ld b,7
	call initializ
	
	jp debut
;@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@

;&&&&&&&&&&&&&&&Sous-programmes propres  l'diteur de circuit&&&&&&&&&&&&&&&

initializ:
	ld (hl),0
	inc hl
	djnz initializ
	ret

inc_avancee:
	ld a,(avancee)
	inc a
	ld (avancee),a
	or a
	call z,inc_bigavancee
	jp edit_circuit

dec_avancee:
	ld a,(avancee)
	dec a
	ld (avancee),a
	cp -1
	call z,dec_bigavancee
	jp edit_circuit

inc_lateral:
	ld a,(pos_selecteur)
	sra a
	ld (pos_selecteur),a
	cp %00000001
	jp nz,edit_circuit
	ld a,%00000010
	ld (pos_selecteur),a
	jp edit_circuit

dec_lateral:
	ld a,(pos_selecteur)
	sla a
	ld (pos_selecteur),a
	cp %10000000
	jp nz,edit_circuit
	ld a,%01000000
	ld (pos_selecteur),a
	jp edit_circuit

;&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&


textauteurdebu:
	.db "realise par Joel LECRUX",0

textpetitdebu:
	.db "Jouer => ENTER",0

textpetitdebu2:
	.db "Editer le circuit => ALPHA",0

textpetitdebu3:
	.db "Quitter => MODE",0

camera:
	.db "MODE CAMERA:  "
	.db "                "
	.db " 1: Vue arriere "
	.db " 2: Vue opposee",0


ballesaute:
	.db 0
small_avancee:
	.db 0
avancee	:
	.db 0
bigavancee:
	.db 0
lateral:
	.db 0
vitesse:
	.db 0
vitesse_lateral:
	.db 0
pos_selecteur:
	.db %00010000


balle1:
	.db 2,16
	.db %00000000,%00000000
	.db %00000111,%11100000
	.db %00011111,%11111000
	.db %00111111,%11111100
	.db %00111111,%11111100
	.db %01111111,%11111110
	.db %01111111,%11111110
	.db %01111111,%11111110
	.db %01111111,%11111110
	.db %01111111,%11111110
	.db %01111111,%11111110
	.db %00111111,%11111100
	.db %00111111,%11111100
	.db %00011111,%11111000
	.db %00000111,%11100000
	.db %00000000,%00000000

balle2:
	.db 2,16
	.db %00000000,%00000000
	.db %00000111,%11100000
	.db %00011111,%11111000
	.db %00111111,%11111100
	.db %00111111,%11111100
	.db %01111111,%11111110
	.db %01111111,%11111110
	.db %01111111,%11111110
	.db %01111111,%11111110
	.db %01111111,%11111110
	.db %00101111,%11111010
	.db %00010101,%01010100
	.db %00101010,%10101000
	.db %00010101,%01010000
	.db %00000010,%10100000
	.db %00000000,%00000000

balle3:
	.db 2,16
	.db %00000000,%00000000
	.db %00000111,%11100000
	.db %00011111,%11111000
	.db %00111111,%11111100
	.db %00111111,%11111100
	.db %01110101,%01011110
	.db %00101010,%10101010
	.db %01010101,%01010100
	.db %00101010,%10101010
	.db %01010101,%01010100
	.db %01111010,%10101110
	.db %00111111,%11111100
	.db %00111111,%11111100
	.db %00011111,%11111000
	.db %00000111,%11100000
	.db %00000000,%00000000

balle4:
	.db 2,16
	.db %00000000,%00000000
	.db %00000101,%01000000
	.db %00001010,%10101000
	.db %00010101,%01010100
	.db %00101010,%10101000
	.db %01011111,%11110100
	.db %01111111,%11111110
	.db %01111111,%11111110
	.db %01111111,%11111110
	.db %01111111,%11111110
	.db %01111111,%11111110
	.db %00111111,%11111100
	.db %00111111,%11111100
	.db %00011111,%11111000
	.db %00000111,%11100000
	.db %00000000,%00000000


balle1_2:
	.db 2,8
	.db %00000001,%10000000
	.db %00000111,%11100000
	.db %00000111,%11100000
	.db %00001111,%11110000
	.db %00001111,%11110000
	.db %00000111,%11100000
	.db %00000111,%11100000
	.db %00000001,%10000000

balle2_2:
	.db 2,8
	.db %00000000,%10000000
	.db %00000101,%01000000
	.db %00000010,%10100000
	.db %00001111,%11110000
	.db %00001111,%11110000
	.db %00000111,%11100000
	.db %00000111,%11100000
	.db %00000001,%10000000

balle3_2:
	.db 2,8
	.db %00000001,%10000000
	.db %00000111,%11100000
	.db %00000111,%11100000
	.db %00000101,%01010000
	.db %00001010,%10100000
	.db %00000111,%11100000
	.db %00000111,%11100000
	.db %00000001,%10000000

balle4_2:
	.db 2,8
	.db %00000001,%10000000
	.db %00000111,%11100000
	.db %00000111,%11100000
	.db %00001111,%11110000
	.db %00001111,%11110000
	.db %00000101,%01000000
	.db %00000010,%10100000
	.db %00000001,%00000000


donnees_hauteur:
	.db 0
	.db 72
	.db 132
	.db 180
	.db 204
	.db 216
	.db 228
	.db 240
	.db 228
	.db 216
	.db 204
	.db 180
	.db 132
	.db 72

donnees_hauteur_2:
	.db 0
	.db 36
	.db 60
	.db 84
	.db 96
	.db 108
	.db 120
	.db 120
	.db 120
	.db 108
	.db 96
	.db 84
	.db 60
	.db 36

donnees_distance_1:
	.db 10
	.db 9
	.db 8
	.db 7
	.db 7
	.db 6
	.db 6
	.db 5
	.db 5
	.db 5
	.db 4
	.db 4
	.db 4
	.db 3
	.db 3
	.db 3
	.db 2
	.db 2
	.db 2
	.db 2
	.db 1
	.db 1
	.db 1
	.db 1
	.db 1
	.db 1
	.db 0
	.db 0
	.db 0
	.db 0
	.db 0
	.db 0
	.db 0
	.db 0
	.db 0

donnees_distance_2:
	.db 10
	.db 9
	.db 8
	.db 8
	.db 7
	.db 7
	.db 6
	.db 6
	.db 5
	.db 5
	.db 4
	.db 4
	.db 4
	.db 3
	.db 3
	.db 3
	.db 3
	.db 2
	.db 2
	.db 2
	.db 2
	.db 1
	.db 1
	.db 1
	.db 1
	.db 1
	.db 1
	.db 1
	.db 1
	.db 0
	.db 0
	.db 0
	.db 0
	.db 0
	.db 0

donnees_distance_3:
	.db 10
	.db 9
	.db 8
	.db 8
	.db 7
	.db 7
	.db 6
	.db 6
	.db 5
	.db 5
	.db 5
	.db 4
	.db 4
	.db 4
	.db 3
	.db 3
	.db 3
	.db 3
	.db 2
	.db 2
	.db 2
	.db 2
	.db 2
	.db 1
	.db 1
	.db 1
	.db 1
	.db 1
	.db 1
	.db 1
	.db 1
	.db 0
	.db 0
	.db 0
	.db 0

donnees_distance_4:
	.db 10
	.db 9
	.db 8
	.db 8
	.db 7
	.db 7
	.db 6
	.db 6
	.db 6
	.db 5
	.db 5
	.db 5
	.db 4
	.db 4
	.db 4
	.db 3
	.db 3
	.db 3
	.db 3
	.db 2
	.db 2
	.db 2
	.db 2
	.db 2
	.db 1
	.db 1
	.db 1
	.db 1
	.db 1
	.db 1
	.db 1
	.db 1
	.db 1
	.db 0
	.db 0

selection:	;Curseur qui se dplace dans l'diteur

	.db %00000000
	.db %01000010
	.db %01100110
	.db %00111100
	.db %00111100
	.db %01100110
	.db %01000010
	.db %00000000



bandeau_ballrace:	;Dfinition du bandeau de prsentation. Convertissez l'hexadcimal en binaire et vous verrez apparatre
			;l'image. C'est en hexa car j'utilise un programme o je dessine l'image et il me renvoie le tableau de
			;de valeurs, mais en hexadcimal.

	.db $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	.db $80,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$01
	.db $80,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$01
	.db $BF,$DF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FB,$FD
	.db $B5,$50,$00,$00,$00,$00,$00,$00,$00,$00,$0A,$AD
	.db $AA,$D3,$83,$C4,$08,$00,$07,$83,$C3,$E3,$EB,$55
	.db $B5,$54,$44,$24,$08,$00,$08,$44,$24,$04,$0A,$AD
	.db $AA,$D4,$24,$24,$08,$0F,$08,$44,$24,$04,$0B,$55
	.db $B5,$54,$24,$24,$08,$10,$88,$44,$24,$04,$0A,$AD
	.db $BF,$D4,$24,$24,$08,$26,$48,$44,$24,$04,$0B,$FD
	.db $80,$54,$44,$24,$08,$49,$28,$44,$24,$04,$0A,$01
	.db $80,$53,$83,$C0,$00,$56,$A7,$83,$C0,$03,$CA,$01
	.db $80,$54,$44,$24,$08,$56,$AC,$04,$24,$04,$0A,$01
	.db $80,$54,$24,$24,$08,$49,$2A,$04,$24,$04,$0A,$01
	.db $80,$54,$24,$24,$08,$26,$49,$04,$24,$04,$0A,$01
	.db $80,$54,$24,$24,$08,$10,$88,$84,$24,$04,$0A,$01
	.db $80,$54,$44,$24,$08,$0F,$08,$44,$24,$04,$0A,$01
	.db $80,$53,$84,$23,$E7,$C0,$08,$44,$23,$E3,$EA,$01
	.db $80,$50,$00,$00,$00,$00,$00,$00,$00,$00,$0A,$01
	.db $80,$5F,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FA,$01
	.db $80,$40,$00,$00,$00,$00,$00,$00,$00,$00,$02,$01
	.db $80,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$01
	.db $80,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$01
	.db $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF


circuit:
	.db %00000000
	.db %00000000
	.db %00000000
	.db %00011000
	.db %00011000	;Checkpoint
	.db %00111100
	.db %00111100
	.db %00111100
	.db %00111100
	.db %00111100
	.db %00011000
	.db %00011000
	.db %00111000
	.db %00111000
	.db %00111000
	.db %00111000
	.db %00111000
	.db %00111000
	.db %00111000
	.db %00011100
	.db %00011100
	.db %00011100
	.db %00011100
	.db %00000000
	.db %00000000
	.db %00011100
	.db %00011100
	.db %00011100
	.db %00011100
	.db %00011100
	.db %00011100
	.db %00111000
	.db %01110000
	.db %01110000
	.db %01100000
	.db %01100000
	.db %01100000
	.db %00000000
	.db %01100000
	.db %01100000
	.db %01100000
	.db %01110000
	.db %00111000
	.db %00011100
	.db %00011100
	.db %00011100
	.db %00011100
	.db %00001000
	.db %00101010
	.db %00011100
	.db %00001000
	.db %00101010
	.db %00011100
	.db %00001000
	.db %00101010
	.db %00011100
	.db %00001000
	.db %00101010
	.db %00011100
	.db %00011100
	.db %00011100
	.db %00011100
	.db %00000000
	.db %00000000
	.db %00000000
	.db %00011100
	.db %00011100
	.db %00011100
	.db %00111100
	.db %00111000
	.db %00110000
	.db %00110000
	.db %00110000
	.db %00110000
	.db %00110000
	.db %00000000
	.db %00110000
	.db %00000000
	.db %00110000
	.db %00000000
	.db %00110000
	.db %00110000
	.db %01111000
	.db %01111000
	.db %00110000
	.db %00110000
	.db %00110000
	.db %00110000
	.db %01111000
	.db %01111000
	.db %00000000
	.db %00000000
	.db %00101100
	.db %00111010
	.db %00101110
	.db %00011100
	.db %00011010
	.db %00000110
	.db %00000110
	.db %00000110
	.db %00000110
	.db %00011100
	.db %00011100
	.db %00011000
	.db %00011000
	.db %00011000
	.db %00011000
	.db %00011000
	.db %00011000
	.db %00000000
	.db %00011000
	.db %00000000
	.db %00011000
	.db %00011000
	.db %00011000
	.db %00011000
	.db %00011100
	.db %00001110
	.db %00000110
	.db %00000010
	.db %00000010
	.db %00000010
	.db %00000010
	.db %00011110
	.db %00010000
	.db %00010000
	.db %00010000
	.db %00010000
	.db %00011000
	.db %00011000
	.db %00011000
	.db %00011000
	.db %00111100	;Checkpoint
	.db %01100110
	.db %00111100
	.db %01100110
	.db %00111100
	.db %00011000
	.db %00111100
	.db %00011000
	.db %01111110
	.db %00111100
	.db %00011000
	.db %01111110
	.db %00111100
	.db %00011000
	.db %00111100
	.db %00011000
	.db %00011000
	.db %00011000
	.db %00011000
	.db %00011100
	.db %00011100
	.db %00001100
	.db %00101100
	.db %00001100
	.db %00101100
	.db %00011000
	.db %01011010
	.db %00011000
	.db %01111110
	.db %00011000
	.db %01011010
	.db %00011000
	.db %01011010
	.db %00011000
	.db %00011000
	.db %00011100
	.db %00011100
	.db %00011110
	.db %00001110
	.db %00001110
	.db %00001110
	.db %01010110
	.db %01100110
	.db %01110110
	.db %00000110
	.db %01010110
	.db %01100110
	.db %01110110
	.db %00000110
	.db %00000110
	.db %01010110
	.db %01100110
	.db %01110110
	.db %00000110
	.db %00000000
	.db %01100000
	.db %01100000
	.db %01100000
	.db %01100000
	.db %01100000
	.db %01100000
	.db %01100000
	.db %01100000
	.db %01100000
	.db %00000000
	.db %00001100
	.db %00001100
	.db %00001100
	.db %00001100
	.db %00001100
	.db %00001100
	.db %00001100
	.db %00001100
	.db %00001100
	.db %00000000
	.db %01100000
	.db %01100000
	.db %01100000
	.db %01100000
	.db %01100000
	.db %01100000
	.db %01100000
	.db %00000000
	.db %00001100
	.db %00001100
	.db %00001100
	.db %00001100
	.db %00001100
	.db %00001100
	.db %00001100
	.db %00000000
	.db %00000000
	.db %01100000
	.db %01100000
	.db %01100000
	.db %01100000
	.db %01100000
	.db %00000000
	.db %00000000
	.db %00001100
	.db %00001100
	.db %00001100
	.db %00001100
	.db %00001100
	.db %00001100
	.db %00001100
	.db %00000000
	.db %00000000
	.db %00000000
	.db %00000000
	.db %00000000
	.db %00001100
	.db %00001100
	.db %00001100
	.db %00001100
	.db %00001100
	.db %01100000
	.db %01100000
	.db %01111000
	.db %00011110
	.db %00000110
	.db %00001110
	.db %00011100
	.db %00011000	
	.db %00011000	
	.db %00011000	
	.db %00011000
	.db %00011000	
	.db %00011000	;Checkpoint
	.db %00000000
	.db %01101110
	.db %00101010
	.db %00101110
	.db %00000000
	.db %01101110
	.db %00101010
	.db %00101110
	.db %00000000
	.db %00011000
	.db %00011000
	.db %00011000
	.db %00011000
	.db %00011000
	.db %00111100
	.db %01111110
	.db %00111100
	.db %00010000
	.db %00010000
	.db %00111000
	.db %01111100
	.db %00111000
	.db %00011000
	.db %00001100
	.db %00001100
	.db %00111000
	.db %01111100
	.db %00111000
	.db %00011000
	.db %00001100
	.db %00011000
	.db %00110000
	.db %00011000
	.db %00011000
	.db %00011000
	.db %00111100
	.db %00011000
	.db %00111100
	.db %00011000
	.db %00100100
	.db %00011000
	.db %00100100
	.db %00011000
	.db %00011000
	.db %00011000
	.db %00011000
	.db %00111000
	.db %00111000
	.db %00111000
	.db %00111000
	.db %01110000
	.db %01110000
	.db %01100000
	.db %01100000
	.db %01000000
	.db %01000000
	.db %00001100
	.db %00001100
	.db %00001100
	.db %00011100
	.db %00011000
	.db %00111000
	.db %00110000
	.db %00110000
	.db %01110000
	.db %01110000
	.db %01110000
	.db %01111000
	.db %00111100
	.db %00000000
	.db %00000000
	.db %00111100
	.db %00111100
	.db %01011010
	.db %00111100
	.db %00111100
	.db %01011010
	.db %00011000
	.db %00111100
	.db %00111100
	.db %00011000
	.db %00011000
	.db %00000000
	.db %00000000
	.db %00111100
	.db %00111100
	.db %00011000
	.db %00011100
	.db %00001110
	.db %00000110
	.db %00000110
	.db %00001110
	.db %00011100
	.db %00111000
	.db %01110000
	.db %01100000
	.db %01100000
	.db %01110000
	.db %00111000
	.db %00011100
	.db %00001110
	.db %00000110
	.db %00000110
	.db %00001110
	.db %00011100
	.db %00111000
	.db %01110000
	.db %01100000
	.db %01100000
	.db %01110000
	.db %00111000
	.db %00011100
	.db %00001110
	.db %00000110
	.db %00000110
	.db %00000110
	.db %00000110
	.db %00000110
	.db %00001110
	.db %00011100
	.db %00011000
	.db %00011000
	.db %00011000
	.db %00011000
	.db %00011000
	.db %00011000
	.db %00011000
	.db %00011000	;Checkpoint
	.db %00010000
	.db %00010000
	.db %00010000
	.db %00010000
	.db %00010000
	.db %00010000
	.db %01111100
	.db %00111000
	.db %00010000
	.db %00010000
	.db %00000000
	.db %00001000
	.db %01000000
	.db %00000010
	.db %00000000
	.db %00001000
	.db %01000000
	.db %00100000
	.db %00000100
	.db %00000000
	.db %00000000
	.db %00010000
	.db %00010000
	.db %00010000
	.db %00010000
	.db %00111000
	.db %00111000
	.db %00111000
	.db %00111000
	.db %00111000
	.db %00111000
	.db %00111000
	.db %01111100
	.db %01111100
	.db %01111100
	.db %01101100
	.db %01111100
	.db %01101100
	.db %01111100
	.db %01101100
	.db %01111100
	.db %01101100
	.db %01111100
	.db %00111000
	.db %00111000
	.db %00000000
	.db %00000000
	.db %00000000
	.db %00000000
	.db %01111100
	.db %00111000
	.db %00010000
	.db %00111000
	.db %01111100
	.db %00111000
	.db %00010000
	.db %00111000
	.db %01111100
	.db %00111000
	.db %00010000
	.db %00000000
	.db %00000000
	.db %00000000
	.db %00000000
	.db %00000000
	.db %00000000
	.db %00000000
	.db %00000000
	.db %00000000
	.db %01111100
	.db %00111000
	.db %00010000
	.db %00010000
	.db %00010000
	.db %00010000
	.db %00010000
	.db %00010000
	.db %00111000
	.db %00000000
	.db %00111000
	.db %00000000
	.db %00111000
	.db %00000000
	.db %00110000
	.db %00110000
	.db %00110000
	.db %00110000
	.db %00110000
	.db %00111000
	.db %00011000
	.db %00011100
	.db %00001100
	.db %00001110
	.db %00000110
	.db %00000110
	.db %00000110
	.db %00001110
	.db %00001100
	.db %00011100
	.db %00011000
	.db %00111000
	.db %00110000
	.db %01110000
	.db %01100000
	.db %01100000
	.db %01100000
	.db %01110000
	.db %00110000
	.db %00011100
	.db %00001100
	.db %00001110
	.db %00000110
	.db %00000110
	.db %00000110
	.db %01111110
	.db %01100000
	.db %01100000
	.db %01100000
	.db %01110000
	.db %00110000
	.db %00111000
	.db %00011000
	.db %00011100
	.db %00001100
	.db %00001110
	.db %00000110
	.db %00001110
	.db %00011100	;Checkpoint
	.db %00111100
	.db %01111100
	.db %01111100
	.db %01111000
	.db %01110000
	.db %01100000
	.db %01100000
	.db %01100000
	.db %01100000
	.db %01100000
	.db %01100000
	.db %01100000
	.db %01100000
	.db %01110000
	.db %01111000
	.db %01111100
	.db %01111110
	.db %00101010
	.db %01010100
	.db %00101010
	.db %01010100
	.db %00101010
	.db %01010100
	.db %00101010
	.db %01010100
	.db %00101010
	.db %01010100
	.db %00101010
	.db %01010100
	.db %00000110
	.db %00000110
	.db %00001110
	.db %00011100
	.db %00111100
	.db %00000000
	.db %00000000
	.db %00111100
	.db %00111100
	.db %00011000
	.db %00011000
	.db %00011000
	.db %00011000
	.db %00011000
	.db %00111000
	.db %00110000
	.db %00100000
	.db %00100000
	.db %00110000
	.db %00111000
	.db %00011100
	.db %00001110
	.db %00000110
	.db %00000110
	.db %00000010
	.db %00000010
	.db %00000010
	.db %00000010
	.db %00000010
	.db %00000010
	.db %00000110
	.db %00001110
	.db %00011100
	.db %00111000
	.db %01110000
	.db %01100000
	.db %01000000
	.db %01000000
	.db %01000000
	.db %01000000
	.db %00000000
	.db %00001100
	.db %00001100
	.db %00001100
	.db %00011110
	.db %00011110
	.db %00011110
	.db %00011110
	.db %00011100
	.db %00011000
	.db %00010000
	.db %00010000
	.db %01010100
	.db %00010000
	.db %01010100
	.db %00010000
	.db %00010000
	.db %00010000
	.db %01010100
	.db %00010000
	.db %01010100
	.db %00010000
	.db %00010000
	.db %00010000
	.db %00010000
	.db %00010000
	.db %00010000
	.db %00010000
	.db %00111000
	.db %00111000
	.db %00111000
	.db %00111000
	.db %00111100
	.db %00111100
	.db %00111110
	.db %00111110
	.db %00111110
	.db %00111110
	.db %00111110
	.db %00110110
	.db %00110110
	.db %00110110
	.db %00110110
	.db %00110110
	.db %00010100
	.db %00010100
	.db %00010100
	.db %00010100
	.db %00010100
	.db %00110100
	.db %01110100
	.db %01100100
	.db %01000100
	.db %01000100
	.db %01000100
	.db %01000100
	.db %01111110
	.db %01111110
	.db %01111110	;Checkpoint
	.db %01000010
	.db %01000010
	.db %01000010
	.db %01111110
	.db %01111110
	.db %01011010
	.db %00000010
	.db %00000010
	.db %00000010
	.db %00000010
	.db %00000010
	.db %00000010
	.db %00000110
	.db %00001110
	.db %00011110
	.db %00011100
	.db %00011000
	.db %00011000
	.db %00010000
	.db %00010000
	.db %00010000
	.db %01111100
	.db %00111000
	.db %00010000
	.db %00010000
	.db %00010000
	.db %00010000
	.db %01111100
	.db %00111000
	.db %00010000
	.db %00010000
	.db %00010000
	.db %00010000
	.db %00000000
	.db %00000000
	.db %00001000
	.db %01000000
	.db %00000010
	.db %00000000
	.db %00001000
	.db %01000000
	.db %00100000
	.db %00000100
	.db %00000000
	.db %00000000
	.db %00010000
	.db %00010000
	.db %00000000
	.db %00000000
	.db %00001000
	.db %01000000
	.db %00000010
	.db %00000000
	.db %00001000
	.db %01000000
	.db %00100000
	.db %00000100
	.db %00000000
	.db %00000000
	.db %00010000
	.db %00010000
	.db %00000000
	.db %00000000
	.db %00001000
	.db %01000000
	.db %00000010
	.db %00000000
	.db %00001000
	.db %01000000
	.db %00100000
	.db %00000100
	.db %00000000
	.db %00000000
	.db %01111110
	.db %01111110
	.db %00111100
	.db %00111100
	.db %00011000
	.db %00011000
	.db %00011000
	.db %00011000
	.db %00111100
	.db %00000000
	.db %00111100
	.db %00000000
	.db %00111100
	.db %00011000
	.db %00011000
	.db %00011000
	.db %00011000
	.db %00111100
	.db %00111100
	.db %00111100
	.db %00100100
	.db %00111100
	.db %00111100
	.db %00111100
	.db %00111100
	.db %00000000
	.db %00000000
	.db %00111100
	.db %00100100
	.db %00101100
	.db %00100000
	.db %00111100
	.db %00000000
	.db %00111100
	.db %00100100
	.db %00100100
	.db %00100100
	.db %00111100
	.db %00000000
	.db %01111110
	.db %01011010
	.db %01111110
	.db %01111110
	.db %01011010
	.db %01111110
	.db %01111110
	.db %01011010
	.db %01111110
	.db %01111110
	.db %01011010
	.db %01111110
	.db %01111110
	.db %00111100
	.db %00111100
	.db %01111110	;Checkpoint
	.db %00111100
	.db %00111100
	.db %01111110
	.db %00111100
	.db %00111100
	.db %01111110
	.db %00111100
	.db %00111100
	.db %01111110
	.db %00011000
	.db %00011000
	.db %00111100
	.db %00011000
	.db %00011000
	.db %00111100
	.db %00011000
	.db %00011000
	.db %00111100
	.db %00011000
	.db %00011000
	.db %00111100
	.db %00011000
	.db %00011000
	.db %00010000
	.db %00010000
	.db %00010000
	.db %00010000
	.db %00010000
	.db %00010000
	.db %01111100
	.db %01111100
	.db %00111000
	.db %00111000
	.db %00010000
	.db %00010000
	.db %00000000
	.db %01000000
	.db %00000100
	.db %00100000
	.db %00000010
	.db %01000000
	.db %00000000
	.db %00100100
	.db %00000000
	.db %00000010
	.db %01000000
	.db %00001000
	.db %00000000
	.db %00010000
	.db %00010010
	.db %00010100
	.db %01010000
	.db %00010000
	.db %00000000
	.db %00000000
	.db %01000000
	.db %00000000
	.db %00000000
	.db %00000010
	.db %00100000
	.db %00000000
	.db %00000100
	.db %00000000
	.db %01000000
	.db %00010000
	.db %00111000
	.db %01111100
	.db %00111000
	.db %00010000
	.db %00010000
	.db %00010000
	.db %00010000
	.db %00010000
	.db %00010000
	.db %00010000
	.db %00110000
	.db %01100000
	.db %01000000
	.db %01100000
	.db %00110000
	.db %00011000
	.db %00001100
	.db %00000110
	.db %00000010
	.db %00000110
	.db %00001100
	.db %00011000
	.db %00110000
	.db %01100000
	.db %01000000
	.db %01000000
	.db %01000000
	.db %01000000
	.db %01000000
	.db %01100000
	.db %01100000
	.db %01100000
	.db %01100000
	.db %00000000
	.db %00000000
	.db %00001100
	.db %00001100
	.db %00001100
	.db %00001100
	.db %00001100
	.db %00001100
	.db %00001100
	.db %00001100
	.db %00001100
	.db %00011100
	.db %00011100
	.db %00111000
	.db %00111000
	.db %01110000
	.db %01110000
	.db %01100000
	.db %01100000
	.db %01100000
	.db %01100000
	.db %00000000
	.db %00000000
	.db %00001100
	.db %00001100
	.db %00001100
	.db %00001100
	.db %00011100
	.db %00011100
	.db %00111000	;Checkpoint
	.db %00111000
	.db %01110000
	.db %01110000
	.db %01100000
	.db %01100000
	.db %01110000
	.db %01110000
	.db %00000000
	.db %00000000
	.db %00000110
	.db %00000110
	.db %00000110
	.db %00001110
	.db %00011100
	.db %00011100
	.db %00111000
	.db %00111000
	.db %01110000
	.db %01110000
	.db %01100000
	.db %01100000
	.db %01100000
	.db %01100000
	.db %00000000
	.db %00000000
	.db %00000000
	.db %00111100
	.db %00111100
	.db %00011000
	.db %00011000
	.db %00011000
	.db %00011000
	.db %00011000
	.db %00011000
	.db %00011000
	.db %00011000
	.db %00011000
	.db %00011000
	.db %00011000
	.db %00010000
	.db %00010000
	.db %00010000
	.db %00010000
	.db %00010000
	.db %00010000
	.db %00011000
	.db %00011000
	.db %00011000
	.db %00001000
	.db %00001000
	.db %00001000
	.db %00001000
	.db %00001000
	.db %00001000
	.db %00001000
	.db %00001000
	.db %00001000
	.db %00001000
	.db %00011000
	.db %00011000
	.db %00011000
	.db %00010000
	.db %00010000
	.db %00010000
	.db %00010000
	.db %00010000
	.db %00010000
	.db %00010000
	.db %00010000
	.db %00010000
	.db %00110000
	.db %00110000
	.db %00110000
	.db %00100000
	.db %00100000
	.db %00100000
	.db %00100000
	.db %00100000
	.db %00100000
	.db %00100000
	.db %01100000
	.db %01100000
	.db %01100000
	.db %01000000
	.db %01000000
	.db %01000000
	.db %01000000
	.db %01000000
	.db %01000000
	.db %01000000
	.db %01000000
	.db %01000000
	.db %01100000
	.db %01100000
	.db %01100000
	.db %00100000
	.db %00100000
	.db %00100000
	.db %00100000
	.db %00100000
	.db %00100000
	.db %00100000
	.db %00100000
	.db %00100000
	.db %00110000
	.db %00110000
	.db %00110000
	.db %00010000
	.db %00010000
	.db %00010000
	.db %00010000
	.db %00010000
	.db %00010000
	.db %00010000
	.db %00010000
	.db %00010000
	.db %00011000
	.db %00011000
	.db %00011000
	.db %00010000
	.db %00010000
	.db %00010000
	.db %00010000
	.db %00000000
	.db %00000000
	.db %00010000
	.db %00111000
	.db %01111110	;Checkpoint
	.db %01111110
	.db %00111100
	.db %00111100
	.db %00111100
	.db %00111100
	.db %00111000
	.db %00111000
	.db %00111000
	.db %00111000
	.db %00111000
	.db %00111000
	.db %00111000
	.db %00011000
	.db %00011000
	.db %00011000
	.db %00011000
	.db %00011000
	.db %00000000
	.db %00011000
	.db %00011000
	.db %00011000
	.db %00010000
	.db %00010000
	.db %00010000
	.db %00010000
	.db %00010000
	.db %00010000
	.db %00010000
	.db %00010000
	.db %00010000
	.db %00010010
	.db %00010000
	.db %00000000
	.db %00010000
	.db %00010000
	.db %00010000
	.db %00010000
	.db %01010000
	.db %00010010
	.db %00010000
	.db %00010000
	.db %00110000
	.db %00010000
	.db %00010000
	.db %00010000
	.db %00010000
	.db %00010010
	.db %00010000
	.db %01010000
	.db %00010000
	.db %00110000
	.db %00010000
	.db %00010000
	.db %00010000
	.db %00010010
	.db %01001000
	.db %00010000
	.db %00010000
	.db %00010100
	.db %00010000
	.db %01010010
	.db %00011000
	.db %00010000
	.db %01010000
	.db %00010010
	.db %00010000
	.db %01011000
	.db %00010000
	.db %01010010
	.db %00010000
	.db %00110010
	.db %00000000
	.db %00011000
	.db %01010010
	.db %00010000
	.db %00010010
	.db %01010100
	.db %00010000
	.db %00110000
	.db %00010010
	.db %01010000
	.db %00011000
	.db %00010000
	.db %00010000
	.db %00010000
	.db %00010000
	.db %00000000
	.db %01100000
	.db %00110110
	.db %00011110
	.db %00001110
	.db %00111110
	.db %00000000
	.db %01000010
	.db %00001010
	.db %00010010
	.db %00000010
	.db %01001010
	.db %00000010
	.db %00010000
	.db %00010000
	.db %00010010
	.db %01010000
	.db %00010000
	.db %00010010
	.db %01010000
	.db %00010100
	.db %00010000
	.db %00000000
	.db %00010000
	.db %00010000
	.db %00010000
	.db %00010000
	.db %00010000
	.db %00000000
	.db %00010000
	.db %00010000
	.db %00010000
	.db %00000000
	.db %00010000
	.db %00010000
	.db %00010000
	.db %00000000
	.db %00010000
	.db %00010000
	.db %00010000
	.db %00111000
	.db %01111100	;Checkpoint
	.db %01111100
	.db %01111100
	.db %00111000
	.db %00111000
	.db %00010000
	.db %00010000
	.db %00010000
	.db %00010000
	.db %00011000
	.db %00011000
	.db %00011000
	.db %00011100
	.db %00001100
	.db %00001110
	.db %00000110
	.db %00000110
	.db %00000110
	.db %00001110
	.db %00001100
	.db %00011100
	.db %00011000
	.db %00011000
	.db %00011000
	.db %00011000
	.db %00011000
	.db %00000000
	.db %00001100
	.db %01101100
	.db %01100000
	.db %00000110
	.db %00000110
	.db %00110000
	.db %00110000
	.db %00001100
	.db %00001100
	.db %01100000
	.db %01100110
	.db %00000110
	.db %00011000
	.db %00011000
	.db %00000000
	.db %00000000
	.db %01100000
	.db %01100000
	.db %00000000
	.db %01000110
	.db %01100010
	.db %00000000
	.db %00010000
	.db %00011000
	.db %00000000
	.db %00000000
	.db %00000000
	.db %01111110
	.db %01111110
	.db %00000000
	.db %00000000
	.db %01111110
	.db %00011000
	.db %00100100
	.db %01111110
	.db %00000000
	.db %00000000
	.db %01111110
	.db %01111110
	.db %00111100
	.db %00111100
	.db %00011000
	.db %00011000
	.db %00000000
	.db %00000000
	.db %00000000
	.db %00000000
	.db %00100100
	.db %00100100
	.db %01111110
	.db %01111110
	.db %01111110
	.db %01111110
	.db %01111110
	.db %01111110
	.db %01111110
	.db %00111100
	.db %00111100
	.db %00111100
	.db %00111100
	.db %00111100
	.db %00111100
	.db %00111100
	.db %00111100
	.db %00011000
	.db %00011000
	.db %00011000
	.db %00011000
	.db %01011000
	.db %00000010
	.db %00100000
	.db %00000010
	.db %01000000
	.db %00000100
	.db %01000010
	.db %00000000
	.db %01111110
	.db %01011010
	.db %01111110
	.db %01011010
	.db %01111110
	.db %00000000
	.db %00111100
	.db %00100000
	.db %00111000
	.db %00100000
	.db %00111100
	.db %00000000
	.db %00100100
	.db %00101100
	.db %00101100
	.db %00110100
	.db %00110100
	.db %00100100
	.db %00000000
	.db %00111000
	.db %00100100
	.db %00100100
	.db %00100100
	.db %00111000
	.db %00000000
	.db %00000000	;Fin du circuit (5*256=1280 octets)
	.db %00000000
	.db %00000000
	.db %00000000
	.db %00000000
	.db %00000000
	.db %00000000
	.db %00000000
	.db %00000000
	.db %00000000
	.db %00000000
	.db %00000000
	.db %00000000


#include "Multikey.inc"

	.end
