;************************************************************
;
; Elements v1.0
; =============
; for Ion on the TI-83/TI-83+
;
; by badja
; 31 October 1999
;
; http://move.to/badja
; badja@alphalink.com.au
;
; You may modify this source code for personal use only.
; You may NOT distribute the modified source or program file.
;
; Original game created by Avery Pack
;
; Levels are compressed using run-length encoding
; Average level size under 93 bytes; 207% overall compression
;
;************************************************************
; Sorry, no comments :(

#include "crash82.inc"




;******** APD_BUF offsets ********
xPos		.equ	0
yPos		.equ	xPos+1
xDest		.equ	yPos+1
yDest		.equ	xDest+1
level		.equ	yDest+1
board		.equ	level+1
score		.equ	board+1
keys		.equ	score+2
energy	.equ	keys+1
lives		.equ	energy+1
shift		.equ	lives+1
levelArray	.equ	shift+1


;******** Program ********
	.org START_ADDR
	.db	"Elements 1.0",0

start:
 set 7,(iy+$14)
 call gg
 res 7,(iy+$14)
 ret
gg
	ld	ix,APD_BUF		; initialise IX so we can use our offsets
	ld	(ix+level),0

mainMenu:
	ld	(ix+score),0
	ld	(ix+score+1),0
	ld	(ix+lives),3
	ld	(ix+shift),0
showMenu:
	call _grbufclr

	ld	ix,titlePic
	ld	a,16
	ld	l,0
	ld	bc,$0a08
	call	ionLargeSprite
	ld	ix,APD_BUF

	ld	hl,menuURL
	ld	bc,$0a0b
	call	putString

	ld	bc,$1217
	call	putString

	ld	bc,$1800
	call	putString
	ld	a,(ix+level)
	inc	a
	call _setxxop1
	ld	a,1
	call _dispop1a
	ld	ix,APD_BUF

	ld	hl,menuExit
	ld	bc,$1e0f
	call	putString

	ld	bc,$2417
	call	putString

	ld	bc,$2a29
	call	putString

	ld	bc,$3214
	call	putString
	ld	hl,(highScore)
	call _setxxxxop2
	call _op2toop1
	ld	a,5
	call _dispop1a
	ld	ix,APD_BUF

	ROM_CALL(DISP_GRAPH)
	ld	b,$50
	call	bigDelay

menuLoop:
	call	resetKeyport
	ld	a,$fe
	out	(1),a
	in	a,(1)
	cp	253			; left
	jr	z,prevLevel
	cp	251			; right
	jr	z,nextLevel
	call	resetKeyport
	ld	a,$fd
	out	(1),a
	in	a,(1)
	cp	191			; CLEAR
	ret	z
	call	resetKeyport
	ld	a,$bf
	out	(1),a
	in	a,(1)
	cp	223			; 2nd
	jr	z,startLevel
	cp	127			; DEL
	jr	z,delHighScore
	jp	menuLoop

nextLevel:
	ld	a,(highLevel)
	cp	(ix+level)
	jr	z,menuLoop
	inc	(ix+level)
	jp	showMenu

prevLevel:
	ld	a,0
	cp	(ix+level)
	jr	z,menuLoop
	dec	(ix+level)
	jp	showMenu

delHighScore:
	ld	hl,confirmDelete
	ld	bc,$3900
	ld	(ix+shift),1
	call	putMessage
	bit	0,(ix+shift)
	jp	nz,showMenu
	ld	(ix+shift),0
	ld	hl,0
	ld	(highScore),hl
	ld	a,0
	ld	(highLevel),a
	ld	(ix+level),a
	jp	showMenu

startLevel:
	ld	(ix+board),0
	ld	(ix+keys),0
	ld	(ix+energy),25
	bit	0,(ix+shift)
	jr	nz,noAddPoints
	call	add25points
	call	add25points
noAddPoints:
	ld	(ix+shift),0

startBoard:
	ld	a,(ix+level)
	ld	hl,levels
	ld	ix,boardLengths
	ld	de,screenLengths
	cp	0
	jr	z,level0
	ld	b,a
loadLoop1:
	push	bc
	ld	b,(ix)
	inc	ix
	call	skipScreen
	pop	bc
	djnz	loadLoop1
level0:

	ld	a,(APD_BUF+board)
	cp	0
	jr	z,board0
	ld	b,a
	call	skipScreen
board0:

	call	getNextByte
	ld	(APD_BUF+xPos),a
	ld	(APD_BUF+xDest),a
	call	getNextByte
	ld	(APD_BUF+yPos),a
	ld	(APD_BUF+yDest),a
	ld	ix,APD_BUF+levelArray
	ld	a,(de)
	ld	b,a
decompressLoop:
	push	bc
	call	getNextByte
	ld	c,a
	and	%00000111
	inc	a
	ld	b,a
	srl	c
	srl	c
	srl	c
writeRun:
	ld	(ix),c
	inc	ix
	djnz	writeRun
	pop	bc
	djnz	decompressLoop

displayBoard:
	call _grbufclr
	ld	e,0
	ld	hl,APD_BUF+levelArray
	ld	b,10

dispLoop1:
	push	bc
	ld	b,19
	ld	d,0

dispLoop2:
	push	bc

	ld	a,(hl)
	inc	hl
	ld	b,a
	push	de
	push	hl
	call	putBlock
	pop	hl
	pop	de
	inc	d
	pop	bc
	djnz	dispLoop2

	inc	e
	pop	bc
	djnz	dispLoop1

	ld	hl,status
	ld	bc,$3200
	call	putString

	ld	bc,$321b
	call	putString

	call	dispScore

	ld	hl,nrg
	ld	bc,$3900
	call	putString

	ld	bc,$393e
	call	putString

	ld	a,(ix+level)
	inc	a
	call _setxxop1
	ld	a,1
	call _dispop1a
	ld	ix,APD_BUF

	ld	hl,dash
	ld	bc,$3957
	call	putString

	ld	a,(ix+board)
	inc	a
	call _setxxop1
	ld	a,1
	call _dispop1a
	ld	ix,APD_BUF

	ld	(ix+shift),1
	bit	0,(ix+keys)
	jr	z,noLightKey
	ld	b,14
	ld	d,3
	ld	e,10
	call	putBlock
noLightKey:
	bit	1,(ix+keys)
	jr	z,noDarkKey
	ld	b,13
	ld	d,4
	ld	e,10
	call	putBlock
noDarkKey:

	ld	a,(ix+lives)
	cp	0
	jr	z,noLives
	cp	6
	jr	c,notTooMany
	ld	a,5
notTooMany:
	ld	d,18
	ld	e,10
	ld	b,a
livesLoop:
	push	bc
	ld	b,25
	push	de
	call	putBlock
	pop	de
	dec	d
	pop	bc
	djnz	livesLoop
noLives:
	ld	(ix+shift),0

	ld	a,(ix+energy)
	cp	0
	jr	z,doneEnergy
	cp	36
	jr	c,oneEnergyBar
	ld	hl,GRAPH_MEM+711
	ld	b,35
	call	horizLine
	ld	hl,GRAPH_MEM+723
	ld	b,35
	call	horizLine
	ld	hl,GRAPH_MEM+747
	ld	a,(ix+energy)
	sub	35
	cp	36
	jr	c,notTooLong
	ld	a,35
notTooLong:
	ld	b,a
	push	bc
	call	horizLine
	pop	bc
	ld	hl,GRAPH_MEM+759
	call	horizLine
	jr	doneEnergy

oneEnergyBar:
	ld	b,(ix+energy)
	ld	hl,GRAPH_MEM+711
	call	horizLine
	ld	b,(ix+energy)
	ld	hl,GRAPH_MEM+723
	call	horizLine
doneEnergy:

	call	putPlayer

	ld	hl,outOfEnergy
	ld	a,(ix+energy)
	cp	0
	jp	z,die
	cp	253
	jp	nc,die

	ROM_CALL(DISP_GRAPH)
	call	delay

gameLoop:
	call	resetKeyport
	ld	a,$fe
	out	(1),a
	in	a,(1)
doubleMove:
	cp	254			; down
	jr	z,down
	cp	253			; left
	jr	z,left
	cp	251			; right
	jr	z,right
	cp	247			; up
	jr	z,up
	call	resetKeyport
	ld	a,$fd
	out	(1),a
	in	a,(1)
	cp	191			; CLEAR
	jp	z,endGame
	call	resetKeyport
	ld	a,$bf
	out	(1),a
	in	a,(1)
	ld	hl,suicide
	cp	127			; DEL
	jp	z,die
	jr	gameLoop

down:
	inc	(ix+yDest)
	jr	checkDest
left:
	ld	a,(ix+xPos)
	cp	0
	jr	z,gameLoop
	dec	(ix+xDest)
	jr	checkDest
right:
	ld	a,(ix+xPos)
	cp	18
	jr	nz,notNextBoard
	inc	(ix+board)
	jp	startBoard
notNextBoard:
	inc	(ix+xDest)
	jr	checkDest
up:
	dec	(ix+yDest)

checkDest:
	call	getElementAddress
	ld	c,(hl)
	ld	hl,destCases
	sla	c
	ld	b,0
	add	hl,bc
	ld	e,(hl)
	inc	hl
	ld	d,(hl)
	ex	de,hl
	jp	(hl)

dNothing:
	inc	(ix+board)
	jp	startBoard

dWall:
	ld	a,(ix+xPos)
	ld	(ix+xDest),a
	ld	a,(ix+yPos)
	ld	(ix+yDest),a
	jp 	displayBoard

dExit:
	dec	(ix+energy)
	ld	a,(ix+energy)
	cp	0
	jr	z,noBonus
	ld	b,a
addBonus:
	call	add25points
	djnz	addBonus
noBonus:
	call	putPlayer
	ld	bc,$3232
	ld	(CURSOR_X),bc
	call	dispScore
	ld	hl,boardComplete
	ld	a,(ix+level)
	cp	6
	jr	nz,endBoardMessage
	ld	hl,gameComplete
endBoardMessage:
	ld	bc,$3900
	call	putMessage

	ld	a,(ix+level)
	cp	6
	jp	z,endGame

	inc	(ix+level)
	ld	a,(highLevel)
	cp	(ix+level)
	jr	nc,sameHighLevel
	inc	a
	ld	(highLevel),a
sameHighLevel:
	ld	(ix+board),0
	jp 	startLevel

dFloor:
	ld	a,(ix+xDest)
	ld	(ix+xPos),a
	ld	a,(ix+yDest)
	ld	(ix+yPos),a
	dec	(ix+energy)
	jp	displayBoard

dLeft:
	ld	a,(ix+xPos)
	cp	(ix+xDest)
	jp	z,dWall
	jp	c,dWall
	jr	followArrow

dRight:
	ld	a,(ix+xPos)
	cp	(ix+xDest)
	jp	nc,dWall
	jr	followArrow

dUp:
	ld	a,(ix+yPos)
	cp	(ix+yDest)
	jp	z,dWall
	jp	c,dWall
	jr	followArrow

dDown:
	ld	a,(ix+yPos)
	cp	(ix+yDest)
	jp	nc,dWall
followArrow:
	dec	(ix+energy)
	jp	doubleMove

dShard:
	ld	d,2
	call	writeArray
	call	add25points
	call	add25points
	jr	dFloor

dEnergy:
	ld	d,2
	call	writeArray
	ld	a,(ix+energy)
	add	a,26
	ld	(ix+energy),a
	jr	dFloor

d1up:
	ld	d,2
	call	writeArray
	inc	(ix+lives)
	jp	dFloor

dKeyDark:
	set	1,(ix+keys)
	ld	d,2
	call	writeArray
	jp	dFloor

dKeyLight:
	set	0,(ix+keys)
	ld	d,2
	call	writeArray
	jp	dFloor

dLockDark:
	bit	1,(ix+keys)
	jp 	z,dWall
	ld	d,2
	call	writeArray
	ld	a,17
	ld	c,2
	call	replace
	res	1,(ix+keys)
	jp	dFloor

dLockLight:
	bit	0,(ix+keys)
	jp 	z,dWall
	ld	d,2
	call	writeArray
	ld	a,18
	ld	c,2
	call	replace
	res	0,(ix+keys)
	jp	dFloor

dSwitchLeft:
	ld	d,20
	jr	switchArrows

dSwitchRight:
	ld	d,19
switchArrows:
	call	writeArray
	dec	(ix+energy)
	ld	a,6
	ld	c,25
	call	replace
	ld	a,7
	ld	c,6
	call	replace
	ld	a,25
	ld	c,7
	call	replace
	ld	a,8
	ld	c,25
	call	replace
	ld	a,9
	ld	c,8
	call	replace
	ld	a,25
	ld	c,9
	call	replace
	jp 	dWall

dRound:
	dec	(ix+energy)
	ld	a,17
	ld	c,25
	call	replace
	ld	a,18
	ld	c,17
	call	replace
	ld	a,25
	ld	c,18
	call	replace
	jp 	dWall

dSquare:
	dec	(ix+energy)
	ld	a,24
	ld	c,2
	call	replace
	jp 	gameLoop

dHole:
	ld	a,(ix+level)
	cp	6
	jr	nz,fallInHole
	ld	a,(ix+board)
	cp	4
	jr	c,fallInHole
	ld	hl,teleporters
	sub	4
	sla	a
	sla	a
	sla	a
	ld	b,0
	ld	c,a
	add	hl,bc

	ld	b,2
checkTeleporters:
	call	getNextByte
	cp	(ix+xDest)
	jr	nz,checkOther2
	call	getNextByte
	cp	(ix+yDest)
	jr	nz,checkOther1
	call	getNextByte
	ld	(ix+xDest),a
	call	getNextByte
	ld	(ix+yDest),a
	dec	(ix+energy)
	dec	(ix+energy)
	jp	dFloor
checkOther1:
	inc	hl
checkOther2:
	inc	hl
	inc	hl
	inc	hl
	djnz	checkTeleporters

fallInHole:
	call	putPlayer
	ld	hl,youHaveDied
die:
	ld	bc,$3906
	call	putMessage

	ld	hl,GRAPH_MEM
	ld	de,GRAPH_MEM+(12*62)
	ld	b,31
blindLoop:
	push	bc
	ld	a,%00000000
	call	drawRow
	push	hl
	ld	a,%11111111
	call	drawRow
	pop	hl
	ex	de,hl
	push	hl
	ld	a,%11111111
	call	drawRow
	ld	a,%00000000
	call	drawRow
	pop	hl
	ld	bc,12
	scf
	ccf
	sbc	hl,bc
	ex	de,hl
	push	de
	push	hl
	ROM_CALL(DISP_GRAPH)
	call	delay
	call	delay
	call	delay
	call	delay
	pop	hl
	pop	de
	pop	bc
	djnz	blindLoop
	call _grbufclr
	ROM_CALL(DISP_GRAPH)

	ld	a,(ix+lives)
	cp	0
	jr	z,endGame
	dec	(ix+lives)
	jp 	startLevel
endGame:
	ld	de,(highScore)
	ld	hl,(APD_BUF+score)
	call	hiscr
	jp	nz,mainMenu
	ld	(highScore),hl
	ld	hl,newHighScore
	ld	bc,$3902
	call	putMessage
	jp	mainMenu


getNextByte:
	ld	a,(hl)
	inc	hl
	ret


drawRow:
	ld	b,12
drawRowLoop:
	ld	(hl),a
	inc	hl
	djnz	drawRowLoop
	ret


replace:			; replace all A's with C's
	ld	hl,APD_BUF+levelArray
	ld	b,190
replaceLoop:
	cp	(hl)
	jr	nz,noMatch
	ld	(hl),c
noMatch:
	inc	hl
	djnz	replaceLoop
	ret


writeArray:
	call	getElementAddress
	ld	(hl),d
	ret


getElementAddress:
	ld	a,(ix+yDest)
	sla	a
	sla	a
	sla	a
	sla	a
	add	a,(ix+yDest)
	add	a,(ix+yDest)
	add	a,(ix+yDest)
	add	a,(ix+xDest)
	ld	b,0
	ld	c,a
	ld	hl,APD_BUF+levelArray
	add	hl,bc
	ret


putPlayer:
	ld	d,(ix+xPos)
	ld	e,(ix+yPos)
	push	ix
	ld	ix,player
	jr	drawSprite

putBlock:			; B = sprite type, D = x-pos, E= y-pos
	push	ix
	push	de
	ld	ix,sprites
	ld	a,b
	cp	0
	jr	z,gotSprite
	ld	de,5
getSprite:
	add	ix,de
	djnz	getSprite
gotSprite:
	pop	de
drawSprite:
	ld	a,e
	sla	a
	sla	a
	add	a,e
	ld	l,a
	ld	a,(APD_BUF+shift)
	cp	1
	jr	nz,noShift
	inc	l
noShift:
	ld	a,d
	sla	a
	sla	a
	add	a,d
	inc	a
	ld	b,5
	call	ionPutSprite
	pop	ix
	ret


add25points:
	ld	hl,(APD_BUF+score)
	ld	de,25
	add	hl,de
	ld	(APD_BUF+score),hl
	ret


dispScore:
	ld	hl,(APD_BUF+score)
	call _setxxxxop2 
	call _op2toop1
	ld	a,5
	call _dispop1a
	ld	ix,APD_BUF
	ret


putString:
	ld	(CURSOR_X),bc
	ROM_CALL(D_ZM_STR)	; bjump() crashed the 83+ here
	ret


horizLine:
	ld	c,%10000000
drawLine:			; draw a horizontal line
	ld	a,c		; C = initial bit pattern
	or	(hl)		; HL -> graph buffer byte containing start of line
	ld	(hl),a
	dec	b		; B = length of line
	ld	a,b
	cp	0
	ret	z
	srl	c
	jr	nc,drawLine
	inc	hl
	ld	c,%10000000
	ld	a,b
	srl	a
	srl	a
	srl	a
	jr	z,drawLine
lineLoop:
	ld	(hl),%11111111
	inc	hl
	dec	a
	jr	nz,lineLoop
	ld	a,b
	and	%00000111
	ret	z
	ld	b,a
	jr	drawLine


putMessage:
	push	bc
	push	hl
	ld	hl,GRAPH_MEM+(12*57)
	ld	a,%11111111
	ld	b,7
clearStatus:
	push	bc
	call	drawRow
	pop	bc
	djnz	clearStatus
	pop	hl
	pop	bc

	set	3,(iy+5)
	call	putString
	ld	hl,press2nd
	ROM_CALL(D_ZM_STR)
	res	3,(iy+5)
	ROM_CALL(DISP_GRAPH)
	ld	bc,$a0
	call	bigDelay
waitLoop:
	call	resetKeyport
	ld	a,$bf
	out	(1),a
	in	a,(1)
	cp	223			; 2nd
	ret	z
	bit	0,(ix+shift)
	jr	z,waitLoop
	call	resetKeyport
	ld	a,$ef
	out	(1),a
	in	a,(1)
	cp	254			; check if 0 is pressed
	jr	nz,waitLoop
	ld	(ix+shift),0
	ret


delay:
	ld	b,0
delayLoop:
	res	7,(ix+keys)
	djnz	delayLoop
	ret


bigDelay:
	push	bc
	call	delay
	pop	bc
	djnz	bigDelay
	ret


resetKeyport:
	ld	a,$ff			; reset keyport
	out	(1),a
	ret


skipScreen:
	push	bc
	ld	a,(de)
	inc	de
	inc	a
	inc	a
	ld	b,0
	ld	c,a
	add	hl,bc
	pop	bc
	djnz	skipScreen
	ret


;---------= High Score =---------
; Input: de=previous high score
;	hl=current score
; Output: hl=high score
;	z=1 (a=0) if new high score, z=0 (a=1) if not
; Registers destroyed: af, de, hl
hiscr:	push	hl
	xor	a
	sbc	hl,de
	pop	hl
	jr	z,nnhs
	jr	nc,nhs
nnhs:	ex	de,hl
	inc	a
	ret
nhs:	or	a
	ret

_setxxxxop2:
 ROM_CALL($35B4-$1a)
 ret
_setxxop1:
 ld l,a
 ld h,0
 call _setxxxxop2
_op2toop1:
 ROM_CALL($1A0F-$1A)
 ret

_dispop1a:
 ROM_CALL($2E46)
        .dw $6CA4
        .db $04

_grbufclr:
 ld hl,GRAPH_MEM
 ld (hl),0
 ld de,GRAPH_MEM+1
 ld bc,767
 ldir
 ret

ionPutSprite:
 ld c,1

ionLargeSprite:
 di
 ex af,af'
 ld a,c
 push	af
 ex af,af'
 ld e,l
 ld h,$00
 ld d,h
 add hl,de
 add hl,de
 add hl,hl
 add hl,hl
 ld e,a
 and $07
 ld c,a
 srl e
 srl e
 srl e
 add hl,de
 ld de,GRAPH_MEM
 add hl,de
sl0:
 push	hl
sl1:
 ld d,(ix)
 ld e,$00
 ld a,c
 or a
 jr z,sl3
sl2:
 srl d
 rr e
 dec a
 jr nz,sl2
sl3:
 ld a,(hl)
 xor d
 ld (hl),a
 inc hl
 ld a,(hl)
 xor e
 ld (hl),a
 inc ix
 ex af,af'
 dec a
 push af
 ex af,af'
 pop af
 jr nz,sl1
 pop hl
 pop af
 push af
 ex af,af'
 ld de,$0C
 add hl,de
 djnz sl0
 pop af
 ret
titlePic:
 .db %11111111,%01111000,%00000000,%00000000,%00000000,%00000000,%00000000,%00000000
 .db %10000001,%11001100,%00000000,%00000000,%00000000,%00000000,%01111000,%00000000
 .db %10011111,%11001101,%11110011,%11111110,%00111110,%01111110,%01001100,%11111100
 .db %10011111,%11001111,%00011010,%00000011,%01100011,%01000011,%01000111,%10000110
 .db %10000011,%01001110,%01001110,%01001001,%11001001,%11001001,%11001111,%00111110
 .db %10011111,%01001110,%00001110,%01001001,%11000001,%11001001,%11001111,%10001110
 .db %10011111,%01001110,%01111110,%01001001,%11001111,%11001001,%11001101,%11100110
 .db %10000001,%11001111,%00011110,%01001001,%11100011,%11001001,%11100111,%00001110
 .db %11111111,%11111101,%11111011,%11111111,%10111111,%01111111,%10111111,%11111110
 .db %01111111,%10111100,%11111001,%11111111,%10011111,%00111111,%10011110,%11111100


sprites:
	.db	%00000000
	.db	%00000000
	.db	%00000000
	.db	%00000000
	.db	%00000000

	.db	%00000000
	.db	%01010000
	.db	%00100000
	.db	%01010000
	.db	%00000000

	.db	%00000000
	.db	%00000000
	.db	%00000000
	.db	%00000000
	.db	%00000000

	.db	%11111000
	.db	%10101000
	.db	%11011000
	.db	%10101000
	.db	%11111000

	.db	%11111000
	.db	%11111000
	.db	%11111000
	.db	%11111000
	.db	%11111000

	.db	%11111000
	.db	%11011000
	.db	%10101000
	.db	%11011000
	.db	%11111000

	.db	%00000000
	.db	%00100000
	.db	%01111000
	.db	%00100000
	.db	%00000000

	.db	%00000000
	.db	%00100000
	.db	%11110000
	.db	%00100000
	.db	%00000000

	.db	%00000000
	.db	%00100000
	.db	%01110000
	.db	%00100000
	.db	%00100000

	.db	%00100000
	.db	%00100000
	.db	%01110000
	.db	%00100000
	.db	%00000000

	.db	%00000000
	.db	%01110000
	.db	%01010000
	.db	%01110000
	.db	%00000000

	.db	%00100000
	.db	%01010000
	.db	%01110000
	.db	%01010000
	.db	%00100000

	.db	%00100000
	.db	%01100000
	.db	%00100000
	.db	%00100000
	.db	%01110000

	.db	%00100000
	.db	%01100000
	.db	%00100000
	.db	%01110000
	.db	%00100000

	.db	%00100000
	.db	%01100000
	.db	%00100000
	.db	%01010000
	.db	%00100000

	.db	%00000000
	.db	%00100000
	.db	%01110000
	.db	%00100000
	.db	%01110000

	.db	%00000000
	.db	%00100000
	.db	%01010000
	.db	%00100000
	.db	%01110000

	.db	%01110000
	.db	%01110000
	.db	%01110000
	.db	%01110000
	.db	%01110000

	.db	%01010000
	.db	%01010000
	.db	%01010000
	.db	%01010000
	.db	%01010000

	.db	%00000000
	.db	%01110000
	.db	%10111000
	.db	%01110000
	.db	%00000000

	.db	%00000000
	.db	%01110000
	.db	%11101000
	.db	%01110000
	.db	%00000000

	.db	%01110000
	.db	%10001000
	.db	%10101000
	.db	%10001000
	.db	%01110000

	.db	%11111000
	.db	%01010000
	.db	%01110000
	.db	%01010000
	.db	%11111000

	.db	%11111000
	.db	%10001000
	.db	%10101000
	.db	%10001000
	.db	%11111000

	.db	%01110000
	.db	%11111000
	.db	%11111000
	.db	%11111000
	.db	%01110000

player:
	.db	%01110000
	.db	%10001000
	.db	%10001000
	.db	%10001000
	.db	%01110000


menuURL:
	.db	"http://move.to/badja",0
menuStart:
	.db	"2nd - Start",0
menuBoard:
	.db	"Left/Right - Board: ",0
menuExit:
	.db	"CLEAR - Exit",0
menuDelHi:
	.db	"DEL - Clear high score",0
	.db	"and saved board",0
menuHighScore:
	.db	"High score: ",0

status:
	.db	"Keys",0
	.db	"Score: ",0
nrg:	.db	"Energy",0
	.db	"Board ",0
dash:	.db	"-",0

boardComplete:
	.db	" Board complete",0

gameComplete:
	.db	"  Game complete",0

outOfEnergy:
	.db	"Out of energy",0

youHaveDied:
	.db	"You have died",0

suicide:
	.db	"          Suicide",0

newHighScore:
	.db	"New high score!",0

confirmDelete:
	.db	"Yes -- Press 0  No",0

press2nd:
	.db	" -- Press 2nd",0

destCases:
	.dw	dNothing, dExit, dFloor, dWall, dWall
	.dw	dWall, dLeft, dRight, dUp, dDown
	.dw	dShard, dEnergy, d1up, dKeyDark, dKeyLight
	.dw	dLockDark, dLockLight, dWall, dWall, dSwitchLeft
	.dw	dSwitchRight, dRound, dWall, dSquare, dHole

teleporters:
	.db	2,5,7,7, 5,7,0,5
	.db	3,1,17,8, 15,8,1,1
	.db	0,6,8,8, 6,8,2,6
	.db	6,2,19,8, 17,8,8,2

boardLengths:
	.db	4,7,7,6,5,9,8

screenLengths:
	.db	71, 81, 40, 88, 87, 81, 58, 78, 70, 79, 85, 69, 72, 55, 77, 64, 81, 64, 92, 79, 139, 94, 71
	.db	151, 115, 160, 83, 108, 99, 106, 67, 67, 109, 74, 141, 81, 72, 97, 117, 140, 76, 71, 105, 73, 154, 79

levels:
 .db	 0, 1
	.db	%00011111
	.db	%00011101
	.db	%00100000
	.db	%00011011
	.db	%00010011
	.db	%01010000
	.db	%00010111
	.db	%00010000
	.db	%10010000
	.db	%01011001
	.db	%01100000
	.db	%00011101
	.db	%00010000
	.db	%00011010
	.db	%00010000
	.db	%00011010
	.db	%01011000
	.db	%00100000
	.db	%01011001
	.db	%00011001
	.db	%00101000
	.db	%00011000
	.db	%00010000
	.db	%00110000
	.db	%00010001
	.db	%00011000
	.db	%01011000
	.db	%00010001
	.db	%00011000
	.db	%00101000
	.db	%00011101
	.db	%00101001
	.db	%00011000
	.db	%00010000
	.db	%00011111
	.db	%00101111
	.db	%00101000
	.db	%00011000
	.db	%00010000
	.db	%00011111
	.db	%00011010
	.db	%00100000
	.db	%00011011
	.db	%00101000
	.db	%00011000
	.db	%00010111
	.db	%00010011
	.db	%10010000
	.db	%00010011
	.db	%00011011
	.db	%01001000
	.db	%01000000
	.db	%00011010
	.db	%00010000
	.db	%00011010
	.db	%11000000
	.db	%00100000
	.db	%00010001
	.db	%00011010
	.db	%01110000
	.db	%00010011
	.db	%00011000
	.db	%10000000
	.db	%00010001
	.db	%00011000
	.db	%00101000
	.db	%00011101
	.db	%00101000
	.db	%00011111
	.db	%00011010
	.db	%00101111
 .db	 0, 1
	.db	%00011111
	.db	%00011111
	.db	%00011010
	.db	%00010001
	.db	%01011000
	.db	%00010111
	.db	%00010001
	.db	%10000000
	.db	%10010000
	.db	%00010001
	.db	%01101000
	.db	%00011100
	.db	%00101000
	.db	%00010000
	.db	%00011001
	.db	%00101000
	.db	%00010000
	.db	%00011010
	.db	%01011000
	.db	%00011000
	.db	%00010000
	.db	%01010000
	.db	%00011001
	.db	%01010000
	.db	%00010001
	.db	%00110000
	.db	%00010001
	.db	%00011000
	.db	%01011000
	.db	%00010001
	.db	%00011000
	.db	%00100000
	.db	%00011010
	.db	%01010001
	.db	%00011001
	.db	%01010000
	.db	%00010001
	.db	%00101000
	.db	%00010001
	.db	%00011100
	.db	%00100010
	.db	%00011000
	.db	%01010010
	.db	%00011000
	.db	%01010000
	.db	%00010001
	.db	%00101000
	.db	%00010001
	.db	%00011000
	.db	%00010010
	.db	%00011111
	.db	%00011000
	.db	%01010000
	.db	%00010001
	.db	%00110000
	.db	%00010111
	.db	%00010000
	.db	%01111000
	.db	%10001000
	.db	%00010011
	.db	%00011010
	.db	%00101000
	.db	%00010001
	.db	%00011001
	.db	%00101000
	.db	%00010000
	.db	%00011100
	.db	%01011001
	.db	%00011010
	.db	%01011000
	.db	%00010011
	.db	%00011000
	.db	%01110000
	.db	%00010001
	.db	%00011000
	.db	%00100010
	.db	%00011011
	.db	%00100000
	.db	%00011111
	.db	%00011010
	.db	%00100111
 .db	 0, 1
	.db	%00011111
	.db	%00011111
	.db	%00011010
	.db	%00010111
	.db	%00010111
	.db	%00010010
	.db	%00011001
	.db	%00010000
	.db	%00011000
	.db	%00101000
	.db	%00011110
	.db	%00010000
	.db	%00011000
	.db	%00100000
	.db	%00011011
	.db	%00000000
	.db	%00011000
	.db	%00010101
	.db	%01011000
	.db	%00010011
	.db	%00011000
	.db	%00000101
	.db	%00011010
	.db	%00101000
	.db	%00011100
	.db	%00101000
	.db	%00011010
	.db	%00000111
	.db	%00000111
	.db	%00000111
	.db	%00000111
	.db	%00000111
	.db	%00000111
	.db	%00000111
	.db	%00000111
	.db	%00000111
	.db	%00000111
	.db	%00000111
	.db	%00000111
	.db	%00000011
 .db	 0, 1
	.db	%00011111
	.db	%00011011
	.db	%00101001
	.db	%00011011
	.db	%00100000
	.db	%00010001
	.db	%01010000
	.db	%00010000
	.db	%01010000
	.db	%00010000
	.db	%01010000
	.db	%00010000
	.db	%01010000
	.db	%00010000
	.db	%01010000
	.db	%00010000
	.db	%10001000
	.db	%01010000
	.db	%00010000
	.db	%01010000
	.db	%00010000
	.db	%01010000
	.db	%00001000
	.db	%00011000
	.db	%00010000
	.db	%00011010
	.db	%00101000
	.db	%00011011
	.db	%00010000
	.db	%00011100
	.db	%00100000
	.db	%00011010
	.db	%00010000
	.db	%00011001
	.db	%00101000
	.db	%00011000
	.db	%00101000
	.db	%00011010
	.db	%00010000
	.db	%00011001
	.db	%00010011
	.db	%00011000
	.db	%00000000
	.db	%00011000
	.db	%00010111
	.db	%00010001
	.db	%01101000
	.db	%00011000
	.db	%00010000
	.db	%00011001
	.db	%00010000
	.db	%00011000
	.db	%00000000
	.db	%00011001
	.db	%11000000
	.db	%00011110
	.db	%00010000
	.db	%00011001
	.db	%00010000
	.db	%00011000
	.db	%01111000
	.db	%00010000
	.db	%00011000
	.db	%00000000
	.db	%00011001
	.db	%01010000
	.db	%00011000
	.db	%00100000
	.db	%00011000
	.db	%00000010
	.db	%00101000
	.db	%00010011
	.db	%00011000
	.db	%00101000
	.db	%00011001
	.db	%00000000
	.db	%00011100
	.db	%00000011
	.db	%00100000
	.db	%00011010
	.db	%00101000
	.db	%00011000
	.db	%00000111
	.db	%00000111
	.db	%00000111
	.db	%00000111
	.db	%00000111
	.db	%00000001
 .db	 0, 1
	.db	%00011111
	.db	%00011111
	.db	%00011001
	.db	%00000000
	.db	%00010110
	.db	%00011000
	.db	%01101000
	.db	%00011000
	.db	%01011000
	.db	%00010010
	.db	%01110000
	.db	%00011000
	.db	%00010001
	.db	%00000000
	.db	%00010110
	.db	%00011000
	.db	%00010000
	.db	%00111000
	.db	%00010011
	.db	%01010000
	.db	%00011000
	.db	%00010000
	.db	%00011000
	.db	%00000000
	.db	%00010001
	.db	%00011001
	.db	%01000000
	.db	%00011001
	.db	%00010001
	.db	%00011010
	.db	%01000000
	.db	%00011010
	.db	%00010000
	.db	%00011000
	.db	%00000000
	.db	%00010001
	.db	%00111000
	.db	%00010000
	.db	%01011000
	.db	%00010000
	.db	%00110000
	.db	%00010111
	.db	%00010001
	.db	%00011000
	.db	%00000000
	.db	%01010000
	.db	%00010000
	.db	%00011001
	.db	%01001000
	.db	%00011001
	.db	%00010010
	.db	%00011101
	.db	%00010000
	.db	%00011000
	.db	%00000000
	.db	%01010000
	.db	%00010111
	.db	%00010000
	.db	%00011000
	.db	%00010101
	.db	%00011000
	.db	%00000000
	.db	%00011000
	.db	%01000000
	.db	%00011111
	.db	%00011000
	.db	%01000000
	.db	%00011001
	.db	%01001000
	.db	%00011010
	.db	%00000000
	.db	%01010111
	.db	%01010000
	.db	%00010000
	.db	%00110000
	.db	%00010000
	.db	%10010000
	.db	%10001000
	.db	%00010000
	.db	%01111000
	.db	%10000000
	.db	%00011000
	.db	%00000000
	.db	%00011111
	.db	%00011111
	.db	%00011001
	.db	%00000000
 .db	 0, 1
	.db	%00011111
	.db	%00011111
	.db	%00011001
	.db	%00000000
	.db	%00010000
	.db	%00111000
	.db	%00010001
	.db	%10001000
	.db	%01110000
	.db	%01011000
	.db	%01111000
	.db	%00010111
	.db	%00010000
	.db	%00011000
	.db	%00000000
	.db	%01001000
	.db	%00011001
	.db	%01001000
	.db	%00011111
	.db	%00011000
	.db	%01000000
	.db	%00011011
	.db	%00000000
	.db	%00010000
	.db	%00111000
	.db	%00010111
	.db	%00010101
	.db	%10000000
	.db	%00011000
	.db	%00000000
	.db	%01011000
	.db	%00011001
	.db	%01001000
	.db	%00011111
	.db	%00011000
	.db	%01001000
	.db	%00011011
	.db	%00000000
	.db	%01010000
	.db	%00011000
	.db	%00010010
	.db	%00011000
	.db	%01010001
	.db	%01011000
	.db	%01010001
	.db	%00011000
	.db	%00010100
	.db	%00011000
	.db	%00000000
	.db	%01010000
	.db	%00011000
	.db	%00010010
	.db	%10010000
	.db	%00010100
	.db	%00111000
	.db	%00010100
	.db	%00011000
	.db	%00000000
	.db	%01010000
	.db	%00011000
	.db	%01010010
	.db	%00011110
	.db	%00010010
	.db	%00011010
	.db	%00000000
	.db	%01010000
	.db	%00011000
	.db	%01101000
	.db	%01010000
	.db	%00010000
	.db	%00110000
	.db	%00010000
	.db	%01011000
	.db	%00010110
	.db	%10010000
	.db	%00010001
	.db	%00000000
	.db	%00011111
	.db	%00011111
	.db	%00011001
	.db	%00000000
 .db	 0, 8
	.db	%00000000
	.db	%00100000
	.db	%00011111
	.db	%00011111
	.db	%00000001
	.db	%00011000
	.db	%00010010
	.db	%01010010
	.db	%00010010
	.db	%00110000
	.db	%00010101
	.db	%00000001
	.db	%00011000
	.db	%00010000
	.db	%00011111
	.db	%00011000
	.db	%00010001
	.db	%00011011
	.db	%00000001
	.db	%00011000
	.db	%00010000
	.db	%00011100
	.db	%00010101
	.db	%00011000
	.db	%00000100
	.db	%00011000
	.db	%00010010
	.db	%01011000
	.db	%01110000
	.db	%00111000
	.db	%00010001
	.db	%00011100
	.db	%00000100
	.db	%00100000
	.db	%00011101
	.db	%00010001
	.db	%00011000
	.db	%00000111
	.db	%00000010
	.db	%00011011
	.db	%00010001
	.db	%00011000
	.db	%00100000
	.db	%00000111
	.db	%00011010
	.db	%00010101
	.db	%00011000
	.db	%00000111
	.db	%00000000
	.db	%00010100
	.db	%00011011
	.db	%00100000
	.db	%00000111
	.db	%00000000
	.db	%00011100
	.db	%00100000
	.db	%00000111
	.db	%00000100
 .db	 0, 1
	.db	%00011111
	.db	%00011111
	.db	%00011010
	.db	%00010001
	.db	%01011000
	.db	%00010101
	.db	%11000000
	.db	%00010001
	.db	%10000000
	.db	%00011000
	.db	%00010000
	.db	%10001000
	.db	%10010000
	.db	%00010001
	.db	%01000000
	.db	%00011000
	.db	%01001000
	.db	%00011110
	.db	%01000000
	.db	%00011010
	.db	%01000000
	.db	%00011011
	.db	%00010000
	.db	%00011000
	.db	%00010000
	.db	%00011000
	.db	%00010111
	.db	%00010100
	.db	%00011000
	.db	%00000000
	.db	%00010000
	.db	%00011000
	.db	%00010000
	.db	%00011000
	.db	%00010000
	.db	%00011111
	.db	%00011000
	.db	%01000000
	.db	%00011000
	.db	%00010000
	.db	%00011000
	.db	%00000000
	.db	%00010000
	.db	%00011000
	.db	%00010000
	.db	%00011000
	.db	%01011000
	.db	%00010110
	.db	%10000000
	.db	%01011001
	.db	%00011000
	.db	%00010000
	.db	%00011000
	.db	%00000000
	.db	%01111000
	.db	%00011000
	.db	%00010000
	.db	%00011111
	.db	%00011010
	.db	%01001000
	.db	%00011000
	.db	%00010000
	.db	%00011000
	.db	%00000000
	.db	%00010000
	.db	%00110000
	.db	%00010111
	.db	%00010110
	.db	%00011000
	.db	%00000000
	.db	%00011111
	.db	%00011111
	.db	%00011001
	.db	%00000000
	.db	%00011111
	.db	%00011111
	.db	%00011001
	.db	%00000000
 .db	 0, 1
	.db	%00011111
	.db	%00011111
	.db	%00011001
	.db	%00000000
	.db	%00010011
	.db	%01011000
	.db	%00010011
	.db	%10110000
	.db	%00010000
	.db	%10000000
	.db	%10010000
	.db	%00010100
	.db	%00000000
	.db	%00011111
	.db	%00010000
	.db	%00011000
	.db	%00010000
	.db	%00011110
	.db	%00000000
	.db	%00011111
	.db	%00010000
	.db	%00011000
	.db	%01000000
	.db	%00011110
	.db	%00000000
	.db	%00010111
	.db	%00010010
	.db	%10010000
	.db	%00010100
	.db	%00011000
	.db	%00000000
	.db	%00010000
	.db	%00011100
	.db	%01001000
	.db	%00011010
	.db	%11000000
	.db	%00011100
	.db	%00010000
	.db	%00011000
	.db	%00000000
	.db	%00010000
	.db	%00110000
	.db	%00010101
	.db	%00110000
	.db	%00010001
	.db	%01011000
	.db	%00010001
	.db	%01110000
	.db	%00111000
	.db	%00010000
	.db	%00011000
	.db	%00000000
	.db	%00010000
	.db	%00011101
	.db	%00010000
	.db	%00011000
	.db	%00010000
	.db	%00011101
	.db	%01011000
	.db	%00011000
	.db	%00000000
	.db	%00010111
	.db	%00111000
	.db	%00010111
	.db	%00011000
	.db	%00000000
	.db	%00011111
	.db	%00011111
	.db	%00011001
	.db	%00000000
 .db	 0, 1
	.db	%00011111
	.db	%00011111
	.db	%00011010
	.db	%00010001
	.db	%01011000
	.db	%00010111
	.db	%00010111
	.db	%00011100
	.db	%01000000
	.db	%00011111
	.db	%00011100
	.db	%00000011
	.db	%00100000
	.db	%00010000
	.db	%00100000
	.db	%00000111
	.db	%00000011
	.db	%00100000
	.db	%00101011
	.db	%01000000
	.db	%00101111
	.db	%00101000
	.db	%00100000
	.db	%00101011
	.db	%01110000
	.db	%01010010
	.db	%00010000
	.db	%01010010
	.db	%00010000
	.db	%01010010
	.db	%00010101
	.db	%00101000
	.db	%01101000
	.db	%01010000
	.db	%00010000
	.db	%01010000
	.db	%00010000
	.db	%01010000
	.db	%00010000
	.db	%01010000
	.db	%00010000
	.db	%01010000
	.db	%00010000
	.db	%01010000
	.db	%00010001
	.db	%00100000
	.db	%00101011
	.db	%01011000
	.db	%01010000
	.db	%00010000
	.db	%01010000
	.db	%00010000
	.db	%01010000
	.db	%00010000
	.db	%01010000
	.db	%00010000
	.db	%01010000
	.db	%00010000
	.db	%01010000
	.db	%00010001
	.db	%00101000
	.db	%00000010
	.db	%00101000
	.db	%01100000
	.db	%01010000
	.db	%00010000
	.db	%01010010
	.db	%00010000
	.db	%01010010
	.db	%00010000
	.db	%01010001
	.db	%01011000
	.db	%00101000
	.db	%00000010
	.db	%00100000
	.db	%00101111
	.db	%00101101
	.db	%00100000
	.db	%00000010
 .db	 0, 1
	.db	%00011111
	.db	%00011111
	.db	%00011010
	.db	%00010000
	.db	%00111000
	.db	%00010111
	.db	%00010001
	.db	%10000000
	.db	%10010000
	.db	%00010010
	.db	%00011001
	.db	%01001000
	.db	%00011000
	.db	%01001000
	.db	%01000000
	.db	%00011011
	.db	%01000000
	.db	%00011100
	.db	%01001000
	.db	%00011011
	.db	%00010000
	.db	%00111000
	.db	%00010000
	.db	%01011000
	.db	%00011000
	.db	%00000001
	.db	%00011000
	.db	%00010000
	.db	%00011000
	.db	%00010100
	.db	%10001000
	.db	%00010000
	.db	%00001000
	.db	%00011000
	.db	%00010000
	.db	%00011001
	.db	%00010001
	.db	%00011010
	.db	%00010000
	.db	%00011000
	.db	%01111000
	.db	%00011111
	.db	%01011000
	.db	%00011000
	.db	%00000000
	.db	%00011000
	.db	%00010101
	.db	%00011010
	.db	%01010001
	.db	%01101000
	.db	%00110000
	.db	%00010010
	.db	%00011000
	.db	%00000000
	.db	%00011000
	.db	%00010010
	.db	%00011010
	.db	%00000001
	.db	%00011000
	.db	%01010000
	.db	%00011100
	.db	%00010000
	.db	%00011001
	.db	%00010001
	.db	%00011000
	.db	%00010001
	.db	%00011100
	.db	%00010000
	.db	%00011100
	.db	%00010000
	.db	%00110000
	.db	%01110000
	.db	%00010000
	.db	%00011000
	.db	%00000000
	.db	%00011000
	.db	%00010110
	.db	%10001000
	.db	%00010000
	.db	%00111000
	.db	%00010001
	.db	%00011100
	.db	%00000000
	.db	%00011111
	.db	%00011100
 .db	 0, 1
	.db	%00011111
	.db	%00011111
	.db	%00011010
	.db	%00010111
	.db	%00010110
	.db	%10001000
	.db	%01011000
	.db	%01110000
	.db	%00011000
	.db	%01011000
	.db	%00011010
	.db	%00010000
	.db	%00011111
	.db	%00011111
	.db	%01101000
	.db	%00011000
	.db	%00010111
	.db	%00010011
	.db	%01011000
	.db	%01111000
	.db	%00100000
	.db	%01011000
	.db	%01010000
	.db	%00010000
	.db	%00011000
	.db	%00010001
	.db	%00011011
	.db	%00100000
	.db	%00011011
	.db	%00101000
	.db	%00011100
	.db	%00010000
	.db	%00011000
	.db	%00010111
	.db	%00010011
	.db	%01010000
	.db	%01011000
	.db	%00011010
	.db	%00010000
	.db	%00011000
	.db	%00010000
	.db	%00011000
	.db	%00101000
	.db	%00011000
	.db	%00101000
	.db	%00100000
	.db	%00011011
	.db	%00101000
	.db	%00011011
	.db	%01010000
	.db	%10010000
	.db	%00010000
	.db	%00011000
	.db	%00010000
	.db	%00011011
	.db	%00101000
	.db	%00011001
	.db	%01010100
	.db	%00010001
	.db	%01010000
	.db	%00011000
	.db	%00010111
	.db	%00010010
	.db	%00011010
	.db	%00101000
	.db	%00011111
	.db	%00011110
	.db	%00101001
	.db	%00011011
 .db	 0, 6
	.db	%00011111
	.db	%00011001
	.db	%00100000
	.db	%00011101
	.db	%00101000
	.db	%00011000
	.db	%00010101
	.db	%10010000
	.db	%00010000
	.db	%10010000
	.db	%10000000
	.db	%00010111
	.db	%00011000
	.db	%00010000
	.db	%00101000
	.db	%00100000
	.db	%00011001
	.db	%00100000
	.db	%00011000
	.db	%00010000
	.db	%00011000
	.db	%00100000
	.db	%00011011
	.db	%00010000
	.db	%00011011
	.db	%00010000
	.db	%00011011
	.db	%00010001
	.db	%01101000
	.db	%01011000
	.db	%00010000
	.db	%10010000
	.db	%00010100
	.db	%10001000
	.db	%00010010
	.db	%00011000
	.db	%00010001
	.db	%10010000
	.db	%00010000
	.db	%00011111
	.db	%00011000
	.db	%00010000
	.db	%00011010
	.db	%01011000
	.db	%00011000
	.db	%00010000
	.db	%00011111
	.db	%00101000
	.db	%00011010
	.db	%00010000
	.db	%00011001
	.db	%00101000
	.db	%00010111
	.db	%00010111
	.db	%00010001
	.db	%00011010
	.db	%01001000
	.db	%00011111
	.db	%00011000
	.db	%01000000
	.db	%00011101
	.db	%01111000
	.db	%00010111
	.db	%00010110
	.db	%00011000
	.db	%00000001
	.db	%00011010
	.db	%00101000
	.db	%00011111
	.db	%00101000
	.db	%00011011
	.db	%00000001
 .db	 0, 1
	.db	%00011111
	.db	%00011000
	.db	%00100000
	.db	%00011111
	.db	%00011000
	.db	%00010000
	.db	%01011000
	.db	%00010001
	.db	%10010000
	.db	%01101000
	.db	%01011000
	.db	%00010100
	.db	%01010010
	.db	%10110000
	.db	%00010001
	.db	%00011000
	.db	%00010001
	.db	%00011000
	.db	%00101000
	.db	%00011110
	.db	%00010000
	.db	%00011011
	.db	%00010110
	.db	%10010000
	.db	%00010111
	.db	%00010100
	.db	%00011000
	.db	%00010010
	.db	%00011111
	.db	%00011111
	.db	%00010010
	.db	%00011001
	.db	%01011000
	.db	%00011101
	.db	%10000000
	.db	%00011000
	.db	%00000100
	.db	%00010001
	.db	%00011010
	.db	%00010111
	.db	%00011000
	.db	%00000100
	.db	%00011000
	.db	%00010100
	.db	%00011111
	.db	%00000100
	.db	%00011000
	.db	%01110000
	.db	%00011100
	.db	%00000111
	.db	%00000100
	.db	%00011000
	.db	%00000111
	.db	%00000111
	.db	%00000000
 .db	 1, 2
	.db	%00011010
	.db	%00101000
	.db	%00011111
	.db	%00011110
	.db	%00010111
	.db	%00010001
	.db	%01111000
	.db	%01011000
	.db	%00010010
	.db	%01010010
	.db	%00011000
	.db	%00010001
	.db	%00011000
	.db	%01010000
	.db	%00011000
	.db	%01010000
	.db	%00011000
	.db	%01010000
	.db	%00011110
	.db	%01000000
	.db	%00011010
	.db	%00010001
	.db	%10110000
	.db	%00010000
	.db	%10110000
	.db	%00010000
	.db	%10110000
	.db	%00010000
	.db	%10001000
	.db	%00010000
	.db	%00011100
	.db	%00010000
	.db	%01010001
	.db	%00011001
	.db	%00010000
	.db	%00011000
	.db	%01010000
	.db	%00011000
	.db	%01010000
	.db	%00011000
	.db	%01010000
	.db	%10001000
	.db	%00010001
	.db	%01110000
	.db	%00010000
	.db	%10010000
	.db	%00010001
	.db	%00011001
	.db	%00001000
	.db	%00010111
	.db	%10001000
	.db	%00010000
	.db	%00011011
	.db	%00010001
	.db	%00011010
	.db	%00010000
	.db	%00011011
	.db	%10000000
	.db	%00011100
	.db	%00010011
	.db	%00011001
	.db	%00101000
	.db	%00011000
	.db	%00010000
	.db	%00011010
	.db	%00101000
	.db	%01011000
	.db	%00010101
	.db	%00011110
	.db	%00010010
	.db	%01011000
	.db	%00011110
	.db	%00010111
	.db	%00011100
	.db	%00000100
	.db	%00011111
	.db	%00011000
 .db	 0, 8
	.db	%00000000
	.db	%00011111
	.db	%00011111
	.db	%00011001
	.db	%00000000
	.db	%00011000
	.db	%00010111
	.db	%00010110
	.db	%10010000
	.db	%00010000
	.db	%00000000
	.db	%00011000
	.db	%00010000
	.db	%00011100
	.db	%01001000
	.db	%11000000
	.db	%00011111
	.db	%00011010
	.db	%00010000
	.db	%00011000
	.db	%00010111
	.db	%00010010
	.db	%10001000
	.db	%10000000
	.db	%01011000
	.db	%00011000
	.db	%00010010
	.db	%10010000
	.db	%00010000
	.db	%00011110
	.db	%00010000
	.db	%00011101
	.db	%00010001
	.db	%00011001
	.db	%00010000
	.db	%00011101
	.db	%01101000
	.db	%00010000
	.db	%00011000
	.db	%00000100
	.db	%00010000
	.db	%00011001
	.db	%00101000
	.db	%00010111
	.db	%00010000
	.db	%00011000
	.db	%00000100
	.db	%00010000
	.db	%00011010
	.db	%01111000
	.db	%01011000
	.db	%00011111
	.db	%00000100
	.db	%00010000
	.db	%01011000
	.db	%00010000
	.db	%00011000
	.db	%01110000
	.db	%00011000
	.db	%00000111
	.db	%00000100
	.db	%00011101
	.db	%00000111
	.db	%00000100
 .db	 0, 1
	.db	%00011111
	.db	%00011111
	.db	%00011010
	.db	%00010011
	.db	%00111000
	.db	%00010001
	.db	%01011000
	.db	%00010111
	.db	%00010001
	.db	%00011000
	.db	%00010000
	.db	%00011111
	.db	%01001000
	.db	%00100000
	.db	%00011000
	.db	%01000000
	.db	%00011011
	.db	%01001000
	.db	%00011000
	.db	%00010011
	.db	%00110000
	.db	%00010100
	.db	%00011000
	.db	%00101000
	.db	%00010001
	.db	%01110000
	.db	%00010010
	.db	%00011000
	.db	%01001000
	.db	%00011111
	.db	%00011100
	.db	%01001000
	.db	%00011001
	.db	%01000000
	.db	%00011000
	.db	%00010000
	.db	%01010011
	.db	%00010000
	.db	%01101000
	.db	%00010101
	.db	%00011000
	.db	%00010011
	.db	%00011000
	.db	%01000000
	.db	%00011111
	.db	%01000000
	.db	%00011001
	.db	%01001000
	.db	%00011010
	.db	%00010000
	.db	%01011000
	.db	%00011000
	.db	%01011000
	.db	%10010000
	.db	%11000000
	.db	%00010001
	.db	%10010000
	.db	%00010001
	.db	%00011000
	.db	%00010001
	.db	%00110000
	.db	%00010010
	.db	%00011000
	.db	%10000000
	.db	%00011001
	.db	%01111000
	.db	%10010000
	.db	%00010001
	.db	%11000000
	.db	%10010000
	.db	%00010001
	.db	%10010000
	.db	%00010000
	.db	%01010000
	.db	%00011010
	.db	%00010010
	.db	%10001000
	.db	%00010000
	.db	%00011111
	.db	%00011111
	.db	%00011010
 .db	 0, 8
	.db	%00011011
	.db	%00101000
	.db	%00011111
	.db	%00011111
	.db	%00011000
	.db	%00101000
	.db	%00100000
	.db	%00101000
	.db	%00011111
	.db	%00011100
	.db	%00101011
	.db	%00100001
	.db	%00101000
	.db	%00011010
	.db	%00101111
	.db	%00101000
	.db	%00100110
	.db	%00101000
	.db	%00011001
	.db	%00101000
	.db	%00010101
	.db	%00001000
	.db	%00101100
	.db	%00100001
	.db	%00101000
	.db	%00011010
	.db	%00101000
	.db	%00010000
	.db	%00101110
	.db	%00011010
	.db	%00101000
	.db	%00100000
	.db	%00101000
	.db	%00011011
	.db	%00101000
	.db	%00010000
	.db	%00101000
	.db	%00011111
	.db	%00011001
	.db	%00101000
	.db	%00011100
	.db	%00101000
	.db	%00010000
	.db	%00101000
	.db	%00011100
	.db	%00000000
	.db	%00101111
	.db	%00101010
	.db	%01000000
	.db	%00101000
	.db	%00011011
	.db	%00000001
	.db	%00010001
	.db	%01011000
	.db	%00010001
	.db	%01010010
	.db	%00010011
	.db	%00101000
	.db	%00011010
	.db	%00000010
	.db	%00101111
	.db	%00101100
	.db	%00011001
	.db	%00000011
 .db	 7, 1
	.db	%00000100
	.db	%00011000
	.db	%00100000
	.db	%00101000
	.db	%00100000
	.db	%00011000
	.db	%00000111
	.db	%00000000
	.db	%00011101
	.db	%00101000
	.db	%00010000
	.db	%00101000
	.db	%00011110
	.db	%00000010
	.db	%00011001
	.db	%00010001
	.db	%10010000
	.db	%01101000
	.db	%00100000
	.db	%00010000
	.db	%00100000
	.db	%00011001
	.db	%01111000
	.db	%00010010
	.db	%00011010
	.db	%00000000
	.db	%01110000
	.db	%00010010
	.db	%00011010
	.db	%01001000
	.db	%00011010
	.db	%00010000
	.db	%00011001
	.db	%00010001
	.db	%01010000
	.db	%00011000
	.db	%00000000
	.db	%00011000
	.db	%00010000
	.db	%00011000
	.db	%00010000
	.db	%01011000
	.db	%00010000
	.db	%00110000
	.db	%00010000
	.db	%00111000
	.db	%00010000
	.db	%01011000
	.db	%00010001
	.db	%00111000
	.db	%00010000
	.db	%00011010
	.db	%00000000
	.db	%00011000
	.db	%01001000
	.db	%00011001
	.db	%00010010
	.db	%00110000
	.db	%00010001
	.db	%00011001
	.db	%00010000
	.db	%00011000
	.db	%01010000
	.db	%00011000
	.db	%00000010
	.db	%00011000
	.db	%00010000
	.db	%00011010
	.db	%01001000
	.db	%00011010
	.db	%01000000
	.db	%00011001
	.db	%00010000
	.db	%00011000
	.db	%01010000
	.db	%00011011
	.db	%10000000
	.db	%00010101
	.db	%00101000
	.db	%00010001
	.db	%00110000
	.db	%00010001
	.db	%10001000
	.db	%01011000
	.db	%00111000
	.db	%00010010
	.db	%00011101
	.db	%00010010
	.db	%00011111
	.db	%00011111
	.db	%00011111
	.db	%00011100
 .db	 0, 7
	.db	%00011111
	.db	%00011000
	.db	%00000111
	.db	%00000001
	.db	%01100000
	.db	%01010000
	.db	%00011000
	.db	%01111000
	.db	%00010011
	.db	%00011111
	.db	%00011010
	.db	%01010001
	.db	%00011000
	.db	%11000011
	.db	%00010000
	.db	%00011000
	.db	%00010000
	.db	%10001000
	.db	%01011000
	.db	%00010011
	.db	%10000000
	.db	%01011000
	.db	%00011000
	.db	%01010001
	.db	%00011000
	.db	%00010010
	.db	%11000000
	.db	%00010010
	.db	%00011000
	.db	%01001000
	.db	%00011110
	.db	%00010000
	.db	%00011001
	.db	%00010000
	.db	%00011000
	.db	%00010000
	.db	%11000000
	.db	%00011001
	.db	%00010000
	.db	%00011000
	.db	%00010101
	.db	%01110000
	.db	%00011000
	.db	%00010011
	.db	%00011000
	.db	%00010000
	.db	%11000000
	.db	%00011001
	.db	%00010000
	.db	%00011000
	.db	%00010000
	.db	%00011110
	.db	%00010000
	.db	%00011011
	.db	%00010100
	.db	%00110000
	.db	%00010000
	.db	%00011010
	.db	%00010111
	.db	%00011000
	.db	%00010000
	.db	%00011100
	.db	%00010000
	.db	%00011010
	.db	%00010000
	.db	%00011101
	.db	%01011000
	.db	%00011000
	.db	%00010100
	.db	%10010000
	.db	%01101000
	.db	%10010000
	.db	%01110000
	.db	%00010001
	.db	%00011000
	.db	%00000011
	.db	%00011111
	.db	%00011110
	.db	%00000001
 .db	 0, 8
	.db	%00101101
	.db	%00100010
	.db	%00011000
	.db	%00000010
	.db	%00011000
	.db	%00100010
	.db	%00011000
	.db	%00000000
	.db	%01011000
	.db	%00101000
	.db	%01011000
	.db	%00101000
	.db	%01110000
	.db	%00111000
	.db	%00010000
	.db	%01011000
	.db	%00010000
	.db	%00100001
	.db	%00011000
	.db	%00000000
	.db	%00100000
	.db	%00010010
	.db	%00011000
	.db	%00000000
	.db	%01111000
	.db	%00101000
	.db	%10000000
	.db	%00101000
	.db	%10000000
	.db	%00101010
	.db	%00010010
	.db	%00100000
	.db	%00000000
	.db	%00100000
	.db	%00010000
	.db	%00100000
	.db	%00010000
	.db	%00100000
	.db	%00000000
	.db	%00010000
	.db	%00111000
	.db	%00010000
	.db	%00111000
	.db	%00010000
	.db	%00111000
	.db	%00010000
	.db	%00101010
	.db	%00010000
	.db	%00100010
	.db	%01000000
	.db	%00100000
	.db	%01001000
	.db	%00100000
	.db	%00000000
	.db	%00010000
	.db	%00101000
	.db	%00010000
	.db	%00101000
	.db	%00010000
	.db	%00101000
	.db	%00010001
	.db	%01101000
	.db	%00101000
	.db	%00010000
	.db	%10001000
	.db	%00010000
	.db	%11000000
	.db	%00010000
	.db	%00100000
	.db	%00010000
	.db	%00100000
	.db	%00000000
	.db	%00010000
	.db	%00110000
	.db	%00010000
	.db	%00110000
	.db	%00010000
	.db	%00110000
	.db	%00010000
	.db	%00101010
	.db	%00010000
	.db	%00100000
	.db	%01001000
	.db	%00100000
	.db	%01000000
	.db	%00100000
	.db	%01001000
	.db	%00100000
	.db	%00000000
	.db	%00010000
	.db	%00101000
	.db	%00010000
	.db	%00101000
	.db	%00010000
	.db	%00101010
	.db	%00010010
	.db	%00100000
	.db	%00010000
	.db	%00100000
	.db	%00010000
	.db	%00100000
	.db	%00010000
	.db	%00100000
	.db	%00000000
	.db	%00010000
	.db	%00101000
	.db	%00010000
	.db	%00101000
	.db	%00010000
	.db	%00101000
	.db	%00010010
	.db	%00100010
	.db	%00010000
	.db	%00100000
	.db	%00010000
	.db	%00100000
	.db	%00010000
	.db	%00100000
	.db	%00000000
	.db	%00010100
	.db	%00111000
	.db	%00010000
	.db	%00100001
	.db	%00011000
	.db	%00000000
	.db	%00100000
	.db	%00010010
	.db	%00100000
	.db	%00010001
	.db	%00000000
	.db	%00101101
	.db	%00100000
	.db	%00011000
	.db	%00000010
	.db	%00011000
	.db	%00100010
	.db	%00011000
	.db	%00100001
	.db	%00000000
 .db	 0, 8
	.db	%00011111
	.db	%00011111
	.db	%00011010
	.db	%00101111
	.db	%00101110
	.db	%01101000
	.db	%00101000
	.db	%01011000
	.db	%00101000
	.db	%01011000
	.db	%01010011
	.db	%00010000
	.db	%00110000
	.db	%00010110
	.db	%00111000
	.db	%00010000
	.db	%00110000
	.db	%00010000
	.db	%00101000
	.db	%01010000
	.db	%00101101
	.db	%00010000
	.db	%00011001
	.db	%01110000
	.db	%00011001
	.db	%00010000
	.db	%00110000
	.db	%00010000
	.db	%00101000
	.db	%00010000
	.db	%00101000
	.db	%01010000
	.db	%00101101
	.db	%01000000
	.db	%00011100
	.db	%01001000
	.db	%00101000
	.db	%01001000
	.db	%00101000
	.db	%01000000
	.db	%00101000
	.db	%01010001
	.db	%00101000
	.db	%00010001
	.db	%10001000
	.db	%00111000
	.db	%00010000
	.db	%00111000
	.db	%00010000
	.db	%01011000
	.db	%00010000
	.db	%00110000
	.db	%00010000
	.db	%00111000
	.db	%00010000
	.db	%10010000
	.db	%00010001
	.db	%00101000
	.db	%10000000
	.db	%00101000
	.db	%01111000
	.db	%00101010
	.db	%01000000
	.db	%00100100
	.db	%01001000
	.db	%00101010
	.db	%00010000
	.db	%00101001
	.db	%00010000
	.db	%01011000
	.db	%00010000
	.db	%00101000
	.db	%00011000
	.db	%00101000
	.db	%00010000
	.db	%00100001
	.db	%01011000
	.db	%00100001
	.db	%00010000
	.db	%00101010
	.db	%00010000
	.db	%00101000
	.db	%00010001
	.db	%00101010
	.db	%00011000
	.db	%00101000
	.db	%00010111
	.db	%00010000
	.db	%01111000
	.db	%00010000
	.db	%00101011
	.db	%00011010
	.db	%00101111
	.db	%00101100
 .db	 0, 6
	.db	%00101111
	.db	%00101111
	.db	%00101010
	.db	%00100111
	.db	%00100111
	.db	%00100000
	.db	%00101001
	.db	%00010111
	.db	%00010110
	.db	%01010000
	.db	%00100001
	.db	%00011000
	.db	%00010000
	.db	%00011000
	.db	%00100111
	.db	%00100010
	.db	%01001000
	.db	%01000000
	.db	%00100001
	.db	%01110000
	.db	%00100000
	.db	%01011000
	.db	%00100000
	.db	%00010001
	.db	%10001000
	.db	%01011000
	.db	%10001000
	.db	%00010111
	.db	%10001000
	.db	%10010000
	.db	%00010001
	.db	%00100001
	.db	%00010000
	.db	%00100110
	.db	%00011000
	.db	%01000000
	.db	%00100100
	.db	%01101000
	.db	%00100000
	.db	%00010111
	.db	%00010000
	.db	%01111000
	.db	%00111000
	.db	%00010001
	.db	%01110000
	.db	%01100000
	.db	%00100000
	.db	%00011000
	.db	%00100000
	.db	%00011000
	.db	%00100001
	.db	%00010000
	.db	%00100110
	.db	%00011000
	.db	%01001000
	.db	%00100010
	.db	%00011000
	.db	%00101011
	.db	%00100000
	.db	%00010111
	.db	%10001000
	.db	%00010001
	.db	%10000000
	.db	%01011000
	.db	%00100000
	.db	%00101011
	.db	%00011000
	.db	%00100111
	.db	%00100100
	.db	%00011000
	.db	%00101010
 .db	 0, 4
	.db	%00100000
	.db	%00011000
	.db	%00100000
	.db	%00011000
	.db	%00100000
	.db	%00011000
	.db	%00100000
	.db	%00011000
	.db	%00100000
	.db	%00011000
	.db	%00100000
	.db	%00011000
	.db	%00100000
	.db	%00011000
	.db	%00100000
	.db	%00011000
	.db	%00100000
	.db	%00011000
	.db	%00100000
	.db	%00010110
	.db	%01010001
	.db	%01011000
	.db	%01010111
	.db	%00011000
	.db	%00010000
	.db	%00011000
	.db	%00100000
	.db	%00011000
	.db	%00100000
	.db	%00011000
	.db	%01000000
	.db	%00011000
	.db	%00100000
	.db	%00011000
	.db	%00100000
	.db	%00011000
	.db	%00100000
	.db	%00011000
	.db	%00100000
	.db	%00011000
	.db	%00100000
	.db	%01010000
	.db	%00100000
	.db	%01000000
	.db	%00100000
	.db	%00011000
	.db	%00100000
	.db	%00011000
	.db	%00100000
	.db	%00010000
	.db	%01111000
	.db	%00010000
	.db	%00110000
	.db	%00010000
	.db	%01010110
	.db	%00011000
	.db	%00010000
	.db	%00111000
	.db	%00010010
	.db	%00011000
	.db	%01000000
	.db	%00011000
	.db	%00100000
	.db	%00011000
	.db	%01001000
	.db	%00011000
	.db	%00100000
	.db	%00011000
	.db	%00100000
	.db	%00011000
	.db	%00100000
	.db	%00011000
	.db	%00100000
	.db	%01001000
	.db	%00011000
	.db	%00100000
	.db	%00011000
	.db	%00010000
	.db	%00100000
	.db	%00010010
	.db	%00100000
	.db	%00010100
	.db	%10001000
	.db	%00010000
	.db	%10010000
	.db	%00001000
	.db	%00010000
	.db	%00111000
	.db	%00010010
	.db	%00011000
	.db	%00010000
	.db	%00011000
	.db	%00010000
	.db	%00011000
	.db	%00010000
	.db	%00011000
	.db	%00100000
	.db	%00011000
	.db	%00010000
	.db	%00011000
	.db	%00010000
	.db	%00100000
	.db	%00011000
	.db	%01011000
	.db	%00011000
	.db	%00010000
	.db	%00100000
	.db	%00011000
	.db	%00100000
	.db	%00010000
	.db	%00100000
	.db	%00010000
	.db	%00111000
	.db	%00010100
	.db	%10001000
	.db	%00010000
	.db	%00011000
	.db	%00100000
	.db	%00010000
	.db	%00110000
	.db	%00010100
	.db	%00011000
	.db	%00010000
	.db	%00011000
	.db	%10000000
	.db	%00011000
	.db	%00100000
	.db	%00011000
	.db	%00100000
	.db	%00011000
	.db	%01010001
	.db	%00100000
	.db	%00011000
	.db	%00100000
	.db	%00011000
	.db	%00100000
	.db	%00011000
	.db	%00100000
	.db	%00011000
	.db	%00100000
	.db	%00011000
	.db	%00100000
	.db	%00011000
	.db	%00100000
	.db	%00011000
	.db	%00100000
	.db	%00011000
	.db	%00100000
	.db	%00011000
	.db	%00100000
	.db	%00011000
 .db	 8, 4
	.db	%00011110
	.db	%00100010
	.db	%00011010
	.db	%00101000
	.db	%00100011
	.db	%00101000
	.db	%00100000
	.db	%00101000
	.db	%00011010
	.db	%00101000
	.db	%00100001
	.db	%01101000
	.db	%00100001
	.db	%00101000
	.db	%00011000
	.db	%00100000
	.db	%00010000
	.db	%10010000
	.db	%10001000
	.db	%01011000
	.db	%00100000
	.db	%10100000
	.db	%00100000
	.db	%00011010
	.db	%00100000
	.db	%00010000
	.db	%00110000
	.db	%00010000
	.db	%00111000
	.db	%00010000
	.db	%00100000
	.db	%00011000
	.db	%00100000
	.db	%00010000
	.db	%00100010
	.db	%00101000
	.db	%00010000
	.db	%00100100
	.db	%01001000
	.db	%00101000
	.db	%01000000
	.db	%00101000
	.db	%01001000
	.db	%00100010
	.db	%00010000
	.db	%00100010
	.db	%00101000
	.db	%00010000
	.db	%01011000
	.db	%00010100
	.db	%00110000
	.db	%00010000
	.db	%00110000
	.db	%00010000
	.db	%00110000
	.db	%00010000
	.db	%01010101
	.db	%00100001
	.db	%01000000
	.db	%00100010
	.db	%01001000
	.db	%00101000
	.db	%01001000
	.db	%00101000
	.db	%01000000
	.db	%00100010
	.db	%00010000
	.db	%00100010
	.db	%00101000
	.db	%00011000
	.db	%00100000
	.db	%00010010
	.db	%00110000
	.db	%00010000
	.db	%00111000
	.db	%00010000
	.db	%00111000
	.db	%00010000
	.db	%00100000
	.db	%00011000
	.db	%00100000
	.db	%10000000
	.db	%00100000
	.db	%00011011
	.db	%00101000
	.db	%00100011
	.db	%00010000
	.db	%00100000
	.db	%01110000
	.db	%00100001
	.db	%00101001
	.db	%00100000
	.db	%01111000
	.db	%00100000
	.db	%00101000
	.db	%00011110
	.db	%00100000
	.db	%00010000
	.db	%00110000
	.db	%00010000
	.db	%00100000
	.db	%00011001
	.db	%00100000
	.db	%00010000
	.db	%01011000
	.db	%00010000
	.db	%00100000
	.db	%00011110
	.db	%00101000
	.db	%00100011
	.db	%00011001
	.db	%00101000
	.db	%00100010
	.db	%00101000
	.db	%00011001
 .db	 0, 4
	.db	%00101000
	.db	%00100000
	.db	%00011000
	.db	%00101000
	.db	%00100000
	.db	%00011000
	.db	%00101000
	.db	%00100000
	.db	%00011000
	.db	%00101000
	.db	%00100000
	.db	%00011000
	.db	%00101000
	.db	%00100000
	.db	%00011000
	.db	%00101000
	.db	%00100000
	.db	%00011000
	.db	%00101001
	.db	%00100000
	.db	%00010000
	.db	%00101000
	.db	%10011000
	.db	%00010001
	.db	%01110000
	.db	%00011000
	.db	%01111000
	.db	%00100000
	.db	%00011000
	.db	%00101000
	.db	%00100000
	.db	%00011000
	.db	%00101000
	.db	%00100000
	.db	%00011000
	.db	%00101001
	.db	%00010001
	.db	%00110000
	.db	%00010010
	.db	%01011000
	.db	%00011000
	.db	%00010000
	.db	%00100000
	.db	%00011000
	.db	%00101000
	.db	%00100000
	.db	%00011000
	.db	%00101000
	.db	%00100000
	.db	%00011000
	.db	%00101000
	.db	%00010001
	.db	%00011000
	.db	%00101000
	.db	%00100000
	.db	%00011000
	.db	%00101000
	.db	%00100000
	.db	%00011000
	.db	%00010001
	.db	%10100000
	.db	%00101000
	.db	%00100000
	.db	%00011000
	.db	%00101000
	.db	%00100000
	.db	%00011000
	.db	%00101000
	.db	%00010001
	.db	%00111000
	.db	%00010101
	.db	%00101000
	.db	%00010001
	.db	%00101000
	.db	%00100000
	.db	%00011000
	.db	%00101000
	.db	%00100000
	.db	%00011000
	.db	%00101000
	.db	%00010001
	.db	%00011000
	.db	%00101000
	.db	%00100000
	.db	%00011000
	.db	%00101000
	.db	%00100000
	.db	%00010000
	.db	%00101000
	.db	%01011000
	.db	%00010000
	.db	%10010000
	.db	%10001000
	.db	%01010011
	.db	%00010000
	.db	%00101000
	.db	%00010001
	.db	%00110000
	.db	%00010001
	.db	%10100000
	.db	%00100000
	.db	%00010011
	.db	%00101000
	.db	%00100000
	.db	%00011000
	.db	%00101000
	.db	%00100000
	.db	%00011000
	.db	%00101001
	.db	%00100000
	.db	%00010000
	.db	%00101000
	.db	%00010010
	.db	%00100000
	.db	%00011000
	.db	%10000000
	.db	%00100000
	.db	%00011000
	.db	%00101000
	.db	%00100000
	.db	%00011000
	.db	%00101000
	.db	%00100000
	.db	%00011000
	.db	%00101001
	.db	%00100000
	.db	%00011000
	.db	%00101000
	.db	%01011000
	.db	%00010001
	.db	%01101000
	.db	%00011000
	.db	%01011000
	.db	%00100000
	.db	%00011000
	.db	%00101000
	.db	%00100000
	.db	%00011000
	.db	%00101000
	.db	%00100000
	.db	%00011000
	.db	%00101001
	.db	%00100000
	.db	%00011000
	.db	%00101000
	.db	%00100000
	.db	%00011000
	.db	%00101000
	.db	%00100000
	.db	%00011000
	.db	%00101000
	.db	%00100000
	.db	%00011000
	.db	%00101000
	.db	%00100000
	.db	%00011000
	.db	%00101000
	.db	%00100000
	.db	%00011000
	.db	%00101000
 .db	 0, 8
	.db	%00011111
	.db	%00011111
	.db	%00011010
	.db	%00101010
	.db	%00011001
	.db	%00101000
	.db	%00011010
	.db	%00101000
	.db	%00011001
	.db	%00101001
	.db	%00011001
	.db	%01010000
	.db	%01100000
	.db	%00011000
	.db	%00101000
	.db	%00011001
	.db	%00101000
	.db	%00011000
	.db	%00101001
	.db	%00011000
	.db	%00101001
	.db	%00011000
	.db	%00101000
	.db	%00011001
	.db	%00101000
	.db	%00011000
	.db	%01010001
	.db	%00011000
	.db	%00101010
	.db	%00011001
	.db	%00101000
	.db	%00011000
	.db	%00101000
	.db	%00011000
	.db	%00101000
	.db	%00011000
	.db	%00101000
	.db	%00011011
	.db	%01010001
	.db	%00011000
	.db	%00101000
	.db	%00011011
	.db	%00101000
	.db	%00011010
	.db	%00101000
	.db	%00011000
	.db	%00101000
	.db	%00011001
	.db	%00101000
	.db	%00011000
	.db	%01010001
	.db	%00011000
	.db	%00101000
	.db	%00011000
	.db	%00010000
	.db	%01011000
	.db	%00011000
	.db	%00101000
	.db	%00011010
	.db	%00101000
	.db	%00011001
	.db	%00101001
	.db	%00011001
	.db	%00010001
	.db	%00011010
	.db	%01000000
	.db	%01001000
	.db	%00011111
	.db	%00011011
	.db	%01000000
	.db	%01001000
	.db	%00011000
	.db	%00010100
	.db	%00011111
	.db	%00011010
	.db	%00010011
	.db	%00011010
	.db	%00010011
	.db	%01011000
	.db	%00010111
	.db	%00011111
	.db	%00011111
	.db	%00011100
 .db	 0, 7
	.db	%00101001
	.db	%00011010
	.db	%00101111
	.db	%00101011
	.db	%00011001
	.db	%01101000
	.db	%01110000
	.db	%10011000
	.db	%00011000
	.db	%00010010
	.db	%00101000
	.db	%01010000
	.db	%00010000
	.db	%01010001
	.db	%00101000
	.db	%00010000
	.db	%10010000
	.db	%00010000
	.db	%00101000
	.db	%01011000
	.db	%00011000
	.db	%00010000
	.db	%00101000
	.db	%00011010
	.db	%00101000
	.db	%00010000
	.db	%00101001
	.db	%00010000
	.db	%00101010
	.db	%00010000
	.db	%00101000
	.db	%01111000
	.db	%10001000
	.db	%00010000
	.db	%00001000
	.db	%00010001
	.db	%00110000
	.db	%00010000
	.db	%00111000
	.db	%00010001
	.db	%00111000
	.db	%00010101
	.db	%00101010
	.db	%00011001
	.db	%00101000
	.db	%00010000
	.db	%00101000
	.db	%00010000
	.db	%00101001
	.db	%01001000
	.db	%00101000
	.db	%00010000
	.db	%00011010
	.db	%00101000
	.db	%00010010
	.db	%10001000
	.db	%01100000
	.db	%00011000
	.db	%00101000
	.db	%00010000
	.db	%00101000
	.db	%01011000
	.db	%00101001
	.db	%00010000
	.db	%00101000
	.db	%00010000
	.db	%00011000
	.db	%01011000
	.db	%00011000
	.db	%00101100
	.db	%00011001
	.db	%00101000
	.db	%01001000
	.db	%00101000
	.db	%00010000
	.db	%00101001
	.db	%00010000
	.db	%00101000
	.db	%00010000
	.db	%00011000
	.db	%10000000
	.db	%00011001
	.db	%00100000
	.db	%01010010
	.db	%00010000
	.db	%10110000
	.db	%00010011
	.db	%00101001
	.db	%00010100
	.db	%00011000
	.db	%00100000
	.db	%01010100
	.db	%00100000
	.db	%00101010
	.db	%00010000
	.db	%10110001
	.db	%00010000
	.db	%00101010
	.db	%00011000
	.db	%00100000
	.db	%01100000
	.db	%01010011
	.db	%00001000
	.db	%00100000
	.db	%00000001
	.db	%00101101
	.db	%00000010
	.db	%00100111
 .db	 17, 6
	.db	%00101001
	.db	%00011010
	.db	%00101111
	.db	%00101011
	.db	%00011001
	.db	%00010001
	.db	%10011000
	.db	%00011000
	.db	%00010010
	.db	%00101000
	.db	%00010011
	.db	%00101000
	.db	%00010010
	.db	%00101000
	.db	%01011000
	.db	%00011000
	.db	%00010000
	.db	%00101000
	.db	%00011010
	.db	%00101000
	.db	%00010000
	.db	%00101001
	.db	%00010000
	.db	%00101010
	.db	%00010000
	.db	%00101000
	.db	%00010010
	.db	%00001000
	.db	%00010001
	.db	%00110000
	.db	%00010000
	.db	%00111000
	.db	%00010001
	.db	%00111000
	.db	%00010101
	.db	%00101010
	.db	%00011001
	.db	%00101000
	.db	%00010000
	.db	%00101000
	.db	%00010000
	.db	%00101001
	.db	%01001000
	.db	%00101000
	.db	%00010000
	.db	%00011010
	.db	%00101000
	.db	%00010100
	.db	%00011000
	.db	%00101000
	.db	%00010000
	.db	%00101000
	.db	%00010000
	.db	%00101001
	.db	%00010000
	.db	%00101000
	.db	%00010000
	.db	%00011000
	.db	%00010000
	.db	%00011000
	.db	%00101001
	.db	%00100100
	.db	%00101000
	.db	%01001000
	.db	%00101000
	.db	%00010000
	.db	%00101001
	.db	%00010000
	.db	%00101000
	.db	%00010000
	.db	%00011000
	.db	%00010000
	.db	%00011001
	.db	%00100000
	.db	%01010010
	.db	%00010000
	.db	%10110000
	.db	%00010011
	.db	%00101001
	.db	%00010100
	.db	%00011000
	.db	%00100000
	.db	%01010011
	.db	%00100001
	.db	%00101010
	.db	%00010000
	.db	%10110001
	.db	%00010000
	.db	%00101010
	.db	%00011000
	.db	%00100000
	.db	%01100000
	.db	%01010011
	.db	%00001000
	.db	%00100000
	.db	%00000001
	.db	%00101101
	.db	%00000010
	.db	%00100111
 .db	 0, 3
	.db	%00100100
	.db	%00011111
	.db	%00011011
	.db	%00101000
	.db	%00100001
	.db	%00101000
	.db	%00100001
	.db	%00101000
	.db	%00011000
	.db	%00010101
	.db	%00011001
	.db	%00010000
	.db	%01111000
	.db	%10011000
	.db	%00101000
	.db	%00100000
	.db	%00011000
	.db	%00101000
	.db	%00011010
	.db	%00101000
	.db	%01000000
	.db	%00101001
	.db	%01001000
	.db	%00101000
	.db	%00010001
	.db	%00011000
	.db	%01000000
	.db	%00011001
	.db	%00101000
	.db	%00100000
	.db	%00010110
	.db	%00101001
	.db	%00010000
	.db	%00011001
	.db	%00010100
	.db	%00101000
	.db	%00100000
	.db	%00011100
	.db	%00101000
	.db	%01001000
	.db	%00011000
	.db	%10011000
	.db	%01110000
	.db	%00011000
	.db	%00010001
	.db	%00011000
	.db	%00010000
	.db	%00101000
	.db	%00010000
	.db	%00101000
	.db	%00100101
	.db	%00011000
	.db	%00010000
	.db	%00011000
	.db	%00101000
	.db	%00010000
	.db	%00011000
	.db	%00010000
	.db	%00011001
	.db	%01000000
	.db	%00101000
	.db	%00010000
	.db	%00101111
	.db	%00010000
	.db	%00101001
	.db	%01000000
	.db	%00011000
	.db	%00010000
	.db	%00011000
	.db	%00101000
	.db	%00010000
	.db	%00110000
	.db	%00010000
	.db	%10010000
	.db	%10001000
	.db	%10100000
	.db	%00010001
	.db	%00110000
	.db	%00010000
	.db	%00110000
	.db	%00010011
	.db	%01011000
	.db	%00010000
	.db	%00011000
	.db	%00101000
	.db	%10000000
	.db	%00101010
	.db	%00011000
	.db	%01011000
	.db	%01101000
	.db	%00010000
	.db	%00111000
	.db	%00010000
	.db	%00011000
	.db	%00101000
	.db	%00011110
	.db	%01011000
	.db	%10100000
	.db	%00011010
	.db	%00101100
	.db	%00011000
	.db	%00100110
	.db	%00101000
	.db	%00011000
	.db	%00101001
	.db	%00100001
 .db	 0, 6
	.db	%00100111
	.db	%00100111
	.db	%00100011
	.db	%00011000
	.db	%00101010
	.db	%00011000
	.db	%00100111
	.db	%00100101
	.db	%00101000
	.db	%01011000
	.db	%00010000
	.db	%10011000
	.db	%00011110
	.db	%00101000
	.db	%00011000
	.db	%00101000
	.db	%00011011
	.db	%00100000
	.db	%00101000
	.db	%00010010
	.db	%00111000
	.db	%00010111
	.db	%00010010
	.db	%00111000
	.db	%00010000
	.db	%00100000
	.db	%00011000
	.db	%00101010
	.db	%00011000
	.db	%01010000
	.db	%00011100
	.db	%00101000
	.db	%01001000
	.db	%00101000
	.db	%00011111
	.db	%00011001
	.db	%01010000
	.db	%00011000
	.db	%00100010
	.db	%00101001
	.db	%00010000
	.db	%00101001
	.db	%00100010
	.db	%00010000
	.db	%01011000
	.db	%00010100
	.db	%00011000
	.db	%00100001
	.db	%00101001
	.db	%00010010
	.db	%00101001
	.db	%00100001
	.db	%00011111
	.db	%00100001
	.db	%00101000
	.db	%01010000
	.db	%00010010
	.db	%10100000
	.db	%00101000
	.db	%00100111
	.db	%00100011
	.db	%00011000
	.db	%00101100
	.db	%00011000
	.db	%00100111
	.db	%00100111
	.db	%00100100
 .db	 0, 3
	.db	%00100101
	.db	%00011000
	.db	%00101001
	.db	%00011000
	.db	%00100111
	.db	%00100110
	.db	%00101000
	.db	%01101000
	.db	%00010000
	.db	%00101000
	.db	%00100111
	.db	%00100000
	.db	%00101111
	.db	%00010000
	.db	%00101111
	.db	%00101001
	.db	%00010001
	.db	%01011000
	.db	%00010110
	.db	%00111000
	.db	%00010101
	.db	%10000000
	.db	%00010000
	.db	%00101110
	.db	%00010010
	.db	%00101111
	.db	%00101001
	.db	%01011000
	.db	%01110000
	.db	%00010010
	.db	%10010000
	.db	%00010010
	.db	%10001000
	.db	%00010011
	.db	%01011000
	.db	%10101000
	.db	%00101000
	.db	%00011001
	.db	%00101101
	.db	%00010010
	.db	%00101110
	.db	%00011000
	.db	%00100010
	.db	%00101000
	.db	%01011000
	.db	%01111000
	.db	%00010000
	.db	%10001000
	.db	%00010010
	.db	%10001000
	.db	%00010010
	.db	%01101000
	.db	%00101000
	.db	%00011000
	.db	%00100011
	.db	%00011000
	.db	%00101100
	.db	%01111000
	.db	%00101101
	.db	%00011000
	.db	%00100111
	.db	%00100001
	.db	%00011000
	.db	%00101000
	.db	%00011000
	.db	%00100111
	.db	%00100000
 .db	 0, 3
	.db	%00100010
	.db	%00011000
	.db	%00101101
	.db	%00011000
	.db	%00100010
	.db	%00011000
	.db	%00101001
	.db	%00011000
	.db	%00100011
	.db	%00101000
	.db	%01101000
	.db	%10001000
	.db	%00010011
	.db	%00101000
	.db	%00100010
	.db	%00101000
	.db	%01011000
	.db	%00010000
	.db	%00101000
	.db	%00100000
	.db	%00101101
	.db	%11000000
	.db	%00010000
	.db	%00101000
	.db	%00010000
	.db	%00101000
	.db	%00100010
	.db	%00101000
	.db	%00010001
	.db	%00101000
	.db	%00100000
	.db	%00010010
	.db	%01011000
	.db	%00010011
	.db	%00101000
	.db	%00010000
	.db	%00101010
	.db	%00011001
	.db	%00101000
	.db	%10000000
	.db	%00101000
	.db	%00100000
	.db	%00101101
	.db	%00010001
	.db	%00101000
	.db	%00010011
	.db	%00101000
	.db	%00100000
	.db	%00101000
	.db	%00010000
	.db	%00101000
	.db	%00100000
	.db	%00010001
	.db	%00111000
	.db	%00010011
	.db	%00101000
	.db	%00011000
	.db	%00010001
	.db	%00011000
	.db	%00010000
	.db	%00101010
	.db	%00010000
	.db	%00101000
	.db	%00011000
	.db	%00010000
	.db	%10011000
	.db	%00101000
	.db	%01001000
	.db	%01000000
	.db	%00101000
	.db	%00010100
	.db	%00101000
	.db	%00010101
	.db	%00101000
	.db	%00010000
	.db	%00101000
	.db	%00011000
	.db	%00010001
	.db	%00101010
	.db	%01001000
	.db	%00101010
	.db	%00011000
	.db	%01001000
	.db	%00101100
	.db	%10101000
	.db	%00101000
	.db	%10011000
	.db	%00010000
	.db	%01111000
	.db	%01011000
	.db	%00101001
	.db	%00010000
	.db	%01011000
	.db	%01110000
	.db	%10100000
	.db	%00101000
	.db	%00010000
	.db	%10001000
	.db	%10010000
	.db	%10001000
	.db	%10010000
	.db	%00010000
	.db	%00101000
	.db	%00011000
	.db	%00101011
	.db	%00011001
	.db	%00101011
	.db	%00011000
	.db	%00101101
 .db	 0, 8
	.db	%00100011
	.db	%00101111
	.db	%00101110
	.db	%00100011
	.db	%00101000
	.db	%00010011
	.db	%00111000
	.db	%00010111
	.db	%00010000
	.db	%00100011
	.db	%00101000
	.db	%00010000
	.db	%00101011
	.db	%00010001
	.db	%00101110
	.db	%00100011
	.db	%00101000
	.db	%00010000
	.db	%00101000
	.db	%00011000
	.db	%00101000
	.db	%01010001
	.db	%00101000
	.db	%00011000
	.db	%00100011
	.db	%00011001
	.db	%00100011
	.db	%00101000
	.db	%00010000
	.db	%00101001
	.db	%01010001
	.db	%00101000
	.db	%00011000
	.db	%00100011
	.db	%00011001
	.db	%00100000
	.db	%00101100
	.db	%01000000
	.db	%00101000
	.db	%01010001
	.db	%00101000
	.db	%00011000
	.db	%00100011
	.db	%00011001
	.db	%00100001
	.db	%00010111
	.db	%00101000
	.db	%00011000
	.db	%00100011
	.db	%00011001
	.db	%00100010
	.db	%01011000
	.db	%00101110
	.db	%00011000
	.db	%00100011
	.db	%00011001
	.db	%00100010
	.db	%00011000
	.db	%00010000
	.db	%00101000
	.db	%00100111
	.db	%00100001
	.db	%00011001
	.db	%00100010
	.db	%00011000
	.db	%00000000
	.db	%00101000
	.db	%00011000
	.db	%00100111
	.db	%00100000
	.db	%00011001
	.db	%00100010
	.db	%00011000
	.db	%00000001
 .db	 0, 1
	.db	%00101111
	.db	%00101111
	.db	%00101010
	.db	%00010000
	.db	%01011000
	.db	%00111000
	.db	%00010100
	.db	%10010000
	.db	%00010000
	.db	%10010000
	.db	%00010000
	.db	%01011000
	.db	%00010000
	.db	%00111000
	.db	%00010000
	.db	%11000010
	.db	%00101000
	.db	%00010000
	.db	%00101000
	.db	%00010000
	.db	%00101000
	.db	%00010000
	.db	%00101000
	.db	%00010000
	.db	%00101000
	.db	%00010000
	.db	%00101000
	.db	%00010000
	.db	%00101000
	.db	%00010000
	.db	%00101000
	.db	%01001000
	.db	%00101011
	.db	%00010000
	.db	%00101000
	.db	%00010000
	.db	%00101000
	.db	%00010000
	.db	%00101000
	.db	%00010000
	.db	%00111000
	.db	%00010000
	.db	%00101000
	.db	%00010000
	.db	%00101000
	.db	%00010000
	.db	%00101000
	.db	%00010000
	.db	%01010000
	.db	%10100000
	.db	%00101001
	.db	%00010010
	.db	%00101000
	.db	%00010000
	.db	%00101000
	.db	%00010000
	.db	%00101000
	.db	%01110000
	.db	%00101000
	.db	%00010000
	.db	%00101000
	.db	%00010000
	.db	%00101000
	.db	%00010000
	.db	%01010000
	.db	%10101000
	.db	%00101001
	.db	%01000000
	.db	%00101010
	.db	%00010000
	.db	%00110000
	.db	%00010000
	.db	%00110000
	.db	%00010000
	.db	%00110000
	.db	%00010000
	.db	%00101000
	.db	%00010000
	.db	%00101000
	.db	%01011000
	.db	%00101001
	.db	%00100000
	.db	%00011000
	.db	%00010010
	.db	%00110000
	.db	%00010000
	.db	%00101000
	.db	%00010000
	.db	%00101000
	.db	%00010000
	.db	%00101000
	.db	%00010000
	.db	%00101000
	.db	%00010000
	.db	%00101000
	.db	%00010000
	.db	%00101000
	.db	%00100001
	.db	%00101000
	.db	%00011000
	.db	%10000000
	.db	%00011000
	.db	%00101010
	.db	%00010000
	.db	%00101000
	.db	%00010000
	.db	%00011000
	.db	%00010000
	.db	%00101000
	.db	%00010000
	.db	%00011000
	.db	%00010000
	.db	%00101000
	.db	%00100001
	.db	%00011000
	.db	%00101000
	.db	%01011000
	.db	%00101000
	.db	%10111000
	.db	%01011000
	.db	%10001000
	.db	%00010000
	.db	%00101000
	.db	%00010000
	.db	%00111000
	.db	%00010000
	.db	%00101000
	.db	%00010010
	.db	%00101000
	.db	%00100001
	.db	%00000000
	.db	%00011000
	.db	%00101000
	.db	%00011000
	.db	%00101011
	.db	%00011000
	.db	%00101010
	.db	%00011000
	.db	%00101010
	.db	%00011000
	.db	%00100001
 .db	 0, 8
	.db	%00100111
	.db	%00100101
	.db	%00101000
	.db	%00100011
	.db	%00011000
	.db	%00101001
	.db	%00011000
	.db	%00100000
	.db	%00011000
	.db	%00101001
	.db	%00011000
	.db	%00100100
	.db	%00101001
	.db	%00100010
	.db	%00101000
	.db	%00100011
	.db	%00101000
	.db	%00100001
	.db	%00101000
	.db	%00100000
	.db	%00101110
	.db	%00100001
	.db	%00101000
	.db	%00100000
	.db	%00101001
	.db	%00100000
	.db	%00101000
	.db	%00100001
	.db	%00101000
	.db	%00100000
	.db	%00101111
	.db	%00100000
	.db	%00101000
	.db	%00100001
	.db	%00101000
	.db	%00100000
	.db	%00101000
	.db	%00100001
	.db	%00101000
	.db	%00100000
	.db	%00101110
	.db	%00100001
	.db	%00011000
	.db	%00101001
	.db	%00011000
	.db	%00100000
	.db	%00011000
	.db	%00101001
	.db	%00011000
	.db	%00100100
	.db	%00101001
	.db	%00100111
	.db	%00100111
	.db	%00100000
	.db	%00101000
	.db	%00100011
	.db	%00011111
	.db	%00011111
	.db	%00011010
	.db	%00010000
	.db	%01010000
	.db	%00010000
	.db	%01010000
	.db	%00010000
	.db	%01010000
	.db	%00010000
	.db	%01010000
	.db	%00010000
	.db	%01010000
	.db	%00010000
	.db	%01010000
	.db	%01011000
	.db	%01010000
	.db	%00010000
	.db	%01010000
	.db	%00010000
	.db	%01010000
	.db	%00010000
	.db	%00011111
	.db	%00011111
	.db	%00011010
 .db	 0, 8
	.db	%00101111
	.db	%00101001
	.db	%00000111
	.db	%00000000
	.db	%10011000
	.db	%01101000
	.db	%00010000
	.db	%00111000
	.db	%00010000
	.db	%00101000
	.db	%10000000
	.db	%00010000
	.db	%10101000
	.db	%00101000
	.db	%00000111
	.db	%00000000
	.db	%00101011
	.db	%00010001
	.db	%01101000
	.db	%00010000
	.db	%01111000
	.db	%00101001
	.db	%00000111
	.db	%10100000
	.db	%10001000
	.db	%00010010
	.db	%00101000
	.db	%01011000
	.db	%00010000
	.db	%01111000
	.db	%01110000
	.db	%00101000
	.db	%00011111
	.db	%00101001
	.db	%00010000
	.db	%00101000
	.db	%11000000
	.db	%00101111
	.db	%00101101
	.db	%10111000
	.db	%10010000
	.db	%00010000
	.db	%00101000
	.db	%11000000
	.db	%00101000
	.db	%00010111
	.db	%00010010
	.db	%00111000
	.db	%00010000
	.db	%00101001
	.db	%00010000
	.db	%00101000
	.db	%01010000
	.db	%00010001
	.db	%00101111
	.db	%00101011
	.db	%01011000
	.db	%00010001
	.db	%00101000
	.db	%01010000
	.db	%00101010
	.db	%00011111
	.db	%00011010
	.db	%00010010
	.db	%00101000
	.db	%01011000
	.db	%00101000
	.db	%00000111
	.db	%00000100
	.db	%00101101
	.db	%00000111
	.db	%00000100
 .db	 0, 6
	.db	%00100010
	.db	%00101000
	.db	%00100010
	.db	%00011111
	.db	%00011010
	.db	%00100011
	.db	%00101000
	.db	%00100010
	.db	%00011000
	.db	%00010000
	.db	%01010000
	.db	%00010000
	.db	%01010000
	.db	%00010000
	.db	%01010000
	.db	%00010000
	.db	%01010000
	.db	%00010000
	.db	%00011000
	.db	%00100001
	.db	%00101100
	.db	%00100000
	.db	%00011000
	.db	%01010000
	.db	%00101000
	.db	%01010000
	.db	%00101000
	.db	%01010000
	.db	%00101000
	.db	%01010000
	.db	%00101000
	.db	%01010000
	.db	%00011000
	.db	%00100010
	.db	%00101010
	.db	%00100001
	.db	%00011000
	.db	%01010000
	.db	%10110000
	.db	%01010000
	.db	%10110000
	.db	%01010000
	.db	%10110000
	.db	%01010000
	.db	%10110000
	.db	%01010000
	.db	%00011000
	.db	%00100011
	.db	%00101000
	.db	%00100010
	.db	%00011000
	.db	%01010000
	.db	%00101000
	.db	%01010000
	.db	%00101000
	.db	%01010000
	.db	%00101000
	.db	%01010000
	.db	%00101000
	.db	%01010000
	.db	%00011000
	.db	%00100000
	.db	%00011001
	.db	%00100100
	.db	%00011000
	.db	%01011000
	.db	%01010000
	.db	%00010000
	.db	%01010000
	.db	%00010000
	.db	%01010000
	.db	%00010000
	.db	%01010000
	.db	%01100000
	.db	%00011000
	.db	%00100000
	.db	%00010000
	.db	%00011110
	.db	%11000000
	.db	%00011111
	.db	%00011001
	.db	%00010000
	.db	%01011000
	.db	%00010000
	.db	%10000000
	.db	%10010011
	.db	%00010111
	.db	%11000001
	.db	%00001000
	.db	%00011111
	.db	%10111000
	.db	%00011111
	.db	%00011001
	.db	%00100110
	.db	%00011010
	.db	%00100111
	.db	%00100000
 .db	 17, 8
	.db	%00011111
	.db	%00011001
	.db	%00101000
	.db	%00011110
	.db	%00101000
	.db	%01010001
	.db	%01011000
	.db	%00010111
	.db	%00010100
	.db	%01010001
	.db	%00011000
	.db	%01010000
	.db	%00101000
	.db	%00011000
	.db	%00101000
	.db	%00011000
	.db	%00101000
	.db	%00011000
	.db	%00101010
	.db	%00011010
	.db	%00101000
	.db	%00011001
	.db	%00101000
	.db	%01010000
	.db	%00101000
	.db	%00010000
	.db	%00011000
	.db	%00101000
	.db	%00011000
	.db	%00101000
	.db	%00011000
	.db	%00010000
	.db	%01011000
	.db	%00101000
	.db	%01010001
	.db	%00010000
	.db	%00101000
	.db	%00011000
	.db	%00101000
	.db	%00011000
	.db	%00101000
	.db	%00010000
	.db	%00011000
	.db	%00010000
	.db	%00011000
	.db	%00100010
	.db	%00011000
	.db	%00010000
	.db	%00101000
	.db	%00011000
	.db	%01010000
	.db	%00101000
	.db	%00010000
	.db	%10010000
	.db	%10000000
	.db	%00010000
	.db	%00111000
	.db	%00010001
	.db	%00011000
	.db	%00010000
	.db	%00011000
	.db	%00101000
	.db	%00011000
	.db	%00101000
	.db	%00011000
	.db	%00010001
	.db	%00111000
	.db	%00010001
	.db	%00101010
	.db	%00010000
	.db	%00101000
	.db	%00010000
	.db	%00101000
	.db	%00011000
	.db	%00010000
	.db	%00011001
	.db	%01101000
	.db	%00011000
	.db	%00100000
	.db	%00101000
	.db	%01010000
	.db	%00101001
	.db	%00010001
	.db	%01101000
	.db	%11000000
	.db	%00010000
	.db	%00011000
	.db	%00010000
	.db	%00111000
	.db	%00010000
	.db	%01010000
	.db	%00101001
	.db	%00010000
	.db	%00101000
	.db	%00011000
	.db	%00101010
	.db	%00011011
	.db	%00101000
	.db	%01011000
	.db	%00011000
	.db	%00010000
	.db	%00101000
	.db	%00011000
	.db	%01010001
	.db	%00010111
	.db	%00010011
	.db	%01110000
	.db	%00011000
	.db	%00010001
	.db	%00101000
	.db	%00011010
	.db	%00101000
	.db	%00011001
	.db	%00101000
	.db	%00011110
	.db	%00101011
	.db	%00011000
 .db	 0, 6
	.db	%00101000
	.db	%00100010
	.db	%00011000
	.db	%00100110
	.db	%00101000
	.db	%00100100
	.db	%00101000
	.db	%00010000
	.db	%01010000
	.db	%00010000
	.db	%00101000
	.db	%00100001
	.db	%00101000
	.db	%00100000
	.db	%00010010
	.db	%00101000
	.db	%00010000
	.db	%01010001
	.db	%00010001
	.db	%10001000
	.db	%11000000
	.db	%00010000
	.db	%00101000
	.db	%00010100
	.db	%00101000
	.db	%00010000
	.db	%00101000
	.db	%00010000
	.db	%00101000
	.db	%00010000
	.db	%00101000
	.db	%00100010
	.db	%00101001
	.db	%00010000
	.db	%00100000
	.db	%00010000
	.db	%10011000
	.db	%00011000
	.db	%00101000
	.db	%00010010
	.db	%00101000
	.db	%00010000
	.db	%10101000
	.db	%00010000
	.db	%00101000
	.db	%00010001
	.db	%01011000
	.db	%10111000
	.db	%00011000
	.db	%00010000
	.db	%00100000
	.db	%00010000
	.db	%00101000
	.db	%01010000
	.db	%00010000
	.db	%00101000
	.db	%00010000
	.db	%00101000
	.db	%00100000
	.db	%00010010
	.db	%00101000
	.db	%00010000
	.db	%00101000
	.db	%00011001
	.db	%00101000
	.db	%00010000
	.db	%00101000
	.db	%00010000
	.db	%00101000
	.db	%00100000
	.db	%00010000
	.db	%00101000
	.db	%00010000
	.db	%00100000
	.db	%00101000
	.db	%01001000
	.db	%00101001
	.db	%00100000
	.db	%00010000
	.db	%00100000
	.db	%01011000
	.db	%01110000
	.db	%00011000
	.db	%00010000
	.db	%01011000
	.db	%10000000
	.db	%00101000
	.db	%01010000
	.db	%00010010
	.db	%00100000
	.db	%01010000
	.db	%00010000
	.db	%00101000
	.db	%00100000
	.db	%00011000
	.db	%00010000
	.db	%00100000
	.db	%00010000
	.db	%00011000
	.db	%00101000
	.db	%00010000
	.db	%00101000
	.db	%01011000
	.db	%00101001
	.db	%00010000
	.db	%00101000
	.db	%00010000
	.db	%00101000
	.db	%01010000
	.db	%00101000
	.db	%00010011
	.db	%00011000
	.db	%00010000
	.db	%00100001
	.db	%00010000
	.db	%00110000
	.db	%00010000
	.db	%10010000
	.db	%01011000
	.db	%00010000
	.db	%00101000
	.db	%00010000
	.db	%01010001
	.db	%00010001
	.db	%00101000
	.db	%00010001
	.db	%10000000
	.db	%00010000
	.db	%00101000
	.db	%00100000
	.db	%00101000
	.db	%00100001
	.db	%00101000
	.db	%00011000
	.db	%00101000
	.db	%00011000
	.db	%00101000
	.db	%00100111
	.db	%00101000
	.db	%00100001
 .db	 0, 1
	.db	%00011111
	.db	%00011111
	.db	%00011010
	.db	%00010111
	.db	%00010100
	.db	%01011000
	.db	%00010100
	.db	%00011111
	.db	%00011111
	.db	%00011010
	.db	%00100111
	.db	%00100111
	.db	%00100011
	.db	%00011000
	.db	%00101001
	.db	%00100000
	.db	%00101000
	.db	%00100010
	.db	%00011000
	.db	%00101001
	.db	%00100000
	.db	%00011000
	.db	%00100010
	.db	%00011000
	.db	%00100001
	.db	%00101000
	.db	%00100010
	.db	%00101000
	.db	%00100010
	.db	%00101000
	.db	%00100010
	.db	%00101000
	.db	%00011000
	.db	%00100000
	.db	%00011000
	.db	%00101000
	.db	%00100001
	.db	%00101001
	.db	%00011000
	.db	%00100000
	.db	%00101000
	.db	%00100010
	.db	%00101001
	.db	%00011000
	.db	%00100000
	.db	%00011000
	.db	%00100000
	.db	%00101000
	.db	%00100000
	.db	%00011000
	.db	%00100001
	.db	%00101000
	.db	%00100010
	.db	%00101000
	.db	%00100010
	.db	%00101000
	.db	%00100010
	.db	%00101000
	.db	%00100010
	.db	%00101000
	.db	%00100001
	.db	%00011000
	.db	%00101001
	.db	%00100000
	.db	%00011000
	.db	%00101001
	.db	%00100000
	.db	%00011000
	.db	%00101001
	.db	%00100000
	.db	%00101000
	.db	%00100010
	.db	%00101000
	.db	%00100111
	.db	%00100111
	.db	%00100011
 .db	 0, 1
	.db	%00011111
	.db	%00011111
	.db	%00011010
	.db	%00010111
	.db	%00010111
	.db	%00010010
	.db	%00011111
	.db	%00011111
	.db	%00011010
	.db	%00100111
	.db	%00100111
	.db	%00100010
	.db	%00101001
	.db	%00100000
	.db	%00101000
	.db	%00100001
	.db	%00101000
	.db	%00100000
	.db	%00101000
	.db	%00011000
	.db	%00101000
	.db	%00011000
	.db	%00101000
	.db	%00100000
	.db	%00011000
	.db	%00101001
	.db	%00011000
	.db	%00100011
	.db	%00101001
	.db	%00100000
	.db	%00101000
	.db	%00100010
	.db	%00101000
	.db	%00100010
	.db	%00101000
	.db	%00100011
	.db	%00101000
	.db	%00011000
	.db	%00100000
	.db	%00101000
	.db	%00100000
	.db	%00101001
	.db	%00100010
	.db	%00101000
	.db	%00100010
	.db	%00011000
	.db	%00101001
	.db	%00011000
	.db	%00100011
	.db	%00101000
	.db	%00100001
	.db	%00101000
	.db	%00100010
	.db	%00101000
	.db	%00100101
	.db	%00101000
	.db	%00100000
	.db	%00101001
	.db	%00100000
	.db	%00101000
	.db	%00100001
	.db	%00101000
	.db	%00100010
	.db	%00101000
	.db	%00100010
	.db	%00011000
	.db	%00101001
	.db	%00011000
	.db	%00100111
	.db	%00100111
	.db	%00100011
 .db	 0, 1
	.db	%00011000
	.db	%00101100
	.db	%00011000
	.db	%00101011
	.db	%00011000
	.db	%00101000
	.db	%00011000
	.db	%00101010
	.db	%00011000
	.db	%00101000
	.db	%00010000
	.db	%00101000
	.db	%10111000
	.db	%00010001
	.db	%01110000
	.db	%00101000
	.db	%00011000
	.db	%00101000
	.db	%00010001
	.db	%01011000
	.db	%00011000
	.db	%00101000
	.db	%00010001
	.db	%01010000
	.db	%00010111
	.db	%10010000
	.db	%00010010
	.db	%00101011
	.db	%00010000
	.db	%00101000
	.db	%00011000
	.db	%00101001
	.db	%00010000
	.db	%00101000
	.db	%00010011
	.db	%00101000
	.db	%00010000
	.db	%00011000
	.db	%00101001
	.db	%00010000
	.db	%01010000
	.db	%00010001
	.db	%00101000
	.db	%00000010
	.db	%00010000
	.db	%00101011
	.db	%00011000
	.db	%00101000
	.db	%00010001
	.db	%01010000
	.db	%00010001
	.db	%00011000
	.db	%00101010
	.db	%00000010
	.db	%00010000
	.db	%00111000
	.db	%11000000
	.db	%00101000
	.db	%00100001
	.db	%00011000
	.db	%01111000
	.db	%00101000
	.db	%00011000
	.db	%00101000
	.db	%00011000
	.db	%00101000
	.db	%00100001
	.db	%00011000
	.db	%00000010
	.db	%00101000
	.db	%00011000
	.db	%00101000
	.db	%00011000
	.db	%00101000
	.db	%00011000
	.db	%00101010
	.db	%10011000
	.db	%00101000
	.db	%00100010
	.db	%00101001
	.db	%00000010
	.db	%00100011
	.db	%00011000
	.db	%11000000
	.db	%00111000
	.db	%00010001
	.db	%01011000
	.db	%00011000
	.db	%00100000
	.db	%00101000
	.db	%00011000
	.db	%00101000
	.db	%00000011
	.db	%00100011
	.db	%00101011
	.db	%00010000
	.db	%10000000
	.db	%00101000
	.db	%00011000
	.db	%00101000
	.db	%00000101
	.db	%00100110
	.db	%00011000
	.db	%00101010
	.db	%00000111
 .db	 0, 1
	.db	%00011000
	.db	%00101110
	.db	%00100111
	.db	%00100010
	.db	%00010001
	.db	%00111000
	.db	%11000000
	.db	%00101000
	.db	%00000001
	.db	%00101001
	.db	%00100111
	.db	%00100001
	.db	%00101001
	.db	%00011000
	.db	%00101001
	.db	%00000010
	.db	%00101001
	.db	%00100011
	.db	%00011000
	.db	%00100111
	.db	%00011000
	.db	%00000011
	.db	%00101000
	.db	%00011000
	.db	%00101000
	.db	%00100111
	.db	%00100010
	.db	%00101001
	.db	%00000100
	.db	%00101000
	.db	%00100111
	.db	%00100010
	.db	%00101000
	.db	%00000101
	.db	%00101010
	.db	%00011000
	.db	%00101000
	.db	%00100010
	.db	%00011000
	.db	%00100010
	.db	%00101000
	.db	%00011000
	.db	%00101000
	.db	%00000001
	.db	%00101001
	.db	%00011000
	.db	%00101000
	.db	%00000001
	.db	%00101000
	.db	%00100111
	.db	%00100000
	.db	%00101001
	.db	%00000001
	.db	%00101001
	.db	%00000001
	.db	%00011000
	.db	%00101001
	.db	%00011000
	.db	%00101000
	.db	%00100100
	.db	%00011000
	.db	%00100000
	.db	%00101101
	.db	%00000000
	.db	%00101000
	.db	%11000000
	.db	%00111000
	.db	%00010001
	.db	%00100111
	.db	%00100011
	.db	%00101010
	.db	%00011000
	.db	%00101010
 .db	 0, 8
	.db	%00011000
	.db	%00101000
	.db	%00011000
	.db	%00101000
	.db	%00011000
	.db	%00101000
	.db	%00011000
	.db	%00101000
	.db	%00011000
	.db	%00101000
	.db	%00011000
	.db	%00101000
	.db	%00011000
	.db	%00101000
	.db	%00011000
	.db	%00101000
	.db	%00011000
	.db	%00101000
	.db	%00011000
	.db	%01101000
	.db	%01011000
	.db	%10010000
	.db	%00010001
	.db	%00011000
	.db	%00101000
	.db	%00011000
	.db	%00010111
	.db	%00010001
	.db	%00101000
	.db	%00011000
	.db	%00101000
	.db	%00011000
	.db	%00101000
	.db	%00010000
	.db	%10011000
	.db	%00010000
	.db	%00101000
	.db	%01000000
	.db	%00011000
	.db	%00101000
	.db	%00011000
	.db	%11000000
	.db	%00011000
	.db	%00101000
	.db	%00011000
	.db	%00101000
	.db	%01111000
	.db	%00100000
	.db	%10000000
	.db	%00010011
	.db	%00011000
	.db	%00010010
	.db	%01011000
	.db	%00010000
	.db	%00101000
	.db	%00010011
	.db	%00011000
	.db	%00010000
	.db	%00101000
	.db	%01011000
	.db	%00101001
	.db	%00010000
	.db	%00011000
	.db	%00101000
	.db	%00010000
	.db	%00101000
	.db	%00011000
	.db	%00101000
	.db	%00010000
	.db	%00011000
	.db	%00010011
	.db	%00101000
	.db	%00010000
	.db	%00100000
	.db	%00011001
	.db	%00010010
	.db	%00011000
	.db	%00010000
	.db	%00011000
	.db	%10111000
	.db	%00011000
	.db	%00010000
	.db	%00101000
	.db	%00010011
	.db	%00011000
	.db	%00010000
	.db	%00101000
	.db	%11000000
	.db	%00110000
	.db	%00010000
	.db	%00011000
	.db	%00010000
	.db	%00101000
	.db	%00010010
	.db	%00011000
	.db	%00010000
	.db	%00011000
	.db	%01100000
	.db	%01010001
	.db	%01011000
	.db	%00101000
	.db	%00010000
	.db	%00100000
	.db	%00011000
	.db	%00101000
	.db	%00011000
	.db	%00101000
	.db	%00010000
	.db	%00011000
	.db	%00101000
	.db	%00011000
	.db	%00010000
	.db	%00101000
	.db	%01000000
	.db	%00101000
	.db	%11000000
	.db	%00101000
	.db	%00011000
	.db	%00101000
	.db	%00011000
	.db	%00010000
	.db	%00101000
	.db	%00010000
	.db	%01011000
	.db	%00010010
	.db	%00101000
	.db	%11000000
	.db	%00111000
	.db	%00010000
	.db	%00011000
	.db	%00010010
	.db	%01110000
	.db	%01011000
	.db	%10011000
	.db	%00101000
	.db	%00010000
	.db	%10001000
	.db	%00101000
	.db	%00011000
	.db	%00101000
	.db	%00011000
	.db	%00101000
	.db	%00011000
	.db	%00101000
	.db	%00011000
	.db	%00101001
	.db	%00011000
	.db	%00101000
	.db	%00011000
	.db	%00101000
	.db	%00011000
	.db	%00101000
	.db	%00011001
	.db	%00101000
 .db	 0, 8
	.db	%00100111
	.db	%00100111
	.db	%00100111
	.db	%00101000
	.db	%00011000
	.db	%00101000
	.db	%00011000
	.db	%00101000
	.db	%00011000
	.db	%00100111
	.db	%00100100
	.db	%00011000
	.db	%11000000
	.db	%00111000
	.db	%00010000
	.db	%00001000
	.db	%00101000
	.db	%00100111
	.db	%00100100
	.db	%00101000
	.db	%00011000
	.db	%00101000
	.db	%00011000
	.db	%00101000
	.db	%00011000
	.db	%00100111
	.db	%00100111
	.db	%00100111
	.db	%00100111
	.db	%00100111
	.db	%00100111
	.db	%00100111
	.db	%00100111
	.db	%00100000
	.db	%00011000
	.db	%00101000
	.db	%00011000
	.db	%00101000
	.db	%00011000
	.db	%00101000
	.db	%00011000
	.db	%00101000
	.db	%00011000
	.db	%00101000
	.db	%00011000
	.db	%00101000
	.db	%00011000
	.db	%00101000
	.db	%00011000
	.db	%00101000
	.db	%00011000
	.db	%00101000
	.db	%00011000
	.db	%00010111
	.db	%00010011
	.db	%01011000
	.db	%00010010
	.db	%00111000
	.db	%11000000
	.db	%00101000
	.db	%00011000
	.db	%00101000
	.db	%00011000
	.db	%00101000
	.db	%00011000
	.db	%00101000
	.db	%00011000
	.db	%00101000
	.db	%00011000
	.db	%00101000
	.db	%00011000
	.db	%00101000
	.db	%00011000
	.db	%00101000
	.db	%00011000
	.db	%00101000
	.db	%00011000
	.db	%00101000
	.db	%00011000

highScore:
	.dw	0

highLevel:
	.db	0

.end
