;Concentration v1.0 for Ash v3.0
;Doug Torrance
;ZoomLabs Software
;http://pubweb.nwu.edu/~dat927/zoomlabs

; - Ash stuff - 

	#include ti82.h
	#include keys.inc
	.org START_ADDR
	.db "Concentration "
Version:
	.db "v1.0",0

; - Variables - 

SaveXY = TEXT_MEM
x = TEXT_MEM+2
y = TEXT_MEM+3
WhichAttempt = TEXT_MEM+4
LastCard = TEXT_MEM+5
Board = TEXT_MEM+6
ActiveBoard = TEXT_MEM+26
Tries = TEXT_MEM+46
NumberOfMatches = TEXT_MEM+47
SaveActiveBoard = TEXT_MEM+48
string = TEXT_MEM+68



; - Title screen -

Beginning:
	
	ld hl,TitlePic	  			
	ld de,GRAPH_MEM
	ld bc,144
	ldir
	ld hl,GRAPH_MEM+144
	ld (hl),b
	ld bc,624
	ldir
	ROM_CALL(DISP_GRAPH)
	ld hl,CardBack
	push hl
	ld de,$1000
	call ZoomSprite
	dec hl
	dec hl
	ld de,$1002
	call ZoomSprite
	pop hl
	ld de,$1004
	call ZoomSprite
	dec hl
	dec hl
	ld de,$1006
	call ZoomSprite
	ld de,$0e06
	call DrawCursor2
	ld hl,Version
	ld de,$0c02
	ld (CURSOR_ROW),de
	ROM_CALL(D_ZT_STR)
	
	ld hl,TitleScreenInfo
	ld a,$20
	ld b,4
WriteTitleScreenInfo:
	call vputs1
	add a,7
	djnz WriteTitleScreenInfo
        ld a,(LeastTries)
	call DM_A_DECI
	
TitleLoop:
	call GET_KEY
	cp G_ENTER
	jr z,StartDrawingBoard
	sub G_2nd			;cp G_2nd
	jr z,StartDrawingBoard
	dec a				;cp G_MODE
	ret z
	ld hl,(UR_C2+1)			;make the random routine a little more random
	inc hl
	ld (UR_C2+1),hl
	jr TitleLoop

StartDrawingBoard:
	ROM_CALL(CLEARLCD)

	xor a
	ld (Tries),a
			
	ld b,63
DrawLine:
	ld d,b
	ld e,10
	call ZS_SetXandY
	ld a,%01000000
	call ZS_WriteByte
	djnz DrawLine

	ld hl,Try
	ld de,83
	call vputs
	
	call SetXYtoZero

; - Shuffle cards -

	ld b,10
	ld hl,Board
	xor a
	ld d,a				;we want d=0 later for ShuffleLoop

SetUp:
	add a,22
	ld (hl),a
	inc hl
	ld (hl),a
	inc hl
	djnz SetUp

	ld hl,Board   
 	ld b,20

ShuffleLoop:
	push bc
	push hl
UR_C1:					;thanks to Dines Justesen for random routine
    	ld a,$a6
UR_C2:
   	ld hl,$8243
  	dec h
	inc l 
	add a,(hl) 
	ld (UR_C2+1),hl    
	rlca  
	rlca   
	sub h   
	add a,l   
	ld (UR_C1+1),a  
	srl a  
	pop hl 
	
	and %1111
	ld e,a
	ld a,(hl)
	push hl
	ld hl,Board
	add hl,de
	ld b,(hl)
	ld (hl),a
	pop hl
	ld a,b
	ld (hl),a
	inc hl
	pop bc
	djnz ShuffleLoop

	ld b,20
	ld hl,ActiveBoard
SetActiveBoardToZero:
	ld (hl),d			;d still = 0 from above
	inc hl
	djnz SetActiveBoardToZero

	call SaveTheActiveBoard

	xor a
	ld (NumberOfMatches),a
	
StartGame:
	ld hl,SaveActiveBoard
	ld de,ActiveBoard
	call LoadTwentyIntoBCandLDIR
	
	jr StartGame3

StartGame2:
	ld hl,NumberOfMatches
	inc (hl)
	ld a,(hl)
	cp 10
	jp z,YouWon

StartGame3:	
	ld hl,Tries
	inc (hl)
	ld a,(hl)
	
	ld de,$0853
	ld (CURSOR_X),de
	call DM_A_DECI
	
	ld hl,x
	ld a,(hl)
	inc hl
	ld b,(hl)
	dec hl
	dec hl				;ld hl,SaveXY+1
	ld (hl),b
	dec hl				;ld hl,SaveXY
	ld (hl),a

	call SaveTheActiveBoard
	
	call SetXYtoZero

; - Draw Cards -  

DrawRowOfCards:
	call ConvertXYtoDE
	call DrawCard
	ld hl,x
	inc (hl)
	ld a,(hl)
	sub 5	
	jr nz,DrawRowOfCards

	ld hl,x
	ld (hl),a			;a=0 since we sub 5 instead of cp 5 above
	inc hl
	inc (hl)
	ld a,(hl)
	cp 4
	jr nz,DrawRowOfCards
	
	ld hl,SaveXY
	ld a,(hl)
	inc hl
	ld b,(hl)
	inc hl					;ld hl,x
	ld (hl),a
	inc hl
	ld (hl),b 
	

	inc hl
	ld (hl),0				;WhichAttempt = 0
	
	call DrawCursor

GameLoop:
	call GET_KEY
	dec a					;cp G_DOWN
	jr z,DownIsPressed
	dec a					;cp G_LEFT
	jr z,LeftIsPressed			
	dec a					;cp G_RIGHT
	jr z,RightIsPressed	
	dec a					;cp G_UP
	jr z,UpIsPressed
	sub 5					;cp G_ENTER
	jr z,SecondIsPressed	
	sub G_2nd-9				;cp G_2nd
	jr z,SecondIsPressed
	dec a					;cp G_MODE
	jp z,Beginning
	call LoadWhichAttemptIntoA
	cp 3
	jp z,StartGame2
	jr GameLoop

UpIsPressed:
	ld a,(y)
	or a					;cp 0
	jr z,GameLoop
	call DrawCard
	ld hl,y
	dec (hl)
	jr CheckWhichAttempt	

DownIsPressed:
	ld a,(y)
	cp 3
	jr z,GameLoop
	call DrawCard
	ld hl,y
	inc (hl)
	jr CheckWhichAttempt

RightIsPressed:
	ld a,(x)
	cp 4
	jr z,GameLoop
	call DrawCard
	ld hl,x
	inc (hl)
	jr CheckWhichAttempt

LeftIsPressed:
	ld a,(x)
	or a						;cp 0
	jr z,GameLoop
	call DrawCard
	ld hl,x
	dec (hl)
	
CheckWhichAttempt:
	call LoadWhichAttemptIntoA
	jp z,StartGame
	call DrawCursor
	jr GameLoop
	
SecondIsPressed:
	call LoadWhichAttemptIntoA
	jp z,StartGame
	call FindCardValue
	ld a,(hl)
	or a					;cp 0
	jp nz,GameLoop
	call FindLocationInBoard
	ld hl,Board
	add hl,de
	ld c,(hl)
	ld hl,ActiveBoard
	add hl,de
	ld a,(hl)
	or a					;cp 0
	call z,IncWhichAttempt
	ld (hl),c
	call DrawCard
	call DrawCursor
	call LoadWhichAttemptIntoA
	dec a					;cp 1
	call z,LoadCardIntoLastCard
	dec a					;cp 2
	call z,CompareCardWithLastCard
	jp GameLoop

YouWon:
	ld de,$0f19
	ld hl,YouWonText
	call vputs
	ld a,(Tries)
	ld hl,LeastTries
	cp (hl)
	jr nc,EndLoop
	ld de,$1710
	ld (CURSOR_X),de
	ld b,16
	ld hl,LeastTriesText
	ROM_CALL(D_LM_STR)
	ld (LeastTries),a

	ld de,0
NewInitial:
	ld hl,$0404
	ld (CURSOR_ROW),hl
	ld hl,LeastTriesBuffer
	add hl,de
	push hl
	ld hl,LeastTriesBuffer-1
	call WriteLetter
	pop hl
	push hl
	ld a,e
	or a
	call z,HighlightFirstLetter
	dec a
	call z,HighlightSecondLetter
	dec a
	call z,HighlightThirdLetter
	pop hl
	
	
EnterInitials:
	push hl
	call GET_KEY
	pop hl
	cp G_2nd
	jp z,Beginning
	dec a
	jr z,EI_DownIsPressed
	dec a
	jr z,EI_LeftIsPressed
	dec a
	jr z,EI_RightIsPressed
	dec a
	jr z,EI_UpIsPressed
	cp 5
	jp z,Beginning
	jr EnterInitials

EI_UpIsPressed:
	inc (hl)
	ld a,(hl)
	cp $5b
	jr nz,NewInitial
	ld (hl),$41
	jr NewInitial

EI_DownIsPressed:
	dec (hl)
	ld a,(hl)
	cp $40
	jr nz,NewInitial
	ld (hl),$5a
	jr NewInitial

EI_RightIsPressed:
	ld a,e
	cp 3
	jr z,NewInitial
	inc e
	jr NewInitial

EI_LeftIsPressed:
	ld a,e
	or a
	jr z,EnterInitials
	dec e
	jr NewInitial
	
	
EndLoop:
	call GET_KEY
	cp G_ENTER
	jp z,Beginning
	cp G_2nd
	jp z,Beginning
	jr EndLoop	

; - Calls - 

SaveTheActiveBoard:
	ld hl,ActiveBoard
	ld de,SaveActiveBoard
LoadTwentyIntoBCandLDIR:
	ld bc,20
	ldir
	ret

LoadWhichAttemptIntoA:
	ld hl,WhichAttempt
	ld a,(hl)
	cp 2
	ret

LoadCardIntoLastCard:
	call FindCardValue
	ld a,(hl)
	ld (LastCard),a
	ret

CompareCardWithLastCard:
	call FindCardValue
	ld a,(hl)
	ld hl,LastCard
	cp (hl)
	ret nz
IncWhichAttempt:
	push hl
	ld hl,WhichAttempt
	inc (hl)
	pop hl
	ret

SetXYtoZero:
	ld hl,x
	xor a
	ld (hl),a				;x = 0
	inc hl
	ld (hl),a				;y = 0
	ret	

ConvertXYtoDE:
	ld hl,x
	ld e,(hl)
	sla e
	inc hl
	ld d,(hl)
	sla d
	sla d
	sla d
	sla d
	ret

DrawCard:
	call ConvertXYtoDE
	call EraseTwoLines
	inc d
	call LoadCardIntoHL
	call ZoomSprite
	call EraseTwoLines
	ret

LoadCardIntoHL
	push de
	call FindCardValue
	ld e,(hl)
	ld hl,CardBack
	add hl,de
	pop de
	ret

FindCardValue:
	call FindLocationInBoard
	ld hl,ActiveBoard
	add hl,de
	ret

FindLocationInBoard:				;loads offset from start of board into de
	ld a,(y)
	ld b,a
	ld a,(x)
	inc b
MultiplyTimesFive:
	add a,5
	djnz MultiplyTimesFive
	sub 5
	ld e,a
	ld d,b					;b=0 from djnz
	ret

HighlightFirstLetter:
	call WriteInvertedLetter
	inc hl
	call WriteLetterAndIncHL
WriteLetter:
	ld a,(hl)
	ROM_CALL(TX_CHARPUT)
	ret
	
HighlightSecondLetter:
	dec hl
	call WriteLetterAndIncHL
	call WriteInvertedLetter
	inc hl
WriteLetterAndIncHL:
	call WriteLetter
	inc hl
	ret

HighlightThirdLetter:
	dec hl
	dec hl
	call WriteLetterAndIncHL
	call WriteLetterAndIncHL
	call WriteInvertedLetter
	inc hl
	inc hl
	ret

WriteInvertedLetter:
	set 3,(iy+5)
	call WriteLetter
	res 3,(iy+5)
	ret

ZoomSprite:	
	ld b,12

ZS_Draw:	
	call ZS_DrawByte
	inc e
	inc hl
	call ZS_DrawByte
	inc d
	dec e
	inc hl
	djnz ZS_Draw
	ret

ZS_SetXandY:
	ld a,$20
	add a,e
	call $7f3
	out ($10),a
	ld a,$80
	add a,d
	call $7f3
	out ($10),a
	ret

ZOS_DrawByte:
	call ZS_SetXandY
	call $7f3
	in a,($11)
	call $7f3
	in a,($11)
	xor c
	ld c,a
	call ZS_SetXandY
	ld a,c
	jr ZS_WriteByte
	
ZS_DrawByte:
	call ZS_SetXandY
	ld a,(hl)
	
ZS_WriteByte:
	call $7f3
	out ($11),a
	ret

EraseTwoLines:
	call EraseOneByte
	inc e
	call EraseOneByte
	dec e
	inc d
	call EraseOneByte
	inc e
	call EraseOneByte
	dec e

EraseOneByte:
	call ZS_SetXandY
	xor a					;ld a,0
	jr ZS_WriteByte

DrawCursor:	
	call ConvertXYtoDE
DrawCursor2:
	call DrawTopOfCursor
	ld b,14
DrawMiddleOfCursor
	inc d
	dec e
	ld c,%10000000
	call ZOS_DrawByte
	inc e
	ld c,%00000001
	call ZOS_DrawByte
	djnz DrawMiddleOfCursor
	inc d
	dec e	
DrawTopOfCursor:
	call DrawFF
	inc e		
DrawFF:
	call ZS_SetXandY
	ld a,$ff
	call ZS_WriteByte
	ret
	
;--- Jimmy Mardell's DM_HL_DECI Code--tweaked a little bit, displays a instead of hl
DM_A_DECI:
	ld l,a
 	ld de, string+5
	xor a
	ld h,a
	ld (de), a
DM_A_DECI_Repeat:
	call UNPACK_HL
	add a, '0'
	dec de
	ld (de), a
	ld a, h
	or l
	jr nz, DM_A_DECI_Repeat
	ex de, hl
	jr vputs2

vputs1:
	ld d,a
vputs:
	ld (CURSOR_X),de
vputs2:	
	ROM_CALL(D_ZM_STR)
	ret

; - Strings -


TitleScreenInfo:	
	.db "Doug Torrance",0
	.db "ZoomLabs Software",0
	.db "profzoom@hotmail.com",0
LeastTriesText:
	.db "Least # of Tries - "

LeastTriesBuffer:
	.db "DAT - ",0

LeastTries:
	.db 99

Try:
	.db "Try",0

YouWonText:
	.db "You won!",0

; - Sprites - 

TitlePic:
	.db $0F,$40,$00,$00,$00,$00,$00,$00,$00,$04,$00,$00
	.db $30,$C0,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
	.db $60,$40,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
	.db $60,$00,$00,$00,$00,$00,$06,$00,$01,$00,$00,$00
	.db $C0,$03,$86,$E1,$C3,$CD,$CF,$6C,$F3,$CC,$38,$6E
	.db $C0,$04,$66,$66,$64,$CE,$66,$31,$19,$0C,$46,$66
	.db $C0,$08,$66,$24,$2C,$EC,$66,$21,$19,$0C,$86,$62
	.db $C0,$08,$66,$24,$0C,$0C,$66,$20,$79,$0C,$86,$62
	.db $E0,$08,$26,$24,$0C,$0C,$66,$21,$99,$0C,$82,$62
	.db $60,$0C,$66,$26,$0C,$0C,$66,$21,$19,$0C,$C6,$62
	.db $30,$4C,$66,$27,$26,$4C,$66,$21,$19,$0C,$C6,$62
	.db $1F,$86,$C6,$73,$C7,$CC,$67,$71,$FD,$CC,$6C,$67


CardBack:
	.db %00011111,%11111000
	.db %00101010,%10101100
	.db %00110101,%01010100
	.db %00101010,%10101100
	.db %00110101,%01010100
	.db %00101010,%10101100
	.db %00110101,%01010100
	.db %00101010,%10101100
	.db %00110101,%01010100
	.db %00101010,%10101100
	.db %00110101,%01010100
	
WhiteSquare:
	.db %00011111,%11111000
	.db %00100000,%00000100
	.db %00100000,%00000100
	.db %00100111,%11100100
	.db %00100100,%00100100
	.db %00100100,%00100100
	.db %00100100,%00100100
	.db %00100100,%00100100
	.db %00100111,%11100100
	.db %00100000,%00000100
	.db %00100000,%00000100
	
BlackSquare:
	.db %00011111,%11111000
	.db %00100000,%00000100
	.db %00100000,%00000100
	.db %00100111,%11100100
	.db %00100111,%11100100
	.db %00100111,%11100100
	.db %00100111,%11100100
	.db %00100111,%11100100
	.db %00100111,%11100100
	.db %00100000,%00000100
	.db %00100000,%00000100
	
WhiteCross:
	.db %00011111,%11111000
	.db %00100000,%00000100
	.db %00100011,%11000100
	.db %00100010,%01000100
	.db %00101110,%01110100
	.db %00101000,%00010100
	.db %00101000,%00010100
	.db %00101110,%01110100
	.db %00100010,%01000100
	.db %00100011,%11000100
	.db %00100000,%00000100
	
BlackCross:
	.db %00011111,%11111000
	.db %00100000,%00000100
	.db %00100011,%11000100
	.db %00100011,%11000100
	.db %00101111,%11110100
	.db %00101111,%11110100
	.db %00101111,%11110100
	.db %00101111,%11110100
	.db %00100011,%11000100
	.db %00100011,%11000100
	.db %00100000,%00000100
	
HappyFace:
	.db %00011111,%11111000
	.db %00100000,%00000100
	.db %00100000,%00000100
	.db %00100010,%01000100
	.db %00100010,%01000100
	.db %00100000,%00000100
	.db %00101000,%00010100
	.db %00100111,%11100100
	.db %00100011,%11000100
	.db %00100000,%00000100
	.db %00100000,%00000100
	
SadFace:
	.db %00011111,%11111000
	.db %00100000,%00000100
	.db %00100000,%00000100
	.db %00100010,%01000100
	.db %00100010,%01000100
	.db %00100000,%00000100
	.db %00100000,%00000100
	.db %00100111,%11100100
	.db %00101000,%00010100
	.db %00100000,%00000100
	.db %00100000,%00000100
	
WhiteDiamond:
	.db %00011111,%11111000
	.db %00100000,%00000100
	.db %00100001,%10000100
	.db %00100010,%01000100
	.db %00100100,%00100100
	.db %00101000,%00010100
	.db %00101000,%00010100
	.db %00100100,%00100100
	.db %00100010,%01000100
	.db %00100001,%10000100
	.db %00100000,%00000100
	
BlackDiamond:	
	.db %00011111,%11111000
	.db %00100000,%00000100
	.db %00100001,%10000100
	.db %00100011,%11000100
	.db %00100111,%11100100
	.db %00101111,%11110100
	.db %00101111,%11110100
	.db %00100111,%11100100
	.db %00100011,%11000100
	.db %00100001,%10000100
	.db %00100000,%00000100
	
Bowtie:
	.db %00011111,%11111000
	.db %00100000,%00000100
	.db %00101000,%00010100
	.db %00101100,%00110100
	.db %00101110,%01110100
	.db %00101111,%11110100
	.db %00101111,%11110100
	.db %00101110,%01110100
	.db %00101100,%00110100
	.db %00101000,%00010100
	.db %00100000,%00000100
	
Hourglass:
	.db %00011111,%11111000
	.db %00100000,%00000100
	.db %00101111,%11110100
	.db %00100111,%11100100
	.db %00100011,%11000100
	.db %00100001,%10000100
	.db %00100001,%10000100
	.db %00100011,%11000100
	.db %00100111,%11100100
	.db %00101111,%11110100
	.db %00100000,%00000100
	.db %00011111,%11111000
		
.end
	