/*
 * Unity utilities library
 *
 * Copyright (c) 2010 Benjamin Moody <floppusmaximus@users.sf.net>
 *
 * This program is free software: you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdarg.h>
#include "utils.h"

void* xrealloc(void* p, unsigned long sz)
{
  if (sz) {
    if (p)
      p = realloc(p, sz);
    else
      p = malloc(sz);
    if (!p) {
      fprintf(stderr, "Out of memory (need %lu bytes)\n", sz);
      abort();
    }
  }
  else {
    if (p)
      free(p);
    p = 0;
  }
  return p;
}

char* xstrdup(const char* s)
{
  char* p = xmalloc(1 + strlen(s));
  strcpy(p, s);
  return p;
}

char* xstrndup(const char* s, int n)
{
  char* p = xmalloc(n + 1);
  strncpy(p, s, n);
  p[n] = 0;
  return p;
}

char* xstrconcat(const char *s, ...)
{
  va_list ap;
  int n, m;
  const char *s2;
  char *p;

  n = strlen(s);

  va_start(ap, s);
  while ((s2 = va_arg(ap, const char *)))
    n += strlen(s2);
  va_end(ap);

  p = xmalloc(n + 1);

  n = strlen(s);
  memcpy(p, s, n);

  va_start(ap, s);
  while ((s2 = va_arg(ap, const char *))) {
    m = strlen(s2);
    memcpy(p + n, s2, m);
    n += m;
  }
  va_end(ap);

  p[n] = 0;
  return p;
}
