/*
 * Unity utilities library
 *
 * Copyright (c) 2010 Benjamin Moody <floppusmaximus@users.sf.net>
 *
 * This program is free software: you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "prgfile.h"

int write_prg_file(FILE* outf, const char* progname,
		   const unsigned char* data1, unsigned int length1,
		   const unsigned char* data2, unsigned int length2)
{
  unsigned int sum;
  unsigned char header[12];
  unsigned char namebuff[8];
  unsigned int length = length1 + length2;
  unsigned int i;

  strncpy((char*) header, "**TI81**", 8);

  header[8] = 0;
  header[9] = 0x6e;

  header[10] = length & 0xff;
  header[11] = (length >> 8) & 0xff;

  if (fwrite(header, 1, 12, outf) != 12)
    return 1;

  for (i = 0; i < 8 && progname && progname[i]; i++) {
    if (progname[i] >= '0' && progname[i] <= '9')
      namebuff[i] = 0x10 + progname[i] - '0';
    else if (progname[i] >= 'A' && progname[i] <= 'Z')
      namebuff[i] = 0x59 + progname[i] - 'A';
    else if (progname[i] >= 'a' && progname[i] <= 'z')
      namebuff[i] = 0x59 + progname[i] - 'a';
    else if (progname[i] == '@')
      namebuff[i] = 0x73;
    else
      namebuff[i] = 0x1A;
  }

  for (; i < 8; i++) {
    namebuff[i] = 0x56;
  }

  if (fwrite(namebuff, 1, 8, outf) != 8)
    return 1;

  if (length1 != 0 && fwrite(data1, 1, length1, outf) != length1)
    return 1;

  if (length2 != 0 && fwrite(data2, 1, length2, outf) != length2)
    return 1;

  sum = 0;
  for (i = 0; i < 8; i++)
    sum += namebuff[i];
  for (i = 0; i < length1; i++)
    sum += data1[i];
  for (i = 0; i < length2; i++)
    sum += data2[i];

  if (fputc(sum & 0xff, outf) == EOF
      || fputc((sum >> 8) & 0xff, outf) == EOF)
    return 1;
  else
    return 0;
}
