/*
 * Kernel packing tool
 *
 * Copyright (c) 2010 Benjamin Moody <floppusmaximus@users.sf.net>
 *
 * This program is free software: you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#include <stdio.h>

static void putbyte(FILE* f, int c)
{
  fputc(((c >> 4) & 0xf) + 0x60, f);
  fputc((c & 0xf) + 0x60, f);
}

int main()
{
  FILE *infile, *outfile;
  int c;
  int sum = 0;

  infile = fopen("kernel.bin", "rb");
  if (!infile) {
    perror("kernel.bin");
    return 1;
  }

  outfile = fopen("kpacked.bin", "wb");
  if (!outfile) {
    perror("kpacked.bin");
    return 1;
  }  

  while ((c = fgetc(infile)) != EOF) {
    sum ^= c;
    putbyte(outfile, c);
  }

  putbyte(outfile, sum);

  fclose(infile);
  fclose(outfile);

  return 0;
}
