;;; -*- TI-Asm -*-

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;
;;;  Unity - assembly program loader for the TI-81
;;;
;;;  Copyright (c) 2010 Benjamin Moody
;;;
;;;  This program is free software: you can redistribute it and/or
;;;  modify it under the terms of the GNU General Public License as
;;;  published by the Free Software Foundation, either version 3 of
;;;  the License, or (at your option) any later version.
;;;
;;;  This program is distributed in the hope that it will be useful,
;;;  but WITHOUT ANY WARRANTY; without even the implied warranty of
;;;  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
;;;  General Public License for more details.
;;;
;;;  You should have received a copy of the GNU General Public License
;;;  along with this program.  If not, see
;;;  <http://www.gnu.org/licenses/>.
;;; 
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

	.nolist
	.include <ti81.inc>
	.list

	.include "kernel.exp"

	.org $E474		; scratchMem + 5 on new OSes; part of
				; plotSScreen on 1.1K (note: if you
				; change this, don't forget to update
				; the Makefile)

	;; install interrupt
	ld a,$D4
	ld i,a
	ld h,a
	ld d,a
	ld l,0
	ld e,1
	ld b,e
	ld c,l
	ld (hl),$D3
	ldir

	;; allocate program memory (note that most of the former
	;; contents of prgm0 have been overwritten; the user can
	;; safely delete what remains)
	ld hl,$F501
	ld (prgm0Start),hl

	;; Search for JError
	    ld (errNo),a
	    ld hl,(errSP)
	call romsearch
	jr nz,find_jerror_failed
	ld (PATCH_JERROR + 1),hl
	ld a,$C3
	ld (PATCH_JERROR),a	; MSB of PATCH_JERROR = D3
find_jerror_failed:

	;; Search for ReadKeyGroup
	    .db 1, 0, 0, 0, 0
	call romsearch
	jr nz,find_keyread_failed
	ld (PATCH_READ_KEY_GROUP + 2),hl
	ld hl,$CD00
	ld (PATCH_READ_KEY_GROUP),hl
find_keyread_failed:

	ld a,Lcolon
	rst 20h
	ld a,LrParen
	rst 20h
	im 2
freeze_loop:
	ei
	halt
	jr freeze_loop

romsearch:
	 ld hl,$7FFF
romsearch_restart:
	 pop de
	push de
	 dec de
	 dec de
	 dec de
	 ld b,6
romsearch_loop:
	 dec hl
	 bit 7,h
	 ret nz
	 dec de
	 ld a,(de)
	 cp (hl)
	 jr nz,romsearch_restart
	 djnz romsearch_loop
	 ret
