;;; -*- TI-Asm -*-

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;
;;;  Unity - assembly program loader for the TI-81
;;;
;;;  Copyright (c) 2010 Benjamin Moody
;;;
;;;  This program is free software: you can redistribute it and/or
;;;  modify it under the terms of the GNU General Public License as
;;;  published by the Free Software Foundation, either version 3 of
;;;  the License, or (at your option) any later version.
;;;
;;;  This program is distributed in the hope that it will be useful,
;;;  but WITHOUT ANY WARRANTY; without even the implied warranty of
;;;  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
;;;  General Public License for more details.
;;;
;;;  You should have received a copy of the GNU General Public License
;;;  along with this program.  If not, see
;;;  <http://www.gnu.org/licenses/>.
;;; 
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

	.nolist
	.include <ti81.inc>
	.list

	.org equMem + 6 - $2000 - 1
	.db tQuote

finish:	
	ld (hl),$18

	ld a,$D4
patch_ld_i_a:
	;; LD I, A = ED 47
	.db $12, $47		; CODEPATCH

patch_im_2:
	;; IM 2 = ED 5E
	.db $12, $5E

	ld a,'*'
patch_rst:
	;; RST 20h = E7
	.db $E3			; CODEPATCH

wait_loop:
	halt
	jp wait_loop

	.if $ != $DCDC
	.error "code misaligned"
	.endif

	;; patch LD I,A
	ld hl,patch_ld_i_a
	ld a,(hl)		; A = $ED
	cpl
	ld (hl),a
	;; patch IM 2
	ld (patch_im_2),a

	;; patch RST
	ld hl,patch_rst
	set 2,(hl)

	;; set shift2nd flag
	ld hl,flags + shiftFlags + $10
	res 4,l
	jr finish

	.db tQuote, tStore, tY2, tEnter

	;; Additional stuff needed for setup

	.db tQuote, tPtOn, tQuote, tStore, tY3T, tEnter

	.db tQuote, tLParen, tChs, t1, tRParen, tPower, tPi, tQuote, tStore, tY1, tEnter

	.db t0, tStore, tX
