;;; -*- TI-Asm -*-

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;
;;;  Hex Editor for the TI-81
;;;
;;;  Copyright (c) 2010 Benjamin Moody
;;;
;;;  This program is free software: you can redistribute it and/or
;;;  modify it under the terms of the GNU General Public License as
;;;  published by the Free Software Foundation, either version 3 of
;;;  the License, or (at your option) any later version.
;;;
;;;  This program is distributed in the hope that it will be useful,
;;;  but WITHOUT ANY WARRANTY; without even the implied warranty of
;;;  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
;;;  General Public License for more details.
;;;
;;;  You should have received a copy of the GNU General Public License
;;;  along with this program.  If not, see
;;;  <http://www.gnu.org/licenses/>.
;;; 
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

	.nolist
	.include <ti81.inc>
	.list

	.org tempMatrix

	ROM_CALL ClrScrn
redisp:
	ROM_CALL HomeUp
top_addr .equ $ + 1
	ld de,0
	ld c,4
redisp_loop:
	ld a,d
	call disphex2
	ld a,e
	call disphex2
	ld b,4
redisp_line:
	ld a,(de)
	inc (iy + curRow_off)
	and $7F
	ROM_CALL PutC
	dec (iy + curRow_off)
	ld a,(de)
	call disphex2
	inc de
	djnz redisp_line
	inc (iy + curRow_off)
	dec c
	jr nz,redisp_loop
	ld hl,$500
	ld (curRow),hl
key_loop:
	res onInterrupt,(iy + onFlags)
	ROM_CALL CursorOn
	ROM_CALL GetKey
	ROM_CALL CursorOff
	ld hl,(top_addr)
	inc hl
	dec a
	jr z,go_addr
	dec hl
	dec hl
	dec a
	jr z,go_addr
	dec hl
	dec hl
	dec hl
	dec a
	jr z,go_addr
	ld bc,8
	add hl,bc
	dec a
	jr z,go_addr
	cp kClear-kDown
	ret z
	cp kG-kDown
	jr nz,no_input_addr
	ROM_CALL HomeUp
	ld hl,1
	call gethex
	jr nc,redisp
	or l
	ld l,a
go_addr:
	ld (top_addr),hl
	jr redisp

no_input_addr:
	add a,kDown-k0
	ld h,1
	call gethexinit
	jr nc,redisp
	or l
	ld hl,(top_addr)
	ld (hl),a
	jr go_addr

gethex:
	push hl
	 ROM_CALL CursorOn
	 ROM_CALL GetKey
	 ROM_CALL CursorOff
	 sub k0
	 pop hl
gethexinit:
	cp 10
	jr c,gethex_ok
	sub kA - k9 - 1
	ccf
	ret nc
	cp 16
	ret nc
gethex_ok:
	add hl,hl
	add hl,hl
	add hl,hl
	add hl,hl
	ret c
	or l
	ld l,a
	set textInverse,(iy + textFlags)
	call disphex1
	res textInverse,(iy + textFlags)
	jr gethex

disphex2:
	push af
	 ROM_CALL ShRAcc
	 call disphex1
	 pop af
disphex1:
	and $0F
	add a,L0
	cp L9 + 1
	jr c,disphex1_ok
	add a,LcapA - L9 - 1
disphex1_ok:
	ROM_CALL PutC
	ret

	
