;;; -*- TI-Asm -*-

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;
;;;  Micro-Hangman for the TI-81
;;;
;;;  Copyright (c) 2010 Benjamin Moody
;;;
;;;  This program is free software: you can redistribute it and/or
;;;  modify it under the terms of the GNU General Public License as
;;;  published by the Free Software Foundation, either version 3 of
;;;  the License, or (at your option) any later version.
;;;
;;;  This program is distributed in the hope that it will be useful,
;;;  but WITHOUT ANY WARRANTY; without even the implied warranty of
;;;  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
;;;  General Public License for more details.
;;;
;;;  You should have received a copy of the GNU General Public License
;;;  along with this program.  If not, see
;;;  <http://www.gnu.org/licenses/>.
;;; 
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

	.nolist
	.include <ti81.inc>
	.list

	.org plotSScreen

pick_again:
	;; Clear screen and textShadow
	ROM_CALL ClrScrn

	;; Pick a random string
	ROM_CALL Random
	ld hl,OP1 + 2
	ld a,r
	rlca
	xor (hl)

	ld hl,_tokenStrings
	ROM_CALL FindNthFlagStr
	ld (secret_string),hl

	ld hl,guess_string
	call display_message_place_secret_cursor
	;; B = 1

	;; Display string, changing letters to underscores
show_underscores_loop:
	ld a,(hl)
	and 7Fh
	cp LcapA
	jr c,show_underscores_not_letter
	cp Ly + 1
	jr nc,show_underscores_not_letter
	ld a,LcurI
	inc b
show_underscores_not_letter:
	ROM_CALL PutC
	bit 7,(hl)
	inc hl
	jr z,show_underscores_loop

	;; if string does not contain enough letters to be
	;; interesting, try again with a different string
	ld a,b
	cp 4
	jr c,pick_again

	ld hl,gallows_pieces
	ld b,5
	call draw_polyline

	ROM_CALL SetAlphaLock

game_loop:
	;; Main game loop
	ld a,LcurI
	call search_for_char
	jr z,game_key_loop
	ld hl,win_string
finish_game:
	call display_message_place_secret_cursor
	ROM_CALL PutFlagStr
	ROM_CALL GetKey
	jp _ClrWindow

game_key_loop:
	call place_guess_cursor
	res onInterrupt,(iy + onFlags)
	ROM_CALL CursorOn
	ROM_CALL GetKey
	ROM_CALL CursorOff
	cp kClear
	jr z,game_over
	cp kA
	jr c,game_loop
	cp kTheta + 1
	jr nc,game_key_loop

	;; Translate to uppercase letter
	add a,LcapA - kA

	;; Check if letter has already been guessed
	call search_for_char
	jr z,game_key_loop

	;; Translate to lowercase letter if possible
	call to_lower
	ld e,a

	call place_secret_cursor
	;; B = 1
guess_letter_loop:
	;; get next letter from our secret word
	ld a,(hl)
	and 7Fh
	;; check if it equals either the uppercase or lowercase
	;; version of the letter that was typed
	cp e
	jr z,guess_letter_good
	cp d
	jr z,guess_letter_good
	inc (iy + curCol_off)
guess_letter_next:
	cp (hl)
	inc hl
	jr z,guess_letter_loop
	;; if any letters matched, return to main loop
	djnz game_loop

	;; no letters matched -> display, add to list of bad guesses
	call place_guess_cursor
	ld a,d
	ROM_CALL PutC

	;; and add a piece to the man
	push hl
	 call draw_dude_piece
	 pop hl

	dec (hl)
	jr nz,game_key_loop
game_over:
	ld hl,lose_string
	jr finish_game

guess_letter_good:
	;; letter matches!
	ROM_CALL PutC
	inc b
	jr guess_letter_next


;;; Place the cursor at the end of the "guessed letters" area
place_guess_cursor:
	ld hl,doom_counter
	ld a,7
	sub (hl)
	ld (curCol),a
	ld (iy + curRow_off),6
	ret

;;; Display message at coords (1, 2)
display_message_place_secret_cursor:
	ld (iy + curRow_off),2
	ld (iy + curCol_off),1
	ROM_CALL PutFlagStr
;;; Place the cursor at the start of the "secret word" area
place_secret_cursor:
	ld hl,104h
	ld (curRow),hl
	ld b,h
secret_string .equ $ + 1
	ld hl,0
	ret

;;; Check if the given character is displayed anywhere on the lower
;;; half of the screen
search_for_char:
	ld hl,textShadow + 64
	ld bc,64
	cpir
	ret

;;; Draw next piece of the little chap
draw_dude_piece:
doom_counter .equ $ + 1
	ld a,6
	add a,a
	add a,a
	add a,guy_pieces % 256 - 4
	ld l,a
	ld h,guy_pieces / 256
	cp (guy_pieces + 4*5) % 256
	ld b,1
	jr nz,draw_polyline
	ld b,7
;;; Draw B lines between B+1 points, indicated in the table at HL.
draw_polyline:
	push bc
	 push hl
	  ROM_CALL LdBCHLind
	  ex de,hl
	  set plotLoc,(iy + plotFlags) ; draw to display only, not to
				       ; graph buffer
	  ROM_CALL DarkLine
	  res plotLoc,(iy + plotFlags)
	  pop hl
	 inc hl
	 inc hl
	 pop bc
	djnz draw_polyline
	ret

;;; Convert uppercase letter A to lowercase if possible.  Return D =
;;; original uppercase letter; A = lowercase letter if it exists,
;;; otherwise A = D.
to_lower:
	ld d,a
	cp LcapY + 1
	ret nc
	add a,Ll - LcapL
	cp Ll
	ret nc
	ld a,d
	cp LcapI + 1
	ret nc
	add a,La - LcapA
	ret

guy_pieces:
	.dw 5928h, 562Fh	; leg
	.dw 5328h, 562Fh	; leg
	.dw 5A2Fh, 5633h	; arm
	.dw 522Fh, 5633h	; arm
	.dw 562Eh, 5635h	; body
	.dw 5739h, 5838h, 5836h, 5735h, 5535h, 5436h, 5438h, 5539h ; head
gallows_pieces:
	.dw 5639h, 563Dh, 4A3Dh, 4A23h, 4623h, 4E23h

guess_string:
	.ascis "Guess?"
lose_string:
	.ascis "Game Over"
win_string:
	.ascis "You Win!"

