#include "ti86asm.inc"
#include "asm86.h"

.org _asm_exec_ram

ProgStart:
 call SETSCRN
 set textInverse,(iy+textflags)
 ld hl,MAIN
 ld bc,$1816
 call DISPV
 ld bc,$2810
 call DISPV
 ld bc,$3902
 call DISPV
 ld c,$1B
 call DISPV
 ld c,$36
 call DISPV
 ld c,$55
 call DISPV
 ld c,$71
 call DISPV
KEYLOOP1:
 call _getkey
 cp kF1
 jp z,START
 cp kF2
 jr z,DISCLM
 cp kF3
 jr z,ABOUT
 cp kF5
 jp z,EXIT
 cp kExit
 jp z,EXIT
 cp kF4
 jp z,HELP
 jr KEYLOOP1
 
ABOUT:
 call SETSCRN
 ld hl,ABOUTT
 ld bc,$1014
 call DISPV
 ld bc,$1A16
 call DISPV
 ld b,$23
 call DISPV
 ld b,$2B
 call DISPV
 ld b,$33
 call DISPV
 call _getkey
 jr ProgStart
  
DISCLM:
 call SETSCRN
 ld hl,DISCLAIM
 ld bc,$1014
 call DISPV
 ld hl,DISCLAIM2
 ld bc,$1A06
 call DISPV
 ld bc,$2308
 call DISPV
 ld b,$33
 call DISPV
 ld bc,$2B0A
 call DISPV
 call _getkey
 call SETSCRN
 ld hl,DISCLAIM
 ld bc,$1014
 call DISPV
 ld hl,DISCLAIM3
 ld bc,$1A06
 call DISPV
 ld b,$23
 call DISPV
 ld bc,$2B08
 call DISPV
 ld b,$33
 call DISPV
 call _getkey
 jp ProgStart

HELP:
 call SETSCRN
 ld hl,HELPT
 ld bc,$1014
 call DISPV
 ld bc,$1916
 call DISPV
 ld b,$22
 call DISPV
 ld b,$2A
 call DISPV
 ld b,$33
 call DISPV
 call _getkey
 call SETSCRN
 ld hl,HELPT2
 ld bc,$0808
 call DISPV
 ld b,$0F
 call DISPV
 ld b,$18
 call DISPV
 ld b,$1E
 call DISPV
 call _getkey
 jp ProgStart

BTEXT:
 ld bc,$0808
 call DISPV
 ld b,$0F
 call DISPV
 ld b,$18
 call DISPV
 ld b,$1E
 call DISPV
 ld b,$28
 call DISPV
 ld b,$2E
 call DISPV
 ld b,$37
 jp DISPV

DISPV:
 ld (_penCol),bc
 jp _vputs
 
SETSCRN:
 call _clrScrn
 call _homeup
 call _runindicoff
 jp gr_pic_rle
  
START:
 call SETSCRN
 ld hl,SORTT1
 ld bc,$0A18
 call DISPV
 ld bc,$1216
 call DISPV
 ld bc,$1A12
 call DISPV
 ld bc,$2228
 call DISPV
 ld bc,$2A24
 call DISPV
 call Next
 call SETSCRN
 ld hl,SORTT2
 ld bc,$0A14
 call DISPV
 ld bc,$1224
 call DISPV
 ld bc,$1A15
 call DISPV
 ld bc,$222A
 call DISPV
 call Next
 call SETSCRN
 ld hl,SORTT3
 ld bc,$0A18
 call DISPV
 ld b,$1A
 call DISPV
 ld bc,$1212
 call DISPV
 ld bc,$2223
 call DISPV
 call Next
 call SETSCRN
 ld hl,SORTT4
 ld bc,$0A18
 call DISPV
 ld b,$1A
 call DISPV
 ld bc,$121D
 call DISPV
 ld bc,$222B
 call DISPV
 call Next
 call SETSCRN
 ld hl,SORTT5
 ld bc,$0A18
 call DISPV
 ld bc,$1214
 call DISPV
 ld bc,$1A16
 call DISPV
 ld bc,$2212
 call DISPV
 call Next
 call SETSCRN
 ld hl,QUES1
 call BTEXT
 jp QKEYLP1
QUESTION2:
 call SETSCRN
 ld hl,QUES2
 call BTEXT
 jp QKEYLP2
QUESTION3:
 call SETSCRN
 ld hl,QUES3
 call BTEXT
 jp QKEYLP3
QUESTION4:
 call SETSCRN
 ld hl,QUES4
 call BTEXT
 jp QKEYLP4
QUESTION5:
 call SETSCRN
 ld hl,QUES5
 call BTEXT
 call _getkey
NOWSORT:
 call SETSCRN
 ld hl,NPSO
 ld bc,$0808
 call DISPV
 ld b,$10
 call DISPV
 ld b,$18
 call DISPV
 call _getkey
 jr SORTED
 
QKEYLP1:
 call _getky
 cp K_F1
 jr z,QUESTION2
 cp K_F2
 jr z,QUESTION2
 cp K_F3
 jr z,QUESTION2
 cp K_F4
 jr z,QUESTION2
 jr QKEYLP1

QKEYLP2:
 call _getky
 cp K_F1
 jr z,QUESTION3
 cp K_F2
 jr z,QUESTION3
 cp K_F3
 jr z,QUESTION3
 cp K_F4
 jr z,QUESTION3
 jr QKEYLP2

QKEYLP3:
 call _getky
 cp K_F1
 jr z,QUESTION4
 cp K_F2
 jr z,QUESTION4
 cp K_F3
 jr z,QUESTION4
 cp K_F4
 jr z,QUESTION4
 jr QKEYLP3

QKEYLP4:
 call _getky
 cp K_F1
 jr z,QUESTION5
 cp K_F2
 jr z,QUESTION5
 cp K_F3
 jr z,QUESTION5
 cp K_F4
 jr z,QUESTION5
 jr QKEYLP4 

Next:
 ld hl,NEXT
 ld bc,$340B
 call DISPV
 jp _getkey
 
SORTED:
 call SETSCRN
 ld hl,CONG
 ld bc,$0804
 call DISPV
 ld bc,$10
 call DISPV
 jr SORTNAME
SHOUSE:
 ld bc,$2010
 call DISPV
 call _getkey
 jp ProgStart

SORTNAME:
 ld a,1
 call $4613
 ld a,16
 call $4617
 call $5544
 call $5577
 cp 2
 jr z,SLYTHER
 cp 6
 jr z,GRYFFIN
 cp 10
 jr z,HUFFLE
 cp 14
 jr z,RAVEN
 jr SORTNAME

SLYTHER:
 ld hl,SLYTH
 jr SHOUSE

GRYFFIN:
 ld hl,GRYFF
 jr SHOUSE

HUFFLE:
 ld hl,HUFF
 jr SHOUSE

RAVEN:
 ld hl,RAVE
 jr SHOUSE

gr_pic_rle:
 call InitGrey      ;enable greyscale
 call ClearScreen
 ld hl,PIC1     ;this is the light layer of the picture
 ld de,$F000        ;and we put it to $f000 (first video ram)
 call DispRLE       ;decode rle-compressed data to 'de'
 ld hl,PIC2      ;same with darklayer
 ld de,$FC00        ;dark goes to $fc00

DispRLE:
 ld bc,1024         ; we need to copy 
DispRLEL:
 ld a,(hl)          ; get the next byte
 cp $91             ; is it a run?
 jr z,DispRLERun    ; then we need to decode the run
 ldi                ; copy the byte, and update counters
DispRLEC:
 ld a,b             ; check the low byte and
 or c               ; the high byte for 0
 jr nz,DispRLEL     ; if not, then we're not done either
 ret                ; if it's zero, we're done
DispRLERun:
 inc hl             ; move to the run value
 ld a,(hl)          ; get the run value
 inc hl             ; move to the run count
 push hl            ; save source pointer
 ld h,(hl)          ; get the run count
 ex de,hl           ; swap source and destination pointers
DispRLERunL:
 ld (hl),a          ; copy the byte
 inc hl             ; increase destination pointer
 dec bc             ; decrease byte count
 dec d              ; decrease run count
 jr nz,DispRLERunL  ; if we're not done, then loop
 ex de,hl           ; swap pointers back
 pop hl             ; recover source pointer
 inc hl             ; advance the source pointer
 jr DispRLEC        ; check to see if we should loop

;=========== Routine for displaying a not compressed picture ============
; hl: video ram
; de: picture data
; a:  picture height (width has to be 64)

LoadPic:
 ld b,a
pNextLine:
 push bc
 ld b,16         ; there are 16 bytes in each line
pNextByte:
 ld a,(de)
 ld (hl),a           ; get byte and copy to vid mem
 inc de          ; increment our de
 inc hl          ; inc out hl
 djnz pNextByte
 pop bc
 djnz pNextLine
 ret


;=================== Greyscalemode routines made by SCaBBy ===================
InitGrey:
 call ClearGreyBuffer
 ld hl,IHandler
 ld de,0BCBCh ;0D2FEh
 ld bc,IHandlerEnd-IHandler
 ldir
 ld hl,0BD00h
 ld de,0BD01h
 ld bc,256
 ld (hl),0BCh
 ldir
 ld a,0BDh
 ld i,a
 im 2
 ret

ClearScreen:
 call _clrLCD
ClearGreyBuffer:
 ld hl,GreyBuffer
 ld de,GreyBuffer+1
 ld bc,3FFh
 ld (hl),0
 ldir
 ret

DeinitGrey:
 im 1
 ld a,3Ch
 out (0),a
 ret

IHandler:
 exx
 ex af,af'
 ld hl,Timer
 inc (hl)
 in a,(3)
 bit 1,a
 jr z,notvbl
 ld hl,GreyCounter
 inc (hl)
 ld a,(hl)
 cp 3
 ld a,3Ch
 jr nz,notpage1
 ld (hl),0
 ld a,(GreyBuffer/256)-0C0h
notpage1:
 out (0),a
notvbl:
 jp 3Ah
IHandlerEnd:
GreyCounter .db 0
Timer       =0BCFFh
GreyBuffer  =0F000h

;=================== Greyscale Putsprite routine made by SCaBBy ===================
PutMaskedSprite:
 ld ix,BlankMask
grPutSprite:
 ld d,0
 ld a,c
 add a,a
 add a,a
 rl d
 add a,a
 rl d
 add a,a
 rl d
 ld e,b
 srl e
 srl e
 srl e
 or e
 ld e,a
 ld a,b
 and 7
 inc a
 ld b,a
 dec d
 dec d
 dec d
 dec d
 ld c,16
 ex de,hl
 push hl
 push de
 ld de,GreyBuffer-0FC00h
 add hl,de
 pop de
DoPutMaskedSprite:
 push bc
 ld a,h
 cp 0FCh
 ld a,(ix)
 jr c,NotIncIX
 inc ix
NotIncIX:
 ld c,255
 ex de,hl
 push hl
 ld h,(hl)
 ld l,0
 dec b
 jr z,DontRotateMaskedSprite
RotateMaskedSprite:
 scf
 rra
 rr c
 srl h
 rr l    
 djnz RotateMaskedSprite
DontRotateMaskedSprite:
 ex de,hl
 and (hl)
 xor d
 ld (hl),a
 inc hl
 ld a,c
 and (hl)
 xor e
 ld (hl),a
 ld bc,15
 add hl,bc
 pop de
 inc de
 pop bc
 ex (sp),hl
 dec c
 jr nz,DoPutMaskedSprite
 pop hl
 ret

EXIT:
 call _getkey       ;wait for keypress
 call _clrLCD
 call DeinitGrey
 call _clrLCD
 call _homeup
 res textInverse,(iy+textflags)
 ld hl,EXITT
 jp DISPV
 
;***Text and Graphics Data***
BlankMask:
.db 0,0,0,0,0,0,0,0

CONG:
.db "Congratulations & Welcome",0
.db "You have been sorted into...",0 
SLYTH:
.db "Slytherin",0
RAVE:
.db "Ravenclaw",0
HUFF:
.db "Hufflepuff",0
GRYFF:
.db "Gryffindor",0

PIC1:
.db $F0,$01,$91,$00,$05,$1F,$91,$FF,$03,$C0,$91,$00,$03,$30,$F0,$03,$91,$00,$05,$0F
.db $91,$FF,$03,$C0,$91,$00,$03,$F0,$E0,$01,$91,$00,$05,$0F,$91,$FF,$03,$C0,$00,$00
.db $07,$FF,$E0,$91,$00,$06,$03,$C3,$FF,$FF,$80,$00,$00,$07,$FF,$C0,$91,$00,$06,$E3
.db $C0,$FF,$FF,$C0,$01,$00,$07,$FF,$91,$00,$07,$3F,$80,$FF,$FF,$C0,$00,$00,$07,$FC
.db $91,$00,$07,$1C,$00,$3F,$FC,$E0,$00,$00,$07,$F8,$91,$00,$07,$1B,$00,$07,$F0,$91
.db $00,$03,$0F,$F0,$91,$00,$07,$0F,$00,$1F,$91,$00,$03,$3C,$07,$FF,$91,$00,$07,$07
.db $00,$1E,$91,$00,$03,$3C,$07,$FF,$91,$00,$08,$07,$C3,$91,$00,$03,$3C,$07,$FF,$91
.db $00,$07,$C7,$FE,$FE,$C0,$00,$00,$18,$07,$FF,$91,$00,$06,$01,$91,$FF,$03,$E0,$00
.db $00,$18,$01,$FF,$91,$00,$06,$03,$91,$FF,$03,$F8,$00,$00,$18,$00,$FF,$91,$00,$06
.db $07,$91,$FF,$03,$FE,$00,$00,$18,$00,$FF,$91,$00,$06,$07,$FF,$F0,$0F,$C7,$C0,$00
.db $20,$00,$FD,$91,$00,$06,$10,$70,$00,$FE,$0C,$F0,$00,$20,$00,$60,$91,$00,$03,$07
.db $FF,$F0,$1F,$0E,$C0,$20,$C7,$30,$00,$70,$91,$00,$05,$91,$FF,$03,$1F,$E0,$00,$00
.db $61,$F0,$91,$00,$06,$0F,$91,$FF,$03,$F8,$7F,$FF,$F0,$1C,$60,$91,$00,$06,$0F,$91
.db $FF,$04,$CF,$C0,$06,$07,$10,$91,$00,$06,$1F,$91,$FF,$04,$FC,$07,$0F,$00,$C0,$91
.db $00,$06,$1F,$91,$FF,$05,$C0,$00,$08,$60,$91,$00,$06,$0F,$91,$FF,$06,$80,$91,$00
.db $08,$0F,$91,$FF,$06,$FC,$91,$00,$04,$07,$91,$00,$03,$07,$91,$FF,$08,$91,$00,$04
.db $E0,$00,$00,$03,$91,$FF,$0C,$F0,$00,$00,$01,$91,$FF,$0C,$F0,$91,$00,$03,$91,$FF
.db $0C,$F0,$91,$00,$03,$7F,$91,$FF,$0B,$F0,$91,$00,$03,$3F,$91,$FF,$0B,$E0,$91,$00
.db $03,$3F,$91,$FF,$0B,$F0,$91,$00,$03,$1F,$91,$FF,$04,$E3,$FF,$9F,$91,$FF,$04,$E0
.db $91,$00,$03,$1F,$91,$FF,$03,$EC,$61,$3F,$FB,$91,$FF,$04,$E0,$91,$00,$03,$0F,$91
.db $FF,$03,$80,$C0,$00,$C1,$91,$FF,$04,$E0,$91,$00,$03,$0F,$FF,$FF,$FE,$00,$80,$C0
.db $8F,$91,$FF,$04,$E0,$91,$00,$03,$0F,$FF,$FF,$FC,$32,$00,$01,$03,$91,$FF,$04,$E0
.db $91,$00,$03,$07,$FF,$FF,$FC,$91,$00,$03,$03,$91,$FF,$04,$E0,$91,$00,$03,$03,$FF
.db $FF,$FE,$80,$00,$00,$0F,$91,$FF,$04,$C0,$80,$00,$00,$01,$FF,$FF,$FE,$00,$F7,$00
.db $07,$91,$FF,$04,$C0,$C0,$91,$00,$03,$91,$FF,$03,$80,$7F,$00,$17,$91,$FF,$03,$DF
.db $80,$C0,$91,$00,$03,$FF,$FF,$FE,$91,$00,$03,$1F,$91,$FF,$04,$00,$E0,$91,$00,$03
.db $7F,$FF,$FE,$91,$00,$03,$0F,$91,$FF,$03,$FE,$1E,$E0,$39,$C0,$00,$1F,$FF,$FF,$91
.db $00,$03,$07,$91,$FF,$03,$EC,$1F,$F0,$1F,$80,$03,$9F,$FF,$FC,$00,$FF,$00,$07,$91
.db $FF,$03,$FA,$1F,$30,$3F,$C0,$03,$FF,$FF,$FE,$03,$E7,$80,$07,$91,$FF,$03,$F1,$1F
.db $38,$3F,$C1,$03,$91,$FF,$03,$C0,$3C,$00,$07,$91,$FF,$03,$B8,$1F,$18,$1E,$01,$83
.db $EF,$FF,$FE,$91,$00,$03,$07,$91,$FF,$03,$80,$1F,$0C,$08,$01,$00,$6F,$FF,$FF,$80
.db $00,$00,$07,$91,$FF,$03,$00,$1F,$0C,$91,$00,$03,$2F,$FF,$FF,$91,$00,$03,$07,$91
.db $FF,$03,$00,$1F,$06,$91,$00,$03,$07,$FF,$FF,$91,$00,$03,$07,$91,$FF,$03,$00,$1F
.db $06,$30,$00,$00,$07,$FF,$FF,$80,$00,$00,$07,$FF,$FC,$FF,$00,$1F,$07,$D8,$00,$00
.db $3F,$FF,$FF,$80,$00,$00,$87,$FF,$F8,$3F,$00,$1F,$07,$FC,$00,$60,$FB,$FF,$FF,$80
.db $00,$03,$0F,$FF,$F0,$3F,$00,$1F,$03,$FF,$FF,$F7,$FB,$FF,$FF,$90,$00,$00,$0F,$FF
.db $71,$7F,$00,$1F,$03,$91,$FF,$03,$9F,$FF,$FF,$86,$00,$38,$0F,$FF,$78,$27,$00,$1F
.db $00,$EF,$F0,$1F,$F7,$FF,$7F,$07,$0E,$E0,$0F,$FF,$79,$8F,$00,$1F,$00,$01,$E0,$0F
.db $91,$FF,$03,$81,$FF,$00,$07,$FF,$FF,$DF,$00,$1F,$91,$00,$03,$07,$91,$FF,$03,$91
.db $00,$03,$07,$FF,$FF,$89,$00,$1F,$91,$00,$03,$07,$91,$FF,$03,$91,$00,$03,$03,$FF
.db $FF,$81,$00,$1F,$91,$00,$03,$07,$FF,$FF,$FE,$80,$00,$00,$03,$FF,$FF,$DF,$00,$1F
.db $91,$00,$03,$07,$FF,$FF,$FE,$91,$00,$03,$01,$91,$FF,$03,$00,$1F,$91,$00,$03,$07
.db $FF,$FF,$FE,$91,$00,$03,$01,$91,$FF,$03,$00,$1F,$C0,$00,$00,$07,$FF,$FF,$FE,$91
.db $00,$04,$91,$FF,$03,$00,$1F
;1024 bytes compressed to 867 -- 84% of original.

PIC2:
.db $91,$FF,$FF,$91,$FF,$FF,$91,$FF,$D0,$FD,$91,$FF,$0F,$FE,$91,$FF,$0F,$E7,$91,$FF
.db $FF,$91,$FF,$12
;1024 bytes compressed to 24 -- 2% of original.

HELPT:
.db "Helpful Keys:",0
.db "EXIT=exit",0
.db "F1=a",0
.db "F2=b",0
.db "F3=c",0
  
HELPT2:
.db "F4=d",0
.db "http://harrypotter.war",0
.db "nerbros.com/web/hogwa",0
.db "rts/sorting_hat.jsp",0
  
ABOUTT:
.db "Sorting Houses:",0
.db "1.Gryffindor",0
.db "2.Hufflepuff",0
.db "3.Ravenclaw",0
.db "4.Slythterin",0

MAIN:
.db "The  Sorting  Hat",0
.db "Harry Potter Series",0
.db "Start",0
.db "Legal",0 
.db "About",0
.db "Help",0
.db "Quit",0
  
EXITT:
.db "Really Bored Productions 2",0
  
SORTT1:
.db "Oh you may not",0
.db "think I'm pretty",0
.db "but don't judge on",0
.db "what",0
.db "you see",0

SORTT2:
.db "I'll eat myself if you",0
.db "can find",0
.db "a smarter hat than",0
.db "me",0

SORTT3:
.db "There's nothing",0
.db "the Sorting Hat",0
.db "hidden in your head",0
.db "can't see",0

SORTT4:
.db "So try me on and I",0
.db "where you ought",0
.db "will tell you",0
.db "to be",0

SORTT5:
.db "To complete the",0
.db "Sorting Ceremony",0
.db "please answer the",0
.db "following questions.",0

QUES1:
.db "Which spell would",0
.db "you most like to",0
.db "cast on yourself?",0
.db "a.invisibiltiy",0
.db "b.ability to fly",0
.db "c.super strength",0
.db "d.transfiguration",0

QUES2:
.db "Which flavor of",0
.db "Bertie Botts Beans",0
.db "would you prefer?",0
.db "a.spinach",0
.db "b.horse radish",0
.db "c.lima bean",0
.db "d.chocalate",0

QUES3:
.db "Which animal would",0
.db "you choose for your",0
.db "Hogwarts pet?",0
.db "a.owl",0
.db "b.rat",0
.db "c.frog",0
.db "d.tree monkey",0

QUES4:
.db "Which Quidditch",0
.db "position would you",0
.db "most like to play?",0
.db "a.chaser",0
.db "b.keeper",0
.db "c.seeker",0
.db "d.referee",0

QUES5:
.db "If you found a",0
.db "satchel of Galleons,",0
.db "what would you do?",0
.db "a.return it",0
.db "b.donate it",0
.db "c.save it",0
.db "d.spend it",0

NPSO:
.db "Now Prepare to",0
.db "be sorted...",0
.db "Press any key",0

NEXT:
.db "next",0

DISCLAIM:
.db "!!DISCLAIMER!!",0

DISCLAIM2:
.db "HARRY POTTER,characters,",0
.db "names and related indicia",0
.db "logo and related indicia",0
.db "and WARNER BROS.,shield",0
 
DISCLAIM3:
.db "are trademarks of Warner",0
.db "Bros. TM 2002.Harry",0
.db "Potter Publishing Rights",0
.db "J.K. Rowling",0

.end
