// TurboSoft's first C program! (with the help of a couple people)
// A simple getkey program, with ALL lines commented (geared for TI-Basic users)

#include <romcalls.h>	// include file for rom calls

#define clr_scr	graphlib__0005	// any library calls used in the
#define idle_loop userlib__0000	// program have to be defined

int _ti89,_ti92plus;	// compiles for TI-89 and TI-92plus

 _main()	// always put this, start of code
{
 char str[7];	// creates an array (kinda like a list) with SIX cells for data, plus a seventh cell as a null character
 int key;	// makes the integer variable key available for use, and all variables like this MUST be declared before geting into functions

 clr_scr();	// clears the screen

 DrawStr(0,2,"getkey code:",0);	// prints text in parenthesis at 0,2

 FontSetSys(2);	// sets font size to big (small is 0, normal is 1, big is 2)

 while (key != 267)	// starts a while loop, and repeats what's in these brackets while key is unequal to 267 (the ON key)
 {
  key = idle_loop();	// puts the value of idle_loop() into key, sort of like getkey()->key
  sprintf(str,"%6d",key);	// converts the integer in key into an array, str.  For the second argument, "%d" would normally just convert key into an array, str.  But "%6d" does this AND adds spaces to the beginning of key, so that the array str is always 6 char.s long (unless key has more than 6 digits)
  DrawStr(78,1,str,4);	// prints out array, str.  Each char is stored into a cell of str.  Because no cell is defined (ex: str[2]) it prints out all of str.
 }
 idle_loop();	// waits, so that the user could see that the ON button is equal to 267
}