#include "Ti86asm.inc"  ; System procedures

; ===============================================
;  TI-86 Interactive Character Map
; -----------------------------------------------
;  by Andy Kornaus ~ racraccoon@yahoo.com
; ===============================================
;  Returns:
;   A string variable with the value selected,
;   named Char.
; ===============================================

CharacterBackup equ $C10D

.org    _asm_exec_ram

main:
    call    _runindicoff    ; Turn off run indicator
    
    call    _clrLCD         ; Clear screen
    ld  hl, $0001           ; Set coords at col 0, row 1
    ld  (_curRow),  hl      ; Set coords
    ld  hl,title            ; point to title
    call    _puts           ; put string
loop:
    call    _get_key        ; pause... press any key
    cp  $0
    jr  z,  loop
    call    _clrLCD         ; clear screen
    ld  b,  $0              ; start display index
    ld  d,  $0              ; current highlighted section index
    ld  e,  $0              ; current character

display:
    ld  hl, $0000
disploop:
    ld  a,  d
    cp  l                   ; Is the current line highlighted?
    jr  z,  highlight
    res 3,(iy+5)            ; Normal text
    jr  dispnum
highlight:
    set 3,(iy+5)            ; Inverted text
dispnum:
    ld  (_curRow),  hl
    call    hex             ; Display the hex num
    ld  a,  l
    cp  $0                  ; Is the current line the top line?
    jr  z,  top
    cp  $7                  ; Is it the bottom line?
    jr  z,  bottom
middle:                     ; Not the top or bottom
    ld  a,  $3A             ; Use the colon (:)
    jr  dispchar
top:
    ld  a,  b
    cp  $0                  ; Are we at the very top?
    jr  z,  middle          ; If so, use colon
    ld  a,  $1E             ; Otherwise, use up arrow saying
    jr  dispchar            ; that there's more above
bottom:
    ld  a,  b
    cp  $F8                 ; Did we reach the very bottom?
    jr  z,  middle          ; Then use colon
    ld  a,  $1F             ; Or, use down arrow if there's more
dispchar:
    call    _putc           ; This puts either the colon or arrow, really
    ld  a,  b               ; Find the current value
    add a,  l
    call    _putc           ; Display it. This part was simple!
    inc l                   ; Advance a line
    ld  a,  l
    cp  $08                 ; Are we finished?
    jr  nz, disploop

keyloop:
    call    _get_key        ; Store keystroke in a
    cp  K_DOWN
    jr  z,  downkey
    cp  K_UP
    jr  z,  upkey
    cp  K_ENTER
    jr  z,  select
    cp  K_EXIT
    jr  z,  exit
    jr  keyloop
downkey:
    ld  a,  e
    cp  $FF             ; Are we currently at the last character?
    jr  z,  keyloop     ; Then ignore the keypress
    inc e               ; Else, go to next character
    ld  a,  d
    cp  $7              ; Can we scroll the selector down?
    jr  z,  scrldown
    inc d               ; Yes, move it
    jr  display
scrldown:
    inc b               ; No, slide menu down
    jr  display
upkey:
    ld  a,  e
    cp  $00             ; Are we at the top?
    jr  z,  keyloop     ; Then ignore the keypress
    dec e               ; Else, go to previous character
    ld  a,  d
    cp  $0              ; Can we scroll the selector up?
    jr  z,  scrlup
    dec d               ; Yes, move it
    jr  display
scrlup:
    dec b               ; No, slide menu up
    jr  display         ; Amazing we can still use a relative jump!
select:
    ld  hl, CharacterBackup
    ld  (hl),   e           ; Back up our character
    ld  hl, str
    call    _mov10toop1
    call    _findsym        ; Try to find our variable
    jr  nc, charexists      ; If it exists, go right to editing it
    ld  hl, $0001
    call    _createstrng    ; Else, create it
charexists:
    ld  hl, CharacterBackup
    ld  c,  (hl)            ; Restore our character
    call    _ex_ahl_bde
    call    _load_ram_ahl
    inc hl \ inc hl         ; Get our pointer in the right spot
    ld  (hl),   c           ; Write our character into it
    ld  a,  $1              ; This is used to tell exit that it should display
                            ; "x" is stored in Char
exit:
    res 3,(iy+5)        ; Set normal text
                        ; If the last line was highlighted, the text will still be
                        ; inverted after you exit. Cool, but annoying after a while :)
    call    _clrLCD     ; Clear screen and text shadow
    ld  hl, CharacterBackup
    ld  e,  (hl)
    ld  hl, $0000
    ld  (_curRow),  hl
    cp  $1              ; Did user select a character?
    jr  nz, finish      ; If not, skip "x" is stored in Char
    ld  a,  $22
    call    _putc
    ld  a,  e
    call    _putc
    ld  a,  $22
    call    _putc
    ld  hl, theend
    call    _puts
finish:
    ret         ; End program

; A routine to display a two-digit hexadecimal number
hex:
    ld  a,  b       ;__ Find current line num
    add a,  l       ;
    ld  c,  a       ; Store a backup
    and %11110000   ; Focus on the first four bits
    rra             ; Move these to the right, so we can call findhex
    rra
    rra
    rra
    call    findhex ; Find the hex value in a and display it
    call    _putc
    ld  a,  c       ; Restore a
    and %00001111   ; Focus only on the last four bits
    call    findhex ; We can call findhex right away
    call    _putc
    ret    

findhex:            ; Find hexadecimal value....
    cp  %00000000
    jr  z,  hex0
    cp  %00000001
    jr  z,  hex1
    cp  %00000010
    jr  z,  hex2
    cp  %00000011
    jr  z,  hex3
    cp  %00000100
    jr  z,  hex4
    cp  %00000101
    jr  z,  hex5
    cp  %00000110
    jr  z,  hex6
    cp  %00000111
    jr  z,  hex7
    cp  %00001000
    jr  z,  hex8
    cp  %00001001
    jr  z,  hex9
    cp  %00001010
    jr  z,  hexA
    cp  %00001011
    jr  z,  hexB
    cp  %00001100
    jr  z,  hexC
    cp  %00001101
    jr  z,  hexD
    cp  %00001110
    jr  z,  hexE
    cp  %00001111
    jr  z,  hexF

hex0:   ld  a,  $30 \ ret   ; ....and store it in a
hex1:   ld  a,  $31 \ ret
hex2:   ld  a,  $32 \ ret
hex3:   ld  a,  $33 \ ret
hex4:   ld  a,  $34 \ ret
hex5:   ld  a,  $35 \ ret
hex6:   ld  a,  $36 \ ret
hex7:   ld  a,  $37 \ ret
hex8:   ld  a,  $38 \ ret
hex9:   ld  a,  $39 \ ret
hexA:   ld  a,  $41 \ ret
hexB:   ld  a,  $42 \ ret
hexC:   ld  a,  $43 \ ret
hexD:   ld  a,  $44 \ ret
hexE:   ld  a,  $45 \ ret
hexF:   ld  a,  $46 \ ret

; Data
title:
    .db " ","",5,"86 Character Map",""," ",0

theend:
    .db " is stored in Char",0

str:
    .db $00, $04, $43, $68, $61, $72, $00, $00, $00, $00

.end